/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver;

import java.util.Arrays;
import org.jkiss.dbeaver.bundle.ModelActivator;
import org.jkiss.dbeaver.model.DBConstants;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.impl.preferences.BundlePreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMObjectType;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.osgi.framework.Bundle;

public final class ModelPreferences {
    public static final String QUERY_ROLLBACK_ON_ERROR = "query.rollback-on-error";
    public static final String EXECUTE_RECOVER_ENABLED = "execute.recover.enabled";
    public static final String EXECUTE_RECOVER_RETRY_COUNT = "execute.recover.retryCount";
    public static final String SCRIPT_STATEMENT_DELIMITER = "script.sql.delimiter";
    public static final String SCRIPT_IGNORE_NATIVE_DELIMITER = "script.sql.ignoreNativeDelimiter";
    public static final String SCRIPT_STATEMENT_DELIMITER_BLANK = "script.sql.delimiter.blank";
    public static final String QUERY_REMOVE_TRAILING_DELIMITER = "script.sql.query.remove.trailing.delimiter";
    public static final String MEMORY_CONTENT_MAX_SIZE = "content.memory.maxsize";
    public static final String CONTENT_HEX_ENCODING = "content.hex.encoding";
    public static final String CONTENT_CACHE_CLOB = "content.cache.clob";
    public static final String CONTENT_CACHE_BLOB = "content.cache.blob";
    public static final String CONTENT_CACHE_MAX_SIZE = "content.cache.maxsize";
    public static final String META_SEPARATE_CONNECTION = "database.meta.separate.connection";
    public static final String META_CASE_SENSITIVE = "database.meta.casesensitive";
    public static final String META_USE_SERVER_SIDE_FILTERS = "database.meta.server.side.filters";
    public static final String META_CLIENT_NAME_DISABLE = "database.meta.client.name.disable";
    public static final String META_CLIENT_NAME_OVERRIDE = "database.meta.client.name.override";
    public static final String META_CLIENT_NAME_VALUE = "database.meta.client.name.value";
    public static final String CONNECT_USE_ENV_VARS = "database.connect.processEnvVars";
    public static final String RESULT_TRANSFORM_COMPLEX_TYPES = "resultset.transform.complex.type";
    public static final String NET_TUNNEL_PORT_MIN = "net.tunnel.port.min";
    public static final String NET_TUNNEL_PORT_MAX = "net.tunnel.port.max";
    public static final String RESULT_SET_USE_FETCH_SIZE = "resultset.fetch.size";
    public static final String RESULT_SET_MAX_ROWS_USE_SQL = "resultset.maxrows.sql";
    public static final String RESULT_SET_BINARY_PRESENTATION = "resultset.binary.representation";
    public static final String RESULT_SET_BINARY_STRING_MAX_LEN = "resultset.binary.stringMaxLength";
    public static final String RESULT_SET_IGNORE_COLUMN_LABEL = "resultset.column.label.ignore";
    public static final String SQL_PARAMETERS_ENABLED = "sql.parameter.enabled";
    public static final String SQL_PARAMETERS_IN_DDL_ENABLED = "sql.parameter.ddl.enabled";
    public static final String SQL_ANONYMOUS_PARAMETERS_ENABLED = "sql.parameter.anonymous.enabled";
    public static final String SQL_ANONYMOUS_PARAMETERS_MARK = "sql.parameter.mark";
    public static final String SQL_NAMED_PARAMETERS_PREFIX = "sql.parameter.prefix";
    public static final String SQL_CONTROL_COMMAND_PREFIX = "sql.command.prefix";
    public static final String SQL_VARIABLES_ENABLED = "sql.variables.enabled";
    public static final String SQL_FORMAT_FORMATTER = "sql.format.formatter";
    public static final String SQL_FORMAT_KEYWORD_CASE = "sql.format.keywordCase";
    public static final String SQL_FORMAT_EXTERNAL_CMD = "sql.format.external.cmd";
    public static final String SQL_FORMAT_EXTERNAL_FILE = "sql.format.external.file";
    public static final String SQL_FORMAT_EXTERNAL_TIMEOUT = "sql.format.external.timeout";
    public static final String PLUGIN_ID = "org.jkiss.dbeaver.model";
    private static Bundle mainBundle;
    private static DBPPreferenceStore preferences;

    public static synchronized DBPPreferenceStore getPreferences() {
        if (preferences == null) {
            ModelPreferences.setMainBundle(ModelActivator.getInstance().getBundle());
        }
        return preferences;
    }

    public static void setMainBundle(Bundle mainBundle) {
        ModelPreferences.mainBundle = mainBundle;
        preferences = new BundlePreferenceStore(mainBundle);
        ModelPreferences.initializeDefaultPreferences(preferences);
    }

    private static void initializeDefaultPreferences(DBPPreferenceStore store) {
        PrefUtils.setDefaultPreferenceValue(store, QUERY_ROLLBACK_ON_ERROR, false);
        PrefUtils.setDefaultPreferenceValue(store, EXECUTE_RECOVER_ENABLED, false);
        PrefUtils.setDefaultPreferenceValue(store, EXECUTE_RECOVER_RETRY_COUNT, 1);
        PrefUtils.setDefaultPreferenceValue(store, SCRIPT_STATEMENT_DELIMITER, ";");
        PrefUtils.setDefaultPreferenceValue(store, SCRIPT_IGNORE_NATIVE_DELIMITER, false);
        PrefUtils.setDefaultPreferenceValue(store, SCRIPT_STATEMENT_DELIMITER_BLANK, true);
        PrefUtils.setDefaultPreferenceValue(store, QUERY_REMOVE_TRAILING_DELIMITER, true);
        PrefUtils.setDefaultPreferenceValue(store, MEMORY_CONTENT_MAX_SIZE, 10000);
        PrefUtils.setDefaultPreferenceValue(store, META_SEPARATE_CONNECTION, true);
        PrefUtils.setDefaultPreferenceValue(store, META_CASE_SENSITIVE, false);
        PrefUtils.setDefaultPreferenceValue(store, META_USE_SERVER_SIDE_FILTERS, true);
        PrefUtils.setDefaultPreferenceValue(store, META_CLIENT_NAME_DISABLE, false);
        PrefUtils.setDefaultPreferenceValue(store, META_CLIENT_NAME_OVERRIDE, false);
        PrefUtils.setDefaultPreferenceValue(store, META_CLIENT_NAME_VALUE, "");
        PrefUtils.setDefaultPreferenceValue(store, CONNECT_USE_ENV_VARS, false);
        PrefUtils.setDefaultPreferenceValue(store, RESULT_TRANSFORM_COMPLEX_TYPES, true);
        PrefUtils.setDefaultPreferenceValue(store, CONTENT_HEX_ENCODING, GeneralUtils.getDefaultFileEncoding());
        PrefUtils.setDefaultPreferenceValue(store, CONTENT_CACHE_CLOB, true);
        PrefUtils.setDefaultPreferenceValue(store, CONTENT_CACHE_BLOB, false);
        PrefUtils.setDefaultPreferenceValue(store, CONTENT_CACHE_MAX_SIZE, 1000000);
        PrefUtils.setDefaultPreferenceValue(store, NET_TUNNEL_PORT_MIN, 10000);
        PrefUtils.setDefaultPreferenceValue(store, NET_TUNNEL_PORT_MAX, 60000);
        PrefUtils.setDefaultPreferenceValue(store, RESULT_SET_MAX_ROWS_USE_SQL, false);
        PrefUtils.setDefaultPreferenceValue(store, RESULT_SET_BINARY_PRESENTATION, DBConstants.BINARY_FORMATS[0].getId());
        PrefUtils.setDefaultPreferenceValue(store, RESULT_SET_BINARY_STRING_MAX_LEN, 32);
        PrefUtils.setDefaultPreferenceValue(store, RESULT_SET_USE_FETCH_SIZE, false);
        PrefUtils.setDefaultPreferenceValue(store, RESULT_SET_IGNORE_COLUMN_LABEL, false);
        PrefUtils.setDefaultPreferenceValue(store, "qm.historyDays", 90);
        PrefUtils.setDefaultPreferenceValue(store, "qm.maxEntries", 200);
        PrefUtils.setDefaultPreferenceValue(store, "qm.objectTypes", QMObjectType.toString(Arrays.asList(QMObjectType.txn, QMObjectType.query)));
        PrefUtils.setDefaultPreferenceValue(store, "qm.queryTypes", (Object)((Object)DBCExecutionPurpose.USER) + "," + (Object)((Object)DBCExecutionPurpose.USER_FILTERED) + "," + (Object)((Object)DBCExecutionPurpose.USER_SCRIPT));
        PrefUtils.setDefaultPreferenceValue(store, "qm.storeLogs", false);
        PrefUtils.setDefaultPreferenceValue(store, "qm.logDirectory", GeneralUtils.getMetadataFolder().getAbsolutePath());
        PrefUtils.setDefaultPreferenceValue(store, SQL_PARAMETERS_ENABLED, true);
        PrefUtils.setDefaultPreferenceValue(store, SQL_PARAMETERS_IN_DDL_ENABLED, false);
        PrefUtils.setDefaultPreferenceValue(store, SQL_ANONYMOUS_PARAMETERS_ENABLED, false);
        PrefUtils.setDefaultPreferenceValue(store, SQL_ANONYMOUS_PARAMETERS_MARK, String.valueOf('?'));
        PrefUtils.setDefaultPreferenceValue(store, SQL_NAMED_PARAMETERS_PREFIX, String.valueOf(':'));
        PrefUtils.setDefaultPreferenceValue(store, SQL_CONTROL_COMMAND_PREFIX, String.valueOf("@"));
        PrefUtils.setDefaultPreferenceValue(store, SQL_VARIABLES_ENABLED, false);
        PrefUtils.setDefaultPreferenceValue(store, SQL_FORMAT_FORMATTER, "DEFAULT");
        PrefUtils.setDefaultPreferenceValue(store, SQL_FORMAT_KEYWORD_CASE, "");
        PrefUtils.setDefaultPreferenceValue(store, SQL_FORMAT_EXTERNAL_CMD, "");
        PrefUtils.setDefaultPreferenceValue(store, SQL_FORMAT_EXTERNAL_FILE, false);
        PrefUtils.setDefaultPreferenceValue(store, SQL_FORMAT_EXTERNAL_TIMEOUT, 2000);
    }
}

