/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core.application.update;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.core.application.update.CheckForUpdateAction;
import org.jkiss.dbeaver.registry.updater.VersionDescriptor;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

class VersionUpdateDialog
extends Dialog {
    private VersionDescriptor newVersion;
    private static final int INFO_ID = 1000;
    private Font boldFont;

    public VersionUpdateDialog(Shell parentShell, VersionDescriptor newVersion) {
        super(parentShell);
        this.newVersion = newVersion;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(CoreMessages.dialog_version_update_title);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, false));
        Group propGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.dialog_version_update_title, (int)2, (int)1808, (int)0);
        this.boldFont = UIUtils.makeBoldFont((Font)composite.getFont());
        Label titleLabel = new Label((Composite)propGroup, 0);
        titleLabel.setText(this.newVersion == null ? CoreMessages.dialog_version_update_no_new_version : CoreMessages.dialog_version_update_available_new_version);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        titleLabel.setLayoutData((Object)gd);
        titleLabel.setFont(this.boldFont);
        String versionStr = GeneralUtils.getProductVersion().toString();
        UIUtils.createControlLabel((Composite)propGroup, (String)CoreMessages.dialog_version_update_current_version);
        new Label((Composite)propGroup, 0).setText(versionStr);
        UIUtils.createControlLabel((Composite)propGroup, (String)CoreMessages.dialog_version_update_new_version);
        new Label((Composite)propGroup, 0).setText(this.newVersion == null ? versionStr : String.valueOf(this.newVersion.getProgramVersion().toString()) + "    (" + this.newVersion.getUpdateTime() + ")");
        if (this.newVersion != null) {
            Label notesLabel = UIUtils.createControlLabel((Composite)propGroup, (String)CoreMessages.dialog_version_update_notes);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            notesLabel.setLayoutData((Object)gd);
            Label notesText = new Label((Composite)propGroup, 0);
            notesText.setText(this.newVersion.getReleaseNotes());
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            notesText.setLayoutData((Object)gd);
            Label hintLabel = new Label((Composite)propGroup, 0);
            hintLabel.setText(CoreMessages.dialog_version_update_press_more_info_);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            hintLabel.setLayoutData((Object)gd);
            hintLabel.setFont(this.boldFont);
        }
        return parent;
    }

    public boolean close() {
        this.boldFont.dispose();
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.newVersion != null) {
            this.createButton(parent, 1000, CoreMessages.dialog_version_update_button_more_info, true);
        }
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, this.newVersion == null);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1000) {
            if (this.newVersion != null) {
                UIUtils.launchProgram((String)this.newVersion.getBaseURL());
            }
        } else if (buttonId == 10) {
            IWorkbenchWindow window = DBeaverUI.getActiveWorkbenchWindow();
            CheckForUpdateAction.activateStandardHandler(window);
            try {
                ActionUtils.runCommand((String)"org.eclipse.equinox.p2.ui.sdk.update", (IServiceLocator)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
            finally {
                CheckForUpdateAction.deactivateStandardHandler(window);
            }
        }
        this.close();
    }
}

