/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.tools;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.registry.encode.EncryptionException;
import org.jkiss.dbeaver.registry.encode.SecuredPasswordEncrypter;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.BaseAuthDialog;
import org.jkiss.dbeaver.ui.dialogs.tools.AbstractToolWizard;
import org.jkiss.dbeaver.ui.dialogs.tools.AbstractToolWizardPage;

public class ExasolWizardPageSettings<WIZARD extends AbstractToolWizard>
extends AbstractToolWizardPage<WIZARD> {
    public ExasolWizardPageSettings(WIZARD wizard, String title) {
        super(wizard, title);
    }

    public void createSecurityGroup(Composite parent) {
        try {
            String authCredentials;
            int divPos;
            final SecuredPasswordEncrypter encrypter = new SecuredPasswordEncrypter();
            final DBPConnectionConfiguration connectionInfo = this.wizard.getConnectionInfo();
            final String authProperty = "@dbeaver--auth-" + this.wizard.getObjectsName() + "@";
            String authUser = null;
            String authPassword = null;
            String authValue = connectionInfo.getProperty(authProperty);
            if (authValue != null && (divPos = (authCredentials = encrypter.decrypt(authValue)).indexOf(58)) != -1) {
                authUser = authCredentials.substring(0, divPos);
                authPassword = authCredentials.substring(divPos + 1);
            }
            this.wizard.setToolUserName(authUser == null ? connectionInfo.getUserName() : authUser);
            this.wizard.setToolUserPassword(authPassword == null ? connectionInfo.getUserPassword() : authPassword);
            final boolean savePassword = authUser != null;
            Group securityGroup = UIUtils.createControlGroup((Composite)parent, (String)"Security", (int)2, (int)32, (int)0);
            Label infoLabel = new Label((Composite)securityGroup, 0);
            infoLabel.setText("Override user credentials (" + this.wizard.getConnectionInfo().getUserName() + ") for objects '" + this.wizard.getObjectsName() + "'.\nExternal tools like 'mysqldump' may require different set of permissions.");
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            infoLabel.setLayoutData((Object)gd);
            Button authButton = new Button((Composite)securityGroup, 8);
            authButton.setText("Authentication");
            authButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BaseAuthDialog authDialog = new BaseAuthDialog(ExasolWizardPageSettings.this.getShell(), "Authentication", false);
                    authDialog.setUserName(ExasolWizardPageSettings.this.wizard.getToolUserName());
                    authDialog.setUserPassword(ExasolWizardPageSettings.this.wizard.getToolUserPassword());
                    authDialog.setSavePassword(savePassword);
                    if (authDialog.open() == 0) {
                        ExasolWizardPageSettings.this.wizard.setToolUserName(authDialog.getUserName());
                        ExasolWizardPageSettings.this.wizard.setToolUserPassword(authDialog.getUserPassword());
                        if (authDialog.isSavePassword()) {
                            try {
                                connectionInfo.setProperty(authProperty, encrypter.encrypt(String.valueOf(ExasolWizardPageSettings.this.wizard.getToolUserName()) + ':' + ExasolWizardPageSettings.this.wizard.getToolUserPassword()));
                            }
                            catch (EncryptionException encryptionException) {}
                        }
                    }
                }
            });
            Button resetButton = new Button((Composite)securityGroup, 8);
            resetButton.setText("Reset to default");
            resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    connectionInfo.getProperties().remove(authProperty);
                    ExasolWizardPageSettings.this.wizard.setToolUserName(connectionInfo.getUserName());
                    ExasolWizardPageSettings.this.wizard.setToolUserPassword(connectionInfo.getUserPassword());
                }
            });
        }
        catch (EncryptionException encryptionException) {}
    }

    public void createControl(Composite arg0) {
    }
}

