/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableBase;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableForeignKey;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableUniqueKey;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;

public class ExasolTable
extends ExasolTableBase
implements DBPRefreshableObject,
DBPNamedObject2,
DBPScriptObject {
    private Boolean hasDistKey;
    private Timestamp lastCommit;
    private long sizeRaw;
    private long sizeCompressed;
    private float deletePercentage;
    private Timestamp createTime;
    private Boolean hasRead = false;
    private static String readAdditionalInfo = "select * from (select\ttable_schema,\ttable_name,\ttable_owner,\ttable_has_distribution_key,\ttable_comment,\tdelete_percentage,\to.created,\to.last_commit,\ts.raw_object_size,\ts.mem_object_size,   s.object_type from\t\tEXA_ALL_OBJECTS o\tinner join\t\tEXA_ALL_TABLES T\ton\t\to.root_name = t.table_schema and\t\tt.table_name = o.object_name and\t\to.object_type = 'TABLE'\tinner join \t\tEXA_ALL_OBJECT_SIZES s\ton\t\to.root_name = s.root_name and\t\to.object_name = s.object_name and\t\to.object_type = s.object_type   where o.root_name = '%s' and o.object_name = '%s' and t.table_schema = '%s' and t.table_name = '%s' union all  select schema_name as table_schema, object_name as table_name, 'SYS' as table_owner, false as table_has_distribution_key, object_comment as table_comment, 0 as delete_percentage, cast( null as timestamp) as created, cast( null as timestamp) as last_commit, 0 as raw_object_size, 0 as mem_object_size, object_type from SYS.EXA_SYSCAT WHERE object_type = 'TABLE' and schema_name = '%s' and object_name = '%s') as o\torder by table_schema,o.table_name";

    public ExasolTable(DBRProgressMonitor monitor, ExasolSchema schema, ResultSet dbResult) {
        super(monitor, schema, dbResult);
    }

    public ExasolTable(ExasolSchema schema, String name) {
        super(schema, name, false);
    }

    private void read(DBRProgressMonitor monitor) throws DBCException {
        JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.getDataSource(), (String)"Read Table Details");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCStatement stmt = session.createStatement();){
                String sql = String.format(readAdditionalInfo, ExasolUtils.quoteString(this.getSchema().getName()), ExasolUtils.quoteString(this.getName()), ExasolUtils.quoteString(this.getSchema().getName()), ExasolUtils.quoteString(this.getName()), ExasolUtils.quoteString(this.getSchema().getName()), ExasolUtils.quoteString(this.getName()));
                Throwable throwable2 = null;
                Object var8_12 = null;
                try (JDBCResultSet dbResult = stmt.executeQuery(sql);){
                    dbResult.next();
                    this.hasDistKey = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"TABLE_HAS_DISTRIBUTION_KEY");
                    this.lastCommit = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_COMMIT");
                    this.sizeRaw = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"RAW_OBJECT_SIZE");
                    this.sizeCompressed = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MEM_OBJECT_SIZE");
                    this.deletePercentage = JDBCUtils.safeGetFloat((ResultSet)dbResult, (String)"DELETE_PERCENTAGE");
                    this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATED");
                    this.hasRead = true;
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, this.getDataSource());
        }
    }

    @Override
    public void refreshObjectState(DBRProgressMonitor monitor) throws DBCException {
        this.read(monitor);
        super.refreshObjectState(monitor);
    }

    @Property(viewable=false, expensive=true, editable=false, order=90, category="Base Object")
    public Boolean getHasDistKey(DBRProgressMonitor monitor) throws DBCException {
        if (!this.hasRead.booleanValue()) {
            this.read(monitor);
        }
        return this.hasDistKey;
    }

    @Property(viewable=false, expensive=true, editable=false, order=100, category="Base Object")
    public Timestamp getLastCommit(DBRProgressMonitor monitor) throws DBCException {
        if (!this.hasRead.booleanValue()) {
            this.read(monitor);
        }
        return this.lastCommit;
    }

    @Property(viewable=false, expensive=true, editable=false, order=100, category="Date & Time")
    public Timestamp getCreateTime(DBRProgressMonitor monitor) throws DBCException {
        if (!this.hasRead.booleanValue()) {
            this.read(monitor);
        }
        return this.createTime;
    }

    @Property(viewable=false, expensive=true, editable=false, order=150, category="Statistics")
    public String getRawsize(DBRProgressMonitor monitor) throws DBCException {
        if (!this.hasRead.booleanValue()) {
            this.read(monitor);
        }
        return ExasolUtils.humanReadableByteCount(this.sizeRaw, true);
    }

    @Property(viewable=false, expensive=true, editable=false, order=200, category="Statistics")
    public String getCompressedsize(DBRProgressMonitor monitor) throws DBCException {
        if (!this.hasRead.booleanValue()) {
            this.read(monitor);
        }
        return ExasolUtils.humanReadableByteCount(this.sizeCompressed, true);
    }

    @Property(viewable=false, expensive=true, editable=false, order=250, category="Statistics")
    public float getDeletePercentage(DBRProgressMonitor monitor) throws DBCException {
        if (!this.hasRead.booleanValue()) {
            this.read(monitor);
        }
        return this.deletePercentage;
    }

    @Override
    @Nullable
    @Association
    public Collection<ExasolTableUniqueKey> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((ExasolSchema)this.getContainer()).getConstraintCache().getObjects(monitor, (ExasolSchema)this.getContainer(), this);
    }

    public ExasolTableUniqueKey getConstraint(DBRProgressMonitor monitor, String ukName) throws DBException {
        return (ExasolTableUniqueKey)((ExasolSchema)this.getContainer()).getConstraintCache().getObject(monitor, (ExasolSchema)this.getContainer(), this, ukName);
    }

    @Override
    @Association
    public Collection<ExasolTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((ExasolSchema)this.getContainer()).getAssociationCache().getObjects(monitor, (ExasolSchema)this.getContainer(), this);
    }

    public DBSTableForeignKey getAssociation(DBRProgressMonitor monitor, String ukName) throws DBException {
        return (DBSTableForeignKey)((ExasolSchema)this.getContainer()).getAssociationCache().getObject(monitor, (ExasolSchema)this.getContainer(), this, ukName);
    }

    @Override
    public boolean isView() {
        return false;
    }

    public JDBCStructCache<ExasolSchema, ExasolTable, ExasolTableColumn> getCache() {
        return ((ExasolSchema)this.getContainer()).getTableCache();
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        ((ExasolSchema)this.getContainer()).getTableCache().clearChildrenCache(this);
        ((ExasolSchema)this.getContainer()).getConstraintCache().clearObjectCache(this);
        ((ExasolSchema)this.getContainer()).getAssociationCache().clearObjectCache(this);
        return this;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return ExasolUtils.generateDDLforTable(monitor, (ExasolDataSource)this.getDataSource(), this);
    }

    public DBSObjectState getObjectState() {
        return DBSObjectState.NORMAL;
    }
}

