/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.ext.exasol.manager.security.ExasolRole;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.ui.ExasolRoleDialog;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.utils.CommonUtils;

public class ExasolRoleManager
extends SQLObjectEditor<ExasolRole, ExasolDataSource>
implements DBEObjectRenamer<ExasolRole> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    public DBSObjectCache<ExasolDataSource, ExasolRole> getObjectsCache(ExasolRole object) {
        ExasolDataSource ds = (ExasolDataSource)object.getDataSource();
        return ds.getRoleCache();
    }

    protected ExasolRole createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final ExasolDataSource parent, Object copyFrom) throws DBException {
        return (ExasolRole)new UITask<ExasolRole>(){

            protected ExasolRole runTask() {
                ExasolRoleDialog dialog = new ExasolRoleDialog(DBeaverUI.getActiveWorkbenchShell());
                if (dialog.open() != 0) {
                    return null;
                }
                return new ExasolRole(parent, dialog.getName(), dialog.getDescription());
            }
        }.execute();
    }

    protected void addObjectCreateActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        ExasolRole obj = (ExasolRole)command.getObject();
        String script = "CREATE ROLE " + DBUtils.getQuotedIdentifier((DBSObject)obj);
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create Role", script));
        if (!CommonUtils.isEmpty((String)obj.getDescription())) {
            actions.add((DBEPersistAction)this.Comment(obj));
        }
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        ExasolRole obj = (ExasolRole)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop Role", "DROP ROLE " + DBUtils.getQuotedIdentifier((DBSObject)obj)));
    }

    public void renameObject(DBECommandContext commandContext, ExasolRole object, String newName) throws DBException {
        this.processObjectRename(commandContext, object, newName);
    }

    protected void processObjectRename(DBECommandContext commandContext, ExasolRole object, String newName) throws DBException {
        SQLObjectEditor.ObjectRenameCommand command = new SQLObjectEditor.ObjectRenameCommand((SQLObjectEditor)this, (DBSObject)object, ModelMessages.model_jdbc_rename_object, newName);
        commandContext.addCommand((DBECommand)command, (DBECommandReflector)new SQLObjectEditor.RenameObjectReflector((SQLObjectEditor)this), true);
    }

    protected void addObjectRenameActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        ExasolRole obj = (ExasolRole)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename ROLE", "RENAME ROLE " + DBUtils.getQuotedIdentifier((DBPDataSource)obj.getDataSource(), (String)command.getOldName()) + " to " + DBUtils.getQuotedIdentifier((DBPDataSource)obj.getDataSource(), (String)command.getNewName())));
    }

    private SQLDatabasePersistAction Comment(ExasolRole obj) {
        return new SQLDatabasePersistAction("Comment on Role", "COMMENT ON ROLE " + DBUtils.getQuotedIdentifier((DBSObject)obj) + " IS '" + obj.getDescription() + "'");
    }

    protected void addObjectModifyActions(List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        ExasolRole obj = (ExasolRole)command.getObject();
        if (command.getProperties().containsKey("description")) {
            actionList.add((DBEPersistAction)this.Comment(obj));
        }
    }
}

