/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tools;

import java.io.File;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.mysql.MySQLMessages;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLExportWizard;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLWizardPageSettings;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

class MySQLExportWizardPageSettings
extends MySQLWizardPageSettings<MySQLExportWizard> {
    private Text outputFolderText;
    private Text outputFileText;
    private Combo methodCombo;
    private Button noCreateStatementsCheck;
    private Button addDropStatementsCheck;
    private Button disableKeysCheck;
    private Button extendedInsertsCheck;
    private Button dumpEventsCheck;
    private Button commentsCheck;
    private Button removeDefiner;
    private Button binaryInHex;
    private Button noData;

    MySQLExportWizardPageSettings(MySQLExportWizard wizard) {
        super(wizard, MySQLMessages.tools_db_export_wizard_page_settings_page_name);
        this.setTitle(MySQLMessages.tools_db_export_wizard_page_settings_page_name);
        this.setDescription(MySQLMessages.tools_db_export_wizard_page_settings_page_description);
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && ((MySQLExportWizard)this.wizard).getOutputFolder() != null;
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        SelectionAdapter changeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MySQLExportWizardPageSettings.this.updateState();
            }
        };
        Group methodGroup = UIUtils.createControlGroup((Composite)composite, (String)MySQLMessages.tools_db_export_wizard_page_settings_group_exe_method, (int)1, (int)768, (int)0);
        this.methodCombo = new Combo((Composite)methodGroup, 12);
        this.methodCombo.setLayoutData((Object)new GridData(768));
        this.methodCombo.add(MySQLMessages.tools_db_export_wizard_page_settings_combo_item_online_backup);
        this.methodCombo.add(MySQLMessages.tools_db_export_wizard_page_settings_combo_item_lock_tables);
        this.methodCombo.add(MySQLMessages.tools_db_export_wizard_page_settings_combo_item_normal);
        this.methodCombo.select(((MySQLExportWizard)this.wizard).method.ordinal());
        this.methodCombo.addSelectionListener((SelectionListener)changeListener);
        Group settingsGroup = UIUtils.createControlGroup((Composite)composite, (String)MySQLMessages.tools_db_export_wizard_page_settings_group_settings, (int)3, (int)768, (int)0);
        this.noCreateStatementsCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)MySQLMessages.tools_db_export_wizard_page_settings_checkbox_no_create, (boolean)((MySQLExportWizard)this.wizard).noCreateStatements);
        this.noCreateStatementsCheck.addSelectionListener((SelectionListener)changeListener);
        this.addDropStatementsCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)MySQLMessages.tools_db_export_wizard_page_settings_checkbox_add_drop, (boolean)((MySQLExportWizard)this.wizard).addDropStatements);
        this.addDropStatementsCheck.addSelectionListener((SelectionListener)changeListener);
        this.disableKeysCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)MySQLMessages.tools_db_export_wizard_page_settings_checkbox_disable_keys, (boolean)((MySQLExportWizard)this.wizard).disableKeys);
        this.disableKeysCheck.addSelectionListener((SelectionListener)changeListener);
        this.extendedInsertsCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)MySQLMessages.tools_db_export_wizard_page_settings_checkbox_ext_inserts, (boolean)((MySQLExportWizard)this.wizard).extendedInserts);
        this.extendedInsertsCheck.addSelectionListener((SelectionListener)changeListener);
        this.dumpEventsCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)MySQLMessages.tools_db_export_wizard_page_settings_checkbox_dump_events, (boolean)((MySQLExportWizard)this.wizard).dumpEvents);
        this.dumpEventsCheck.addSelectionListener((SelectionListener)changeListener);
        this.commentsCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)MySQLMessages.tools_db_export_wizard_page_settings_checkbox_addnl_comments, (boolean)((MySQLExportWizard)this.wizard).comments);
        this.commentsCheck.addSelectionListener((SelectionListener)changeListener);
        this.removeDefiner = UIUtils.createCheckbox((Composite)settingsGroup, (String)MySQLMessages.tools_db_export_wizard_page_settings_checkbox_remove_definer, (boolean)((MySQLExportWizard)this.wizard).removeDefiner);
        this.removeDefiner.addSelectionListener((SelectionListener)changeListener);
        this.binaryInHex = UIUtils.createCheckbox((Composite)settingsGroup, (String)MySQLMessages.tools_db_export_wizard_page_settings_checkbox_binary_hex, (boolean)((MySQLExportWizard)this.wizard).binariesInHex);
        this.binaryInHex.addSelectionListener((SelectionListener)changeListener);
        this.noData = UIUtils.createCheckbox((Composite)settingsGroup, (String)MySQLMessages.tools_db_export_wizard_page_settings_checkbox_no_data, (boolean)((MySQLExportWizard)this.wizard).noData);
        this.noData.addSelectionListener((SelectionListener)changeListener);
        Group outputGroup = UIUtils.createControlGroup((Composite)composite, (String)MySQLMessages.tools_db_export_wizard_page_settings_group_output, (int)2, (int)768, (int)0);
        this.outputFolderText = DialogUtils.createOutputFolderChooser((Composite)outputGroup, (String)MySQLMessages.tools_db_export_wizard_page_settings_label_out_text, e -> this.updateState());
        this.outputFileText = UIUtils.createLabelText((Composite)outputGroup, (String)"File name pattern", (String)((MySQLExportWizard)this.wizard).getOutputFilePattern());
        UIUtils.setContentProposalToolTip((Control)this.outputFileText, (String)"Output file name pattern", (String[])new String[]{"host", "database", "table", "date", "timestamp"});
        UIUtils.installContentProposal((Control)this.outputFileText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new SimpleContentProposalProvider(new String[]{GeneralUtils.variablePattern((String)"host"), GeneralUtils.variablePattern((String)"database"), GeneralUtils.variablePattern((String)"table"), GeneralUtils.variablePattern((String)"date"), GeneralUtils.variablePattern((String)"timestamp")}));
        this.outputFileText.addModifyListener(e -> ((MySQLExportWizard)this.wizard).setOutputFilePattern(this.outputFileText.getText()));
        this.createExtraArgsInput((Composite)outputGroup);
        if (((MySQLExportWizard)this.wizard).getOutputFolder() != null) {
            this.outputFolderText.setText(((MySQLExportWizard)this.wizard).getOutputFolder().getAbsolutePath());
        }
        this.createSecurityGroup(composite);
        this.setControl((Control)composite);
    }

    private void updateState() {
        String fileName = this.outputFolderText.getText();
        ((MySQLExportWizard)this.wizard).setOutputFolder(CommonUtils.isEmpty((String)fileName) ? null : new File(fileName));
        ((MySQLExportWizard)this.wizard).setOutputFilePattern(this.outputFileText.getText());
        ((MySQLExportWizard)this.wizard).setExtraCommandArgs(this.extraCommandArgsText.getText());
        switch (this.methodCombo.getSelectionIndex()) {
            case 0: {
                ((MySQLExportWizard)this.wizard).method = MySQLExportWizard.DumpMethod.ONLINE;
                break;
            }
            case 1: {
                ((MySQLExportWizard)this.wizard).method = MySQLExportWizard.DumpMethod.LOCK_ALL_TABLES;
                break;
            }
            default: {
                ((MySQLExportWizard)this.wizard).method = MySQLExportWizard.DumpMethod.NORMAL;
            }
        }
        ((MySQLExportWizard)this.wizard).noCreateStatements = this.noCreateStatementsCheck.getSelection();
        ((MySQLExportWizard)this.wizard).addDropStatements = this.addDropStatementsCheck.getSelection();
        ((MySQLExportWizard)this.wizard).disableKeys = this.disableKeysCheck.getSelection();
        ((MySQLExportWizard)this.wizard).extendedInserts = this.extendedInsertsCheck.getSelection();
        ((MySQLExportWizard)this.wizard).dumpEvents = this.dumpEventsCheck.getSelection();
        ((MySQLExportWizard)this.wizard).comments = this.commentsCheck.getSelection();
        ((MySQLExportWizard)this.wizard).removeDefiner = this.removeDefiner.getSelection();
        ((MySQLExportWizard)this.wizard).binariesInHex = this.binaryInHex.getSelection();
        ((MySQLExportWizard)this.wizard).noData = this.noData.getSelection();
        this.getContainer().updateButtons();
    }
}

