/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.edit;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEObjectReorderer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.AttributeEditPage;
import org.jkiss.utils.CommonUtils;

public class MySQLTableColumnManager
extends SQLTableColumnManager<MySQLTableColumn, MySQLTableBase>
implements DBEObjectRenamer<MySQLTableColumn>,
DBEObjectReorderer<MySQLTableColumn> {
    protected final SQLTableColumnManager.ColumnModifier<MySQLTableColumn> MySQLDataTypeModifier = new SQLTableColumnManager.ColumnModifier<MySQLTableColumn>(){

        public void appendModifier(MySQLTableColumn column, StringBuilder sql, DBECommandAbstract<MySQLTableColumn> command) {
            sql.append(' ').append(column.getFullTypeName());
        }
    };
    protected final SQLTableColumnManager.ColumnModifier<MySQLTableColumn> CharsetModifier = new SQLTableColumnManager.ColumnModifier<MySQLTableColumn>(){

        public void appendModifier(MySQLTableColumn column, StringBuilder sql, DBECommandAbstract<MySQLTableColumn> command) {
            if (column.getCharset() != null) {
                sql.append(" CHARACTER SET ").append(column.getCharset().getName());
            }
        }
    };
    protected final SQLTableColumnManager.ColumnModifier<MySQLTableColumn> CollationModifier = new SQLTableColumnManager.ColumnModifier<MySQLTableColumn>(){

        public void appendModifier(MySQLTableColumn column, StringBuilder sql, DBECommandAbstract<MySQLTableColumn> command) {
            if (column.getCollation() != null) {
                sql.append(" COLLATE ").append(column.getCollation().getName());
            }
        }
    };

    @Nullable
    public DBSObjectCache<? extends DBSObject, MySQLTableColumn> getObjectsCache(MySQLTableColumn object) {
        return ((MySQLCatalog)((MySQLTableBase)object.getParentObject()).getContainer()).getTableCache().getChildrenCache((MySQLTableBase)object.getParentObject());
    }

    protected SQLTableColumnManager.ColumnModifier[] getSupportedModifiers(MySQLTableColumn column) {
        return new SQLTableColumnManager.ColumnModifier[]{this.MySQLDataTypeModifier, this.CharsetModifier, this.CollationModifier, this.DefaultModifier, this.NullNotNullModifier};
    }

    public StringBuilder getNestedDeclaration(MySQLTableBase owner, DBECommandAbstract<MySQLTableColumn> command, Map<String, Object> options) {
        StringBuilder decl = super.getNestedDeclaration((JDBCTable)owner, command, options);
        MySQLTableColumn column = (MySQLTableColumn)command.getObject();
        if (!CommonUtils.isEmpty((String)column.getExtraInfo())) {
            decl.append(" ").append(column.getExtraInfo());
        }
        if (column.isAutoGenerated() && (CommonUtils.isEmpty((String)column.getExtraInfo()) || !column.getExtraInfo().toLowerCase(Locale.ENGLISH).contains("auto_increment"))) {
            decl.append(" AUTO_INCREMENT");
        }
        if (!CommonUtils.isEmpty((String)column.getComment())) {
            decl.append(" COMMENT ").append(SQLUtils.quoteString((DBSObject)column, (String)column.getComment()));
        }
        return decl;
    }

    protected MySQLTableColumn createDatabaseObject(final DBRProgressMonitor monitor, final DBECommandContext context, final MySQLTableBase parent, Object copyFrom) {
        return (MySQLTableColumn)((Object)new UITask<MySQLTableColumn>(){

            protected MySQLTableColumn runTask() {
                DBSDataType columnType = MySQLTableColumnManager.findBestDataType((DBPDataSource)parent.getDataSource(), (String[])new String[]{"varchar"});
                MySQLTableColumn column = new MySQLTableColumn(parent);
                column.setName(MySQLTableColumnManager.this.getNewColumnName(monitor, context, parent));
                String typeName = columnType == null ? "integer" : columnType.getName().toLowerCase();
                column.setTypeName(typeName);
                column.setMaxLength(columnType != null && columnType.getDataKind() == DBPDataKind.STRING ? 100 : 0);
                column.setValueType(columnType == null ? 4 : columnType.getTypeID());
                column.setOrdinalPosition(parent.getCachedAttributes().size() + 1);
                column.setFullTypeName(DBUtils.getFullTypeName((DBSTypedObject)column));
                AttributeEditPage page = new AttributeEditPage(null, (DBSEntityAttribute)column);
                if (!page.edit()) {
                    return null;
                }
                return column;
            }
        }.execute());
    }

    protected void addObjectModifyActions(List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        MySQLTableColumn column = (MySQLTableColumn)command.getObject();
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Modify column", "ALTER TABLE " + ((MySQLTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " MODIFY COLUMN " + this.getNestedDeclaration((MySQLTableBase)column.getTable(), (DBECommandAbstract<MySQLTableColumn>)command, options)));
    }

    public void renameObject(DBECommandContext commandContext, MySQLTableColumn object, String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, newName);
    }

    protected void addObjectRenameActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        MySQLTableColumn column = (MySQLTableColumn)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename column", "ALTER TABLE " + ((MySQLTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " CHANGE " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getOldName()) + " " + this.getNestedDeclaration((MySQLTableBase)column.getTable(), (DBECommandAbstract<MySQLTableColumn>)command, options)));
    }

    protected void addObjectReorderActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectReorderCommand command, Map<String, Object> options) {
        MySQLTableColumn column = (MySQLTableColumn)command.getObject();
        String order = "FIRST";
        if (column.getOrdinalPosition() > 0) {
            for (MySQLTableColumn col : ((MySQLTableBase)((MySQLTableColumn)command.getObject()).getTable()).getCachedAttributes()) {
                if (col.getOrdinalPosition() != column.getOrdinalPosition() - 1) continue;
                order = "AFTER " + DBUtils.getQuotedIdentifier((DBSObject)col);
                break;
            }
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Reorder column", "ALTER TABLE " + ((MySQLTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " CHANGE " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject())) + " " + this.getNestedDeclaration((MySQLTableBase)column.getTable(), (DBECommandAbstract<MySQLTableColumn>)command, options) + " " + order));
    }

    public int getMinimumOrdinalPosition(MySQLTableColumn object) {
        return 1;
    }

    public int getMaximumOrdinalPosition(MySQLTableColumn object) {
        return ((MySQLTableBase)object.getTable()).getCachedAttributes().size();
    }

    public void setObjectOrdinalPosition(DBECommandContext commandContext, MySQLTableColumn object, List<MySQLTableColumn> siblingObjects, int newPosition) throws DBException {
        this.processObjectReorder(commandContext, (DBSObject)object, siblingObjects, newPosition);
    }
}

