/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.format.tokenized;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.format.SQLFormatter;
import org.jkiss.dbeaver.model.sql.format.SQLFormatterConfiguration;
import org.jkiss.dbeaver.model.sql.format.tokenized.FormatterToken;
import org.jkiss.dbeaver.model.sql.format.tokenized.SQLTokensParser;
import org.jkiss.dbeaver.model.sql.format.tokenized.TokenType;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class SQLFormatterTokenized
implements SQLFormatter {
    public static final String FORMATTER_ID = "DEFAULT";
    private static final String[] JOIN_BEGIN = new String[]{"LEFT", "RIGHT", "INNER", "OUTER", "JOIN"};
    private SQLFormatterConfiguration formatterCfg;
    private List<Boolean> functionBracket = new ArrayList<Boolean>();
    private List<String> statementDelimiters = new ArrayList<String>(2);
    private String delimiterRedefiner;
    private boolean isCompact;

    @Override
    public String format(String argSql, SQLFormatterConfiguration configuration) {
        this.formatterCfg = configuration;
        String[] stringArray = this.formatterCfg.getSyntaxManager().getStatementDelimiters();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String delim = stringArray[n2];
            this.statementDelimiters.add(delim.toUpperCase(Locale.ENGLISH));
            ++n2;
        }
        this.delimiterRedefiner = this.formatterCfg.getSyntaxManager().getDialect().getScriptDelimiterRedefiner();
        if (this.delimiterRedefiner != null) {
            this.delimiterRedefiner = this.delimiterRedefiner.toUpperCase(Locale.ENGLISH);
        }
        SQLTokensParser fParser = new SQLTokensParser(this.formatterCfg);
        this.functionBracket.clear();
        boolean isSqlEndsWithNewLine = false;
        if (argSql.endsWith("\n")) {
            isSqlEndsWithNewLine = true;
        }
        List<FormatterToken> list = fParser.parse(argSql);
        list = this.format(list);
        StringBuilder after = new StringBuilder(argSql.length() + 20);
        for (FormatterToken token : list) {
            after.append(token.getString());
        }
        if (isSqlEndsWithNewLine) {
            after.append(GeneralUtils.getDefaultLineSeparator());
        }
        return after.toString();
    }

    public boolean isCompact() {
        return this.isCompact;
    }

    public void setCompact(boolean compact) {
        this.isCompact = compact;
    }

    private List<FormatterToken> format(List<FormatterToken> argList) {
        if (argList.isEmpty()) {
            return argList;
        }
        FormatterToken token = argList.get(0);
        if (token.getType() == TokenType.SPACE) {
            argList.remove(0);
            if (argList.isEmpty()) {
                return argList;
            }
        }
        if ((token = argList.get(argList.size() - 1)).getType() == TokenType.SPACE) {
            argList.remove(argList.size() - 1);
            if (argList.isEmpty()) {
                return argList;
            }
        }
        DBPIdentifierCase keywordCase = this.formatterCfg.getKeywordCase();
        int index = 0;
        while (index < argList.size()) {
            token = argList.get(index);
            if (token.getType() == TokenType.KEYWORD) {
                token.setString(keywordCase.transform(token.getString()));
            }
            ++index;
        }
        index = argList.size() - 1;
        while (index >= 1) {
            token = argList.get(index);
            FormatterToken prevToken = argList.get(index - 1);
            if (token.getType() == TokenType.SPACE && (prevToken.getType() == TokenType.SYMBOL || prevToken.getType() == TokenType.COMMENT)) {
                argList.remove(index);
            } else if ((token.getType() == TokenType.SYMBOL || token.getType() == TokenType.COMMENT) && prevToken.getType() == TokenType.SPACE) {
                argList.remove(index - 1);
            } else if (token.getType() == TokenType.SPACE) {
                token.setString(" ");
            }
            --index;
        }
        index = 0;
        while (index < argList.size() - 2) {
            FormatterToken t0 = argList.get(index);
            FormatterToken t1 = argList.get(index + 1);
            FormatterToken t2 = argList.get(index + 2);
            String tokenString = t0.getString().toUpperCase(Locale.ENGLISH);
            String token2String = t2.getString().toUpperCase(Locale.ENGLISH);
            if (t0.getType() == TokenType.KEYWORD && t1.getType() == TokenType.SPACE && t2.getType() == TokenType.KEYWORD && ((tokenString.equals("ORDER") || tokenString.equals("GROUP") || tokenString.equals("CONNECT")) && token2String.equals("BY") || tokenString.equals("START") && token2String.equals("WITH"))) {
                t0.setString(String.valueOf(t0.getString()) + " " + t2.getString());
                argList.remove(index + 1);
                argList.remove(index + 1);
            }
            if (tokenString.equals("(") && t1.getString().equals("+") && token2String.equals(")")) {
                t0.setString("(+)");
                argList.remove(index + 1);
                argList.remove(index + 1);
            }
            ++index;
        }
        int indent = 0;
        ArrayList<Integer> bracketIndent = new ArrayList<Integer>();
        FormatterToken prev = new FormatterToken(TokenType.SPACE, " ");
        boolean encounterBetween = false;
        int index2 = 0;
        while (index2 < argList.size()) {
            block137: {
                String tokenString;
                block138: {
                    block136: {
                        token = argList.get(index2);
                        tokenString = token.getString().toUpperCase(Locale.ENGLISH);
                        if (token.getType() != TokenType.SYMBOL) break block136;
                        if (tokenString.equals("(")) {
                            this.functionBracket.add(this.formatterCfg.isFunction(prev.getString()) ? Boolean.TRUE : Boolean.FALSE);
                            bracketIndent.add(indent);
                            if (!this.isCompact) {
                                index2 += this.insertReturnAndIndent(argList, index2 + 1, ++indent);
                            }
                        } else if (tokenString.equals(")") && !bracketIndent.isEmpty() && !this.functionBracket.isEmpty()) {
                            indent = (Integer)bracketIndent.remove(bracketIndent.size() - 1);
                            if (!this.isCompact) {
                                index2 += this.insertReturnAndIndent(argList, index2, indent);
                            }
                            this.functionBracket.remove(this.functionBracket.size() - 1);
                        } else if (tokenString.equals(",")) {
                            if (!this.isCompact) {
                                index2 += this.insertReturnAndIndent(argList, index2 + 1, indent);
                            }
                        } else if (this.statementDelimiters.contains(tokenString)) {
                            indent = 0;
                            index2 += this.insertReturnAndIndent(argList, index2, indent);
                        }
                        break block137;
                    }
                    if (token.getType() != TokenType.KEYWORD) break block138;
                    switch (tokenString) {
                        case "INSERT": 
                        case "SELECT": 
                        case "UPDATE": 
                        case "TRUNCATE": 
                        case "CASE": 
                        case "DROP": 
                        case "INTO": 
                        case "TABLE": 
                        case "CREATE": 
                        case "DELETE": {
                            if (!this.isCompact) {
                                index2 += this.insertReturnAndIndent(argList, index2 + 1, ++indent);
                                break;
                            }
                            break block137;
                        }
                        case "START WITH": 
                        case "CONNECT BY": 
                        case "SET": 
                        case "FROM": 
                        case "WHERE": 
                        case "GROUP BY": 
                        case "ORDER BY": 
                        case "HAVING": {
                            index2 += this.insertReturnAndIndent(argList, index2, indent - 1);
                            if (!this.isCompact) {
                                index2 += this.insertReturnAndIndent(argList, index2 + 1, indent);
                                break;
                            }
                            break block137;
                        }
                        case "JOIN": 
                        case "LEFT": 
                        case "INNER": 
                        case "OUTER": 
                        case "RIGHT": {
                            if (this.isJoinStart(argList, index2)) {
                                index2 += this.insertReturnAndIndent(argList, index2, indent - 1);
                            }
                            tokenString.equals("JOIN");
                            break;
                        }
                        case "VALUES": {
                            index2 += this.insertReturnAndIndent(argList, index2, --indent);
                            break;
                        }
                        case "END": {
                            index2 += this.insertReturnAndIndent(argList, index2, --indent);
                            break;
                        }
                        case "OR": 
                        case "ELSE": 
                        case "WHEN": {
                            index2 += this.insertReturnAndIndent(argList, index2, indent);
                            break;
                        }
                        case "ON": {
                            index2 += this.insertReturnAndIndent(argList, index2 + 1, indent);
                            break;
                        }
                        case "USING": {
                            index2 += this.insertReturnAndIndent(argList, index2, indent + 1);
                            break;
                        }
                        case "TOP": {
                            index2 += this.insertReturnAndIndent(argList, index2, indent);
                            if (argList.size() < index2 + 3) {
                                index2 += this.insertReturnAndIndent(argList, index2 + 3, indent);
                                break;
                            }
                            break block137;
                        }
                        case "INTERSECT": 
                        case "UNION": 
                        case "EXCEPT": {
                            index2 += this.insertReturnAndIndent(argList, index2, indent -= 2);
                            ++indent;
                            break;
                        }
                        case "BETWEEN": {
                            encounterBetween = true;
                            break;
                        }
                        case "AND": {
                            if (!encounterBetween) {
                                index2 += this.insertReturnAndIndent(argList, index2, indent);
                            }
                            encounterBetween = false;
                        }
                    }
                    break block137;
                }
                if (token.getType() == TokenType.COMMENT) {
                    Pair<String, String> mlComments;
                    boolean isComment = false;
                    String[] slComments = this.formatterCfg.getSyntaxManager().getDialect().getSingleLineComments();
                    if (slComments != null) {
                        String[] stringArray = slComments;
                        int n = slComments.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String slc = stringArray[n2];
                            if (token.getString().startsWith(slc)) {
                                isComment = true;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (!isComment && (mlComments = this.formatterCfg.getSyntaxManager().getDialect().getMultiLineComments()) != null && token.getString().startsWith((String)mlComments.getFirst())) {
                        index2 += this.insertReturnAndIndent(argList, index2 + 1, indent);
                    }
                } else if (token.getType() == TokenType.COMMAND) {
                    String delimiter;
                    String command;
                    int divPos;
                    indent = 0;
                    if (index2 > 0) {
                        index2 += this.insertReturnAndIndent(argList, index2, 0);
                    }
                    index2 += this.insertReturnAndIndent(argList, index2 + 1, 0);
                    if (!CommonUtils.isEmpty((String)this.delimiterRedefiner) && token.getString().startsWith(this.delimiterRedefiner) && (divPos = (command = token.getString().trim().toUpperCase(Locale.ENGLISH)).lastIndexOf(32)) > 0 && !CommonUtils.isEmpty((String)(delimiter = command.substring(divPos).trim()))) {
                        this.statementDelimiters.clear();
                        this.statementDelimiters.add(delimiter);
                    }
                } else if (this.statementDelimiters.contains(tokenString)) {
                    indent = 0;
                    index2 += this.insertReturnAndIndent(argList, index2 + 1, indent);
                }
            }
            prev = token;
            ++index2;
        }
        index2 = argList.size() - 1;
        while (index2 >= 4) {
            if (index2 < argList.size()) {
                FormatterToken t0 = argList.get(index2);
                FormatterToken t1 = argList.get(index2 - 1);
                FormatterToken t2 = argList.get(index2 - 2);
                FormatterToken t3 = argList.get(index2 - 3);
                FormatterToken t4 = argList.get(index2 - 4);
                if (t4.getString().equals("(") && t3.getString().trim().isEmpty() && t1.getString().trim().isEmpty() && t0.getString().equalsIgnoreCase(")")) {
                    t4.setString(String.valueOf(t4.getString()) + t2.getString() + t0.getString());
                    argList.remove(index2);
                    argList.remove(index2 - 1);
                    argList.remove(index2 - 2);
                    argList.remove(index2 - 3);
                }
            }
            --index2;
        }
        index2 = 1;
        while (index2 < argList.size()) {
            prev = argList.get(index2 - 1);
            token = argList.get(index2);
            if (!(prev.getType() == TokenType.SPACE || token.getType() == TokenType.SPACE || token.getString().startsWith("(") || token.getString().equals(",") || this.statementDelimiters.contains(token.getString()) || this.formatterCfg.isFunction(prev.getString()) && token.getString().equals("(") || token.getType() == TokenType.VALUE && prev.getType() == TokenType.NAME || token.getType() == TokenType.SYMBOL && SQLFormatterTokenized.isEmbeddedToken(token) || prev.getType() == TokenType.SYMBOL && SQLFormatterTokenized.isEmbeddedToken(prev) || token.getType() == TokenType.SYMBOL && prev.getType() == TokenType.SYMBOL)) {
                argList.add(index2, new FormatterToken(TokenType.SPACE, " "));
            }
            ++index2;
        }
        return argList;
    }

    private static boolean isEmbeddedToken(FormatterToken token) {
        switch (token.getString()) {
            case ".": 
            case ":": {
                return true;
            }
        }
        return false;
    }

    private boolean isJoinStart(List<FormatterToken> argList, int index) {
        FormatterToken token;
        if (!ArrayUtils.contains((Object[])JOIN_BEGIN, (Object)argList.get(index).getString().toUpperCase(Locale.ENGLISH))) {
            return false;
        }
        int i = index - 1;
        while (i >= 0) {
            token = argList.get(i);
            if (token.getType() != TokenType.SPACE && token.getType() != TokenType.SYMBOL) {
                if (!ArrayUtils.contains((Object[])JOIN_BEGIN, (Object)token.getString().toUpperCase(Locale.ENGLISH))) break;
                return false;
            }
            --i;
        }
        i = index;
        while (i < argList.size()) {
            token = argList.get(i);
            if (token.getType() != TokenType.SPACE && token.getType() != TokenType.SYMBOL) {
                if (token.getString().toUpperCase(Locale.ENGLISH).equals("JOIN")) {
                    return true;
                }
                if (!ArrayUtils.contains((Object[])JOIN_BEGIN, (Object)token.getString().toUpperCase(Locale.ENGLISH))) {
                    return false;
                }
            }
            ++i;
        }
        return false;
    }

    private int insertReturnAndIndent(List<FormatterToken> argList, int argIndex, int argIndent) {
        boolean isDelimiter;
        String s;
        block11: {
            FormatterToken token;
            block10: {
                if (this.functionBracket.contains(Boolean.TRUE)) {
                    return 0;
                }
                try {
                    FormatterToken prevToken;
                    s = GeneralUtils.getDefaultLineSeparator();
                    if (argIndex > 0 && (prevToken = argList.get(argIndex - 1)).getType() == TokenType.COMMENT && SQLUtils.isCommentLine(this.formatterCfg.getSyntaxManager().getDialect(), prevToken.getString())) {
                        s = "";
                    }
                    int index = 0;
                    while (index < argIndent) {
                        s = String.valueOf(s) + this.formatterCfg.getIndentString();
                        ++index;
                    }
                    token = argList.get(argIndex);
                    if (token.getType() != TokenType.SPACE) break block10;
                    token.setString(s);
                    return 0;
                }
                catch (IndexOutOfBoundsException e) {
                    e.printStackTrace();
                    return 0;
                }
            }
            isDelimiter = this.statementDelimiters.contains(token.getString().toUpperCase());
            if (isDelimiter || (token = argList.get(argIndex - 1)).getType() != TokenType.SPACE) break block11;
            token.setString(s);
            return 0;
        }
        if (isDelimiter) {
            if (argList.size() > argIndex + 1) {
                argList.add(argIndex + 1, new FormatterToken(TokenType.SPACE, String.valueOf(s) + s));
            }
        } else {
            argList.add(argIndex, new FormatterToken(TokenType.SPACE, s));
        }
        return 1;
    }
}

