/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.net;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Vector;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.net.SSHConstants;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWTunnel;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class SSHTunnelImpl
implements DBWTunnel {
    private static final Log log = Log.getLog(SSHTunnelImpl.class);
    public static final String LOCALHOST_NAME = "127.0.0.1";
    private static transient JSch jsch;
    private transient Session session;
    private transient int savedLocalPort;
    private transient DBWHandlerConfiguration savedConfiguration;
    private transient DBPConnectionConfiguration savedConnectionInfo;

    @Override
    public DBPConnectionConfiguration initializeTunnel(DBRProgressMonitor monitor, DBPPlatform platform, DBWHandlerConfiguration configuration, DBPConnectionConfiguration connectionInfo) throws DBException, IOException {
        int dbPort;
        int connectTimeout;
        int sshPortNum;
        String dbPortString = connectionInfo.getHostPort();
        if (CommonUtils.isEmpty((String)dbPortString) && CommonUtils.isEmpty((String)(dbPortString = configuration.getDriver().getDefaultPort()))) {
            throw new DBException("Database port not specified and no default port number for driver '" + configuration.getDriver().getName() + "'");
        }
        String dbHost = connectionInfo.getHostName();
        Map<String, String> properties = configuration.getProperties();
        String sshAuthType = properties.get("authType");
        String sshHost = properties.get("host");
        String sshPort = properties.get("port");
        String sshLocalPort = properties.get("localPort");
        String sshUser = configuration.getUserName();
        String aliveInterval = properties.get("aliveInterval");
        String connectTimeoutString = properties.get("sshConnectTimeout");
        if (CommonUtils.isEmpty((String)sshHost)) {
            throw new DBException("SSH host not specified");
        }
        if (CommonUtils.isEmpty((String)sshPort)) {
            throw new DBException("SSH port not specified");
        }
        if (CommonUtils.isEmpty((String)sshUser)) {
            throw new DBException("SSH user not specified");
        }
        try {
            sshPortNum = Integer.parseInt(sshPort);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DBException("Invalid SSH port: " + sshPort);
        }
        SSHConstants.AuthType authType = SSHConstants.AuthType.PASSWORD;
        if (sshAuthType != null) {
            authType = SSHConstants.AuthType.valueOf(sshAuthType);
        }
        File privKeyFile = null;
        String privKeyPath = properties.get("keyPath");
        if (authType == SSHConstants.AuthType.PUBLIC_KEY) {
            if (CommonUtils.isEmpty((String)privKeyPath)) {
                throw new DBException("Private key path is empty");
            }
            privKeyFile = new File(privKeyPath);
            if (!privKeyFile.exists()) {
                throw new DBException("Private key file '" + privKeyFile.getAbsolutePath() + "' doesn't exist");
            }
        }
        try {
            connectTimeout = Integer.parseInt(connectTimeoutString);
        }
        catch (NumberFormatException numberFormatException) {
            connectTimeout = 10000;
        }
        monitor.subTask("Initiating tunnel at '" + sshHost + "'");
        UIUserInfo ui = new UIUserInfo(configuration);
        try {
            dbPort = Integer.parseInt(dbPortString);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DBException("Bad database port number: " + dbPortString);
        }
        int localPort = this.savedLocalPort;
        if (platform != null) {
            localPort = this.findFreePort(platform);
        }
        if (!CommonUtils.isEmpty((String)sshLocalPort)) {
            try {
                int forceLocalPort = Integer.parseInt(sshLocalPort);
                if (forceLocalPort > 0) {
                    localPort = forceLocalPort;
                }
            }
            catch (NumberFormatException e) {
                log.warn("Bad local port specified", e);
            }
        }
        try {
            if (jsch == null) {
                jsch = new JSch();
                JSch.setLogger((Logger)new LoggerProxy());
            }
            if (privKeyFile != null) {
                if (!CommonUtils.isEmpty((String)ui.getPassphrase())) {
                    jsch.addIdentity(privKeyFile.getAbsolutePath(), ui.getPassphrase());
                } else {
                    jsch.addIdentity(privKeyFile.getAbsolutePath());
                }
            }
            log.debug("Instantiate SSH tunnel");
            this.session = jsch.getSession(sshUser, sshHost, sshPortNum);
            this.session.setConfig("StrictHostKeyChecking", "no");
            this.session.setConfig("PreferredAuthentications", privKeyFile != null ? "publickey" : "password");
            this.session.setConfig("ConnectTimeout", String.valueOf(connectTimeout));
            this.session.setUserInfo((UserInfo)ui);
            if (!CommonUtils.isEmpty((String)aliveInterval)) {
                this.session.setServerAliveInterval(Integer.parseInt(aliveInterval));
            }
            log.debug("Connect to tunnel host");
            this.session.connect(connectTimeout);
            try {
                this.session.setPortForwardingL(localPort, dbHost, dbPort);
            }
            catch (JSchException e) {
                this.closeTunnel(monitor);
                throw e;
            }
        }
        catch (JSchException e) {
            throw new DBException("Cannot establish tunnel", e);
        }
        this.savedLocalPort = localPort;
        this.savedConfiguration = configuration;
        this.savedConnectionInfo = connectionInfo;
        connectionInfo = new DBPConnectionConfiguration(connectionInfo);
        String newPortValue = String.valueOf(localPort);
        connectionInfo.setHostName(LOCALHOST_NAME);
        connectionInfo.setHostPort(newPortValue);
        String newURL = configuration.getDriver().getDataSourceProvider().getConnectionURL(configuration.getDriver(), connectionInfo);
        connectionInfo.setUrl(newURL);
        return connectionInfo;
    }

    private int findFreePort(DBPPlatform platform) {
        DBPPreferenceStore store = platform.getPreferenceStore();
        int minPort = store.getInt("net.tunnel.port.min");
        int maxPort = store.getInt("net.tunnel.port.max");
        return IOUtils.findFreePort((int)minPort, (int)maxPort);
    }

    @Override
    public void closeTunnel(DBRProgressMonitor monitor) throws DBException, IOException {
        if (this.session != null) {
            RuntimeUtils.runTask(new DBRRunnableWithProgress(){

                @Override
                public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        SSHTunnelImpl.this.session.disconnect();
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            }, "Close SSH session", 1000L);
            this.session = null;
        }
    }

    @Override
    public DBWTunnel.AuthCredentials getRequiredCredentials(DBWHandlerConfiguration configuration) {
        if (!configuration.isEnabled() || !configuration.isSecured()) {
            return DBWTunnel.AuthCredentials.NONE;
        }
        if (configuration.isSavePassword()) {
            return DBWTunnel.AuthCredentials.NONE;
        }
        String sshAuthType = configuration.getProperties().get("authType");
        SSHConstants.AuthType authType = SSHConstants.AuthType.PASSWORD;
        if (sshAuthType != null) {
            authType = SSHConstants.AuthType.valueOf(sshAuthType);
        }
        if (authType == SSHConstants.AuthType.PUBLIC_KEY) {
            String privKeyPath = configuration.getProperties().get("keyPath");
            if (privKeyPath != null) {
                try {
                    JSch testSch = new JSch();
                    testSch.addIdentity(privKeyPath);
                    IdentityRepository ir = testSch.getIdentityRepository();
                    Vector identities = ir.getIdentities();
                    for (Identity identity : identities) {
                        if (!identity.isEncrypted()) continue;
                        return DBWTunnel.AuthCredentials.PASSWORD;
                    }
                }
                catch (JSchException e) {
                    log.debug("Can't check private key encryption: " + e.getMessage());
                }
            }
            return DBWTunnel.AuthCredentials.NONE;
        }
        return DBWTunnel.AuthCredentials.CREDENTIALS;
    }

    @Override
    public void invalidateHandler(DBRProgressMonitor monitor) throws DBException, IOException {
        boolean isAlive;
        boolean bl = isAlive = this.session != null && this.session.isConnected();
        if (isAlive) {
            try {
                this.session.sendKeepAliveMsg();
            }
            catch (Exception exception) {
                isAlive = false;
            }
        }
        if (!isAlive) {
            this.closeTunnel(monitor);
            this.initializeTunnel(monitor, null, this.savedConfiguration, this.savedConnectionInfo);
        }
    }

    private class LoggerProxy
    implements Logger {
        private LoggerProxy() {
        }

        public boolean isEnabled(int level) {
            return true;
        }

        public void log(int level, String message) {
            String levelStr;
            switch (level) {
                case 1: {
                    levelStr = "INFO";
                    break;
                }
                case 2: {
                    levelStr = "WARN";
                    break;
                }
                case 3: {
                    levelStr = "ERROR";
                    break;
                }
                case 4: {
                    levelStr = "FATAL";
                    break;
                }
                default: {
                    levelStr = "DEBUG";
                }
            }
            log.debug("SSH " + levelStr + ": " + message);
        }
    }

    private class UIUserInfo
    implements UserInfo {
        DBWHandlerConfiguration configuration;

        private UIUserInfo(DBWHandlerConfiguration configuration) {
            this.configuration = configuration;
        }

        public String getPassphrase() {
            return this.configuration.getPassword();
        }

        public String getPassword() {
            return this.configuration.getPassword();
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptYesNo(String message) {
            return false;
        }

        public void showMessage(String message) {
            log.info(message);
        }
    }
}

