/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.StringContentStorage;
import org.jkiss.dbeaver.model.impl.data.AbstractContent;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.ContentUtils;

public class StringContent
extends AbstractContent {
    private StringContentStorage storage;

    public StringContent(DBPDataSource dataSource, String data) {
        super(dataSource);
        this.storage = new StringContentStorage(data);
    }

    @Override
    public long getContentLength() throws DBCException {
        return this.storage.getContentLength();
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    @Override
    public String getDisplayString(DBDDisplayFormat format) {
        return this.storage.getCachedValue();
    }

    @Override
    public DBDContentStorage getContents(DBRProgressMonitor monitor) throws DBCException {
        return this.storage;
    }

    @Override
    public boolean updateContents(DBRProgressMonitor monitor, DBDContentStorage storage) throws DBException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Reader reader = storage.getContentReader();){
                StringWriter sw = new StringWriter((int)storage.getContentLength());
                ContentUtils.copyStreams(reader, storage.getContentLength(), sw, monitor);
                this.storage = new StringContentStorage(sw.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DBCException("IO error while reading content", e);
        }
        return true;
    }

    @Override
    public Object getRawValue() {
        return this.storage.getCachedValue();
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public void release() {
    }
}

