/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data;

import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraintBase;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.utils.CommonUtils;

public class DBDAttributeConstraint
extends DBDAttributeConstraintBase {
    private final DBSAttributeBase attribute;
    private final int originalVisualPosition;

    public DBDAttributeConstraint(DBDAttributeBinding attribute) {
        this.attribute = attribute;
        this.originalVisualPosition = attribute.getOrdinalPosition();
        this.setVisualPosition(this.originalVisualPosition);
    }

    public DBDAttributeConstraint(DBSAttributeBase attribute, int visualPosition) {
        this.attribute = attribute;
        this.originalVisualPosition = visualPosition;
        this.setVisualPosition(this.originalVisualPosition);
    }

    public DBDAttributeConstraint(DBDAttributeConstraint source) {
        super(source);
        this.attribute = source.attribute;
        this.originalVisualPosition = source.originalVisualPosition;
    }

    public DBSAttributeBase getAttribute() {
        return this.attribute;
    }

    public int getOriginalVisualPosition() {
        return this.originalVisualPosition;
    }

    @Override
    public boolean hasFilter() {
        return super.hasFilter() || this.originalVisualPosition != this.getVisualPosition();
    }

    @Override
    public void reset() {
        super.reset();
        this.setVisualPosition(this.originalVisualPosition);
    }

    @Override
    public boolean equalFilters(DBDAttributeConstraintBase obj, boolean compareOrders) {
        return obj instanceof DBDAttributeConstraint && CommonUtils.equalObjects((Object)this.attribute, (Object)((DBDAttributeConstraint)obj).attribute) && super.equalFilters(obj, compareOrders);
    }

    @Override
    public int hashCode() {
        return this.attribute.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DBDAttributeConstraint) {
            DBDAttributeConstraint source = (DBDAttributeConstraint)obj;
            return CommonUtils.equalObjects((Object)this.attribute, (Object)source.attribute) && super.equals(obj);
        }
        return false;
    }

    public String toString() {
        String clause = this.getOperator() == null ? (this.getCriteria() == null ? "" : this.getCriteria()) : String.valueOf(this.isReverseOperator() ? "NOT " : "") + this.getOperator().getStringValue() + " " + this.getValue();
        return String.valueOf(this.attribute.getName()) + " " + clause;
    }

    public boolean matches(DBSAttributeBase attr, boolean matchByName) {
        return this.attribute == attr || this.attribute instanceof DBDAttributeBinding && ((DBDAttributeBinding)this.attribute).matches(attr, matchByName);
    }
}

