/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.connection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.connection.DBPConnectionEventType;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DBPConnectionConfiguration
implements DBPObject {
    private String hostName;
    private String hostPort;
    private String serverName;
    private String databaseName;
    private String userName;
    private String userPassword;
    private String url;
    private String clientHomeId;
    @NotNull
    private final Map<String, String> properties;
    @NotNull
    private final Map<String, String> providerProperties;
    @NotNull
    private final Map<DBPConnectionEventType, DBRShellCommand> events;
    @NotNull
    private final List<DBWHandlerConfiguration> handlers;
    private final DBPConnectionBootstrap bootstrap;
    private DBPConnectionType connectionType;
    private String connectionColor;
    private int keepAliveInterval;

    public DBPConnectionConfiguration() {
        this.connectionType = DBPConnectionType.DEFAULT_TYPE;
        this.properties = new HashMap<String, String>();
        this.providerProperties = new HashMap<String, String>();
        this.events = new HashMap<DBPConnectionEventType, DBRShellCommand>();
        this.handlers = new ArrayList<DBWHandlerConfiguration>();
        this.bootstrap = new DBPConnectionBootstrap();
        this.keepAliveInterval = 0;
    }

    public DBPConnectionConfiguration(@NotNull DBPConnectionConfiguration info) {
        this.hostName = info.hostName;
        this.hostPort = info.hostPort;
        this.serverName = info.serverName;
        this.databaseName = info.databaseName;
        this.userName = info.userName;
        this.userPassword = info.userPassword;
        this.url = info.url;
        this.clientHomeId = info.clientHomeId;
        this.connectionType = info.connectionType;
        this.properties = new HashMap<String, String>(info.properties);
        this.providerProperties = new HashMap<String, String>(info.providerProperties);
        this.events = new HashMap<DBPConnectionEventType, DBRShellCommand>(info.events.size());
        for (Map.Entry<DBPConnectionEventType, DBRShellCommand> entry : info.events.entrySet()) {
            this.events.put(entry.getKey(), new DBRShellCommand(entry.getValue()));
        }
        this.handlers = new ArrayList<DBWHandlerConfiguration>(info.handlers.size());
        for (DBWHandlerConfiguration handler : info.handlers) {
            this.handlers.add(new DBWHandlerConfiguration(handler));
        }
        this.bootstrap = new DBPConnectionBootstrap(info.bootstrap);
        this.keepAliveInterval = info.keepAliveInterval;
    }

    public String getClientHomeId() {
        return this.clientHomeId;
    }

    public void setClientHomeId(String clientHomeId) {
        this.clientHomeId = clientHomeId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostPort() {
        return this.hostPort;
    }

    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(@Nullable String userPassword) {
        this.userPassword = userPassword;
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    @NotNull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(@NotNull Map<String, String> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    public String getProviderProperty(String name) {
        return this.providerProperties.get(name);
    }

    public void setProviderProperty(String name, String value) {
        this.providerProperties.put(name, value);
    }

    @NotNull
    public Map<String, String> getProviderProperties() {
        return this.providerProperties;
    }

    public void setProviderProperties(@NotNull Map<String, String> properties) {
        this.providerProperties.clear();
        this.providerProperties.putAll(properties);
    }

    public DBRShellCommand getEvent(DBPConnectionEventType eventType) {
        return this.events.get((Object)eventType);
    }

    public void setEvent(DBPConnectionEventType eventType, DBRShellCommand command) {
        if (command == null) {
            this.events.remove((Object)eventType);
        } else {
            this.events.put(eventType, command);
        }
    }

    public DBPConnectionEventType[] getDeclaredEvents() {
        Set<DBPConnectionEventType> eventTypes = this.events.keySet();
        return eventTypes.toArray(new DBPConnectionEventType[eventTypes.size()]);
    }

    public List<DBWHandlerConfiguration> getDeclaredHandlers() {
        return this.handlers;
    }

    public DBWHandlerConfiguration getDeclaredHandler(String id) {
        for (DBWHandlerConfiguration cfg : this.handlers) {
            if (!cfg.getId().equals(id)) continue;
            return cfg;
        }
        return null;
    }

    public void setHandlers(@NotNull List<DBWHandlerConfiguration> handlers) {
        this.handlers.clear();
        this.handlers.addAll(handlers);
    }

    public void addHandler(DBWHandlerConfiguration handler) {
        int i = 0;
        while (i < this.handlers.size()) {
            if (this.handlers.get(i).getId().equals(handler.getId())) {
                return;
            }
            ++i;
        }
        this.handlers.add(handler);
    }

    @Nullable
    public DBWHandlerConfiguration getHandler(String id) {
        for (DBWHandlerConfiguration handler : this.handlers) {
            if (!handler.getId().equals(id)) continue;
            return handler;
        }
        return null;
    }

    public DBPConnectionType getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(DBPConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    public String getConnectionColor() {
        return this.connectionColor;
    }

    public void setConnectionColor(String color) {
        this.connectionColor = color;
    }

    @NotNull
    public DBPConnectionBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepAliveInterval(int keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public String toString() {
        return "Connection: " + (this.url == null ? this.databaseName : this.url);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DBPConnectionConfiguration)) {
            return false;
        }
        DBPConnectionConfiguration source = (DBPConnectionConfiguration)obj;
        return CommonUtils.equalObjects((Object)this.hostName, (Object)source.hostName) && CommonUtils.equalObjects((Object)this.hostPort, (Object)source.hostPort) && CommonUtils.equalObjects((Object)this.serverName, (Object)source.serverName) && CommonUtils.equalObjects((Object)this.databaseName, (Object)source.databaseName) && CommonUtils.equalObjects((Object)this.userName, (Object)source.userName) && CommonUtils.equalObjects((Object)this.userPassword, (Object)source.userPassword) && CommonUtils.equalObjects((Object)this.url, (Object)source.url) && CommonUtils.equalObjects((Object)this.clientHomeId, (Object)source.clientHomeId) && CommonUtils.equalObjects((Object)this.connectionType, (Object)source.connectionType) && CommonUtils.equalObjects(this.properties, source.properties) && CommonUtils.equalObjects(this.providerProperties, source.providerProperties) && CommonUtils.equalObjects(this.events, source.events) && CommonUtils.equalObjects(this.handlers, source.handlers) && CommonUtils.equalObjects((Object)this.bootstrap, (Object)source.bootstrap) && this.keepAliveInterval == source.keepAliveInterval;
    }

    public void resolveSystemEnvironmentVariables() {
        this.hostName = this.hostName != null ? GeneralUtils.replaceSystemEnvironmentVariables(this.hostName) : null;
        this.hostPort = this.hostPort != null ? GeneralUtils.replaceSystemEnvironmentVariables(this.hostPort) : null;
        this.serverName = this.serverName != null ? GeneralUtils.replaceSystemEnvironmentVariables(this.serverName) : null;
        this.databaseName = this.databaseName != null ? GeneralUtils.replaceSystemEnvironmentVariables(this.databaseName) : null;
        this.userName = this.userName != null ? GeneralUtils.replaceSystemEnvironmentVariables(this.userName) : null;
        this.userPassword = this.userPassword != null ? GeneralUtils.replaceSystemEnvironmentVariables(this.userPassword) : null;
        this.url = this.url != null ? GeneralUtils.replaceSystemEnvironmentVariables(this.url) : null;
        for (String prop : this.properties.keySet()) {
            String value = this.properties.get(prop);
            if (CommonUtils.isEmpty((String)value)) continue;
            this.properties.put(prop, GeneralUtils.replaceSystemEnvironmentVariables(value));
        }
    }
}

