/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.oci;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.oci.OCIUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCClientHome;
import org.jkiss.utils.CommonUtils;

public class OracleHomeDescriptor
extends JDBCClientHome {
    private static final Log log = Log.getLog(OracleHomeDescriptor.class);
    private Integer oraVersion;
    private String fullOraVersion;
    private boolean isInstantClient;
    private String displayName;
    private List<String> tnsNames;

    public OracleHomeDescriptor(String oraHome) {
        super(CommonUtils.removeTrailingSlash((String)oraHome), oraHome);
        this.isInstantClient = OCIUtils.isInstantClient(oraHome);
        this.oraVersion = this.getOracleVersion();
        if (this.oraVersion == null) {
            log.debug((Object)("Unrecognized Oracle client version at " + oraHome));
        }
        this.displayName = OCIUtils.readWinRegistry(oraHome, "ORACLE_HOME_NAME");
    }

    private Integer getOracleVersion() {
        File folder;
        File oraHome = this.getHomePath();
        File file = folder = this.isInstantClient ? oraHome : new File(oraHome, "bin");
        if (!folder.exists()) {
            return null;
        }
        int counter = 7;
        while (counter <= 15) {
            String dllName = System.mapLibraryName("ocijdbc" + counter);
            File ociLibFile = new File(folder, dllName);
            if (ociLibFile.exists()) {
                return counter;
            }
            ++counter;
        }
        return null;
    }

    public Integer getOraVersion() {
        return this.oraVersion;
    }

    public String getProductName() {
        return "Oracle" + (this.oraVersion == null ? "" : " " + this.oraVersion);
    }

    public String getProductVersion() {
        if (this.fullOraVersion == null) {
            this.fullOraVersion = OCIUtils.getFullOraVersion(this.getHomeId(), this.isInstantClient);
            if (this.fullOraVersion == null) {
                this.fullOraVersion = "Unknown";
            }
        }
        return this.fullOraVersion;
    }

    public boolean isInstantClient() {
        return this.isInstantClient;
    }

    public String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.getHomeId();
    }

    public Collection<String> getOraServiceNames() {
        if (this.tnsNames == null) {
            this.tnsNames = new ArrayList<String>(OCIUtils.readTnsNames(this.getHomePath(), true).keySet());
        }
        return this.tnsNames;
    }
}

