/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import org.jkiss.dbeaver.ext.oracle.actions.CompileHandler;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectPersistAction;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleSourceObject;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileError;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileLog;
import org.jkiss.dbeaver.model.exec.compile.DBCCompileLogBase;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;

public class OracleObjectValidateAction
extends OracleObjectPersistAction {
    private final OracleSourceObject object;

    public OracleObjectValidateAction(OracleSourceObject object, OracleObjectType objectType, String title, String script) {
        super(objectType, title, script);
        this.object = object;
    }

    public void afterExecute(DBCSession session, Throwable error) throws DBCException {
        if (error != null) {
            return;
        }
        DBCCompileLogBase log = new DBCCompileLogBase();
        CompileHandler.logObjectErrors((JDBCSession)session, (DBCCompileLog)log, this.object, this.getObjectType());
        if (!log.getErrorStack().isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append("Error during ").append(this.getObjectType().getTypeName()).append(" '").append(this.object.getName()).append("' validation:");
            for (DBCCompileError e : log.getErrorStack()) {
                message.append("\n");
                message.append(e.toString());
            }
            throw new DBCException(message.toString());
        }
    }
}

