/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleConstants;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.dict.OracleConnectionType;
import org.jkiss.dbeaver.ext.oracle.oci.OCIUtils;
import org.jkiss.dbeaver.ext.oracle.oci.OracleHomeDescriptor;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPClientHome;
import org.jkiss.dbeaver.model.connection.DBPClientManager;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class OracleDataSourceProvider
extends JDBCDataSourceProvider
implements DBPClientManager {
    public long getFeatures() {
        return 2L;
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        String conTypeProperty = connectionInfo.getProviderProperty("@dbeaver-connection-type@");
        OracleConstants.ConnectionType connectionType = conTypeProperty != null ? OracleConstants.ConnectionType.valueOf(CommonUtils.toString((Object)conTypeProperty)) : OracleConstants.ConnectionType.BASIC;
        if (connectionType == OracleConstants.ConnectionType.CUSTOM) {
            return connectionInfo.getUrl();
        }
        StringBuilder url = new StringBuilder(100);
        url.append("jdbc:oracle:thin:@");
        if (connectionType == OracleConstants.ConnectionType.TNS) {
            boolean checkTnsAdmin;
            File oraHomePath;
            String tnsPathProp = CommonUtils.toString((Object)connectionInfo.getProviderProperty("@dbeaver-tns-path@"));
            if (!CommonUtils.isEmpty((String)tnsPathProp)) {
                oraHomePath = new File(tnsPathProp);
                checkTnsAdmin = false;
            } else {
                String clientHomeId = connectionInfo.getClientHomeId();
                OracleHomeDescriptor oraHome = CommonUtils.isEmpty((String)clientHomeId) ? null : OCIUtils.getOraHome(clientHomeId);
                oraHomePath = oraHome == null ? null : oraHome.getHomePath();
                checkTnsAdmin = true;
            }
            Map<String, String> tnsNames = OCIUtils.readTnsNames(oraHomePath, checkTnsAdmin);
            String tnsDescription = tnsNames.get(connectionInfo.getDatabaseName());
            if (!CommonUtils.isEmpty((String)tnsDescription)) {
                url.append(tnsDescription);
            } else {
                File tnsNamesFile = OCIUtils.findTnsNamesFile(oraHomePath, checkTnsAdmin);
                if (tnsNamesFile != null && tnsNamesFile.exists()) {
                    System.setProperty("oracle.net.tns_admin", tnsNamesFile.getAbsolutePath());
                }
                url.append(connectionInfo.getDatabaseName());
            }
        } else {
            boolean isSID = OracleConnectionType.SID.name().equals(connectionInfo.getProviderProperty("@dbeaver-sid-service@"));
            if (!isSID) {
                url.append("//");
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                url.append(connectionInfo.getHostName());
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                url.append(":");
                url.append(connectionInfo.getHostPort());
            }
            if (isSID) {
                url.append(":");
            } else {
                url.append("/");
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
                url.append(connectionInfo.getDatabaseName());
            }
        }
        return url.toString();
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new OracleDataSource(monitor, container);
    }

    public Collection<String> findClientHomeIds() {
        ArrayList<String> homeIds = new ArrayList<String>();
        for (OracleHomeDescriptor home : OCIUtils.getOraHomes()) {
            homeIds.add(home.getHomeId());
        }
        return homeIds;
    }

    public String getDefaultClientHomeId() {
        List<OracleHomeDescriptor> oraHomes = OCIUtils.getOraHomes();
        if (!oraHomes.isEmpty()) {
            return oraHomes.get(0).getHomeId();
        }
        return null;
    }

    public DBPClientHome getClientHome(String homeId) {
        return new OracleHomeDescriptor(homeId);
    }
}

