/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mockdata.generator;

import java.io.IOException;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mockdata.generator.AbstractMockValueGenerator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;

public class BooleanSequenceGenerator
extends AbstractMockValueGenerator {
    private boolean value;
    private ORDER order;

    @Override
    public void init(DBSDataManipulator container, DBSAttributeBase attribute, Map<Object, Object> properties) throws DBException {
        Boolean initial;
        super.init(container, attribute, properties);
        String o = (String)properties.get("order");
        if (o != null) {
            this.order = ORDER.valueOf(o);
        }
        if ((initial = (Boolean)properties.get("initial")) != null) {
            this.value = initial == false;
        }
    }

    @Override
    public Object generateOneValue(DBRProgressMonitor monitor) throws DBException, IOException {
        if (this.isGenerateNULL()) {
            return null;
        }
        switch (this.order) {
            case CONSTANT: {
                return this.value;
            }
            case ALTERNATELY: {
                this.value = !this.value;
                return this.value;
            }
        }
        return null;
    }

    private static enum ORDER {
        ALTERNATELY,
        CONSTANT;

    }
}

