/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.lm.core;

import com.dbeaver.lm.core.LicenseCheckResult;
import com.dbeaver.lm.internal.core.PublicServiceClient;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseManager;
import org.jkiss.lm.LMLicenseStatus;
import org.jkiss.lm.LMLicenseValidator;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMUtils;
import org.jkiss.lm.LMValidateException;
import org.jkiss.utils.CommonUtils;

public class LMPublicAPI {
    public static final String BUNDLE_SYMBOLIC_NAME = "com.dbeaver.lm.core";
    public static final LMLicenseValidator PUBLIC_LICENSE_VALIDATOR = new PublicLicenseValidator();
    private static final Log log = Log.getLog(LMPublicAPI.class);

    public static IStatus generateTrialLicense(IProgressMonitor iProgressMonitor, LMLicenseManager lMLicenseManager, LMProduct lMProduct, String string, String string2, String string3, String string4) {
        return LMPublicAPI.generateLicense(iProgressMonitor, lMLicenseManager, lMProduct, string, string2, string3, string4);
    }

    public static LicenseCheckResult checkLicenseStatus(IProgressMonitor iProgressMonitor, LMLicense lMLicense) {
        iProgressMonitor.beginTask("Check license status", 3);
        try {
            LMLicenseStatus lMLicenseStatus;
            String string;
            String string2;
            PublicServiceClient publicServiceClient = new PublicServiceClient(2000, 2000);
            try {
                iProgressMonitor.subTask("Validate thru public service");
                String string3 = publicServiceClient.checkLicenseStatus(lMLicense);
                iProgressMonitor.worked(1);
                if (CommonUtils.isEmpty((String)string3)) {
                    LicenseCheckResult licenseCheckResult = new LicenseCheckResult(Status.OK_STATUS, LMLicenseStatus.VALID);
                    return licenseCheckResult;
                }
                int n = string3.indexOf(58);
                if (n == -1) {
                    LicenseCheckResult licenseCheckResult = new LicenseCheckResult(GeneralUtils.makeErrorStatus((String)("Bad check status: " + string3)), LMLicenseStatus.INVALID);
                    return licenseCheckResult;
                }
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            }
            catch (Exception exception) {
                LicenseCheckResult licenseCheckResult = new LicenseCheckResult(GeneralUtils.makeErrorStatus((String)"Error checking license status", (Throwable)exception), LMLicenseStatus.VALID);
                return licenseCheckResult;
            }
            try {
                lMLicenseStatus = LMLicenseStatus.valueOf((String)string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.debug((Object)("Bad license status: [" + string2 + "]"));
                lMLicenseStatus = LMLicenseStatus.VALID;
            }
            LicenseCheckResult licenseCheckResult = new LicenseCheckResult(GeneralUtils.makeInfoStatus((String)string), lMLicenseStatus);
            return licenseCheckResult;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private static IStatus generateLicense(IProgressMonitor iProgressMonitor, LMLicenseManager lMLicenseManager, LMProduct lMProduct, String string, String string2, String string3, String string4) {
        iProgressMonitor.beginTask("Generate trial license", 3);
        try {
            String string5;
            Object object;
            PublicServiceClient publicServiceClient = new PublicServiceClient();
            try {
                iProgressMonitor.subTask("Check license server");
                log.debug((Object)"Ping license server");
                object = publicServiceClient.ping();
                log.debug((Object)("Ping result: " + (String)object));
                iProgressMonitor.worked(1);
                iProgressMonitor.subTask("Generate license");
                log.debug((Object)"Request trial license");
                string5 = publicServiceClient.generateTrialLicense(lMProduct, string, string2, string3, string4);
                iProgressMonitor.worked(1);
            }
            catch (Exception exception) {
                IStatus iStatus = GeneralUtils.makeErrorStatus((String)"Can't contact license service at dbeaver.com", (Throwable)exception);
                iProgressMonitor.done();
                return iStatus;
            }
            try {
                iProgressMonitor.subTask("Import license");
                object = LMUtils.readEncryptedString((Reader)new StringReader(string5));
                lMLicenseManager.importLicense(lMProduct, (byte[])object);
                iProgressMonitor.worked(1);
            }
            catch (Throwable throwable) {
                IStatus iStatus = GeneralUtils.makeErrorStatus((String)"Trial license corrupted or doesn't match the product", (Throwable)throwable);
                iProgressMonitor.done();
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private static class PublicLicenseValidator
    implements LMLicenseValidator {
        private final Map<String, LicenseCheckResult> validateCache = new HashMap<String, LicenseCheckResult>();

        private PublicLicenseValidator() {
        }

        public void validateLicense(LMProduct lMProduct, LMLicense lMLicense) throws LMValidateException {
            LicenseCheckResult licenseCheckResult = this.validateCache.get(lMLicense.getLicenseId());
            if (licenseCheckResult == null) {
                try {
                    licenseCheckResult = LMPublicAPI.checkLicenseStatus((IProgressMonitor)new NullProgressMonitor(), lMLicense);
                }
                finally {
                    if (licenseCheckResult != null) {
                        this.validateCache.put(lMLicense.getLicenseId(), licenseCheckResult);
                    }
                }
            }
            if (licenseCheckResult.getLicenseStatus() != LMLicenseStatus.VALID) {
                throw new LMValidateException(lMLicense, licenseCheckResult.getLicenseStatus(), licenseCheckResult.getCheckStatus().getMessage(), licenseCheckResult.getCheckStatus().getException());
            }
        }
    }
}

