/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.core.VDriver;
import com.vertica.dsi.dataengine.utilities.DSITimeSpan;
import com.vertica.localization.VMessageKey;
import java.util.Locale;

public class VerticaDayTimeInterval
extends DSITimeSpan
implements Cloneable {
    public static final int INTERVAL_DAY = 103;
    public static final int INTERVAL_DAY_TO_HOUR = 108;
    public static final int INTERVAL_DAY_TO_MINUTE = 109;
    public static final int INTERVAL_DAY_TO_SECOND = 110;
    public static final int INTERVAL_HOUR = 104;
    public static final int INTERVAL_HOUR_TO_MINUTE = 111;
    public static final int INTERVAL_HOUR_TO_SECOND = 112;
    public static final int INTERVAL_MINUTE = 105;
    public static final int INTERVAL_MINUTE_TO_SECOND = 113;
    public static final int INTERVAL_SECOND = 106;
    private static final int NANOS_PER_SEC = 1000000000;
    private static final int SECONDS_PER_MIN = 60;
    private static final int MINS_PER_HOUR = 60;
    private static final int HOURS_PER_DAY = 24;
    private static Locale s_locale;
    private int fracPrecision;

    public VerticaDayTimeInterval(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this(110, n, n2, n3, n4, n5, n6, bl);
    }

    public VerticaDayTimeInterval(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        super(VerticaDayTimeInterval.checkType(n), 0, 0, 0, 0, 0, bl);
        s_locale = Locale.getDefault();
        this.convertAndSet(n2, n3, n4, n5, n6, n7);
    }

    private static int checkType(int n) {
        switch (n) {
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return n;
            }
        }
        throw new IllegalArgumentException(VDriver.s_msgSrc.loadMessage(s_locale, 101, VMessageKey.ERROR_INVALID_INTERVAL_TYPE.toString(), n + ""));
    }

    public int getPrecision() {
        return this.fracPrecision;
    }

    private void convertAndSet(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0 || n6 < 0) {
            throw new IllegalArgumentException(VDriver.s_msgSrc.loadMessage(s_locale, 101, VMessageKey.ERROR_NEGATIVE_INTERVAL_FIELD.toString()));
        }
        if (n6 > 6) {
            // empty if block
        }
        int n8 = 1;
        for (n7 = n6; n7 != 0; --n7) {
            n8 *= 10;
        }
        if (n6 > 0 && n5 >= n8) {
            n4 += n5 / n8;
            n5 %= n8;
        }
        if (n4 < 0) {
            throw new IllegalArgumentException(VDriver.s_msgSrc.loadMessage(s_locale, 101, VMessageKey.ERROR_INTERVAL_FIELD_OVERFLOW.toString(), "seconds"));
        }
        if (n4 >= 60) {
            n3 += n4 / 60;
            n4 %= 60;
        }
        if (n3 < 0) {
            throw new IllegalArgumentException(VDriver.s_msgSrc.loadMessage(s_locale, 101, VMessageKey.ERROR_INTERVAL_FIELD_OVERFLOW.toString(), "minutes"));
        }
        if (n3 >= 60) {
            n2 += n3 / 60;
            n3 %= 60;
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(VDriver.s_msgSrc.loadMessage(s_locale, 101, VMessageKey.ERROR_INTERVAL_FIELD_OVERFLOW.toString(), "hours"));
        }
        if (n2 >= 24) {
            n += n2 / 24;
            n2 %= 24;
        }
        if (n < 0) {
            throw new IllegalArgumentException(VDriver.s_msgSrc.loadMessage(s_locale, 101, VMessageKey.ERROR_INTERVAL_FIELD_OVERFLOW.toString(), "days"));
        }
        n7 = this.getIntervalType();
        switch (n7) {
            case 104: 
            case 105: 
            case 106: 
            case 111: 
            case 112: 
            case 113: {
                if (n != 0) {
                    n2 += 24 * n;
                    n = 0;
                }
                if (n2 >= 0) break;
                throw new IllegalArgumentException(VDriver.s_msgSrc.loadMessage(s_locale, 101, VMessageKey.ERROR_INTERVAL_FIELD_OVERFLOW.toString(), "hours"));
            }
        }
        switch (n7) {
            case 105: 
            case 106: 
            case 113: {
                if (n2 != 0) {
                    n3 += 60 * n2;
                    n2 = 0;
                }
                if (n3 >= 0) break;
                throw new IllegalArgumentException(VDriver.s_msgSrc.loadMessage(s_locale, 101, VMessageKey.ERROR_INTERVAL_FIELD_OVERFLOW.toString(), "minutes"));
            }
        }
        if (n7 == 106 && n3 != 0) {
            n4 += 60 * n3;
            n3 = 0;
            if (n4 < 0) {
                throw new IllegalArgumentException(VDriver.s_msgSrc.loadMessage(s_locale, 101, VMessageKey.ERROR_INTERVAL_FIELD_OVERFLOW.toString(), "seconds"));
            }
        }
        super.setDay(n);
        super.setHour(n2);
        super.setMinute(n3);
        super.setSecond(n4);
        super.setFraction(n5);
        this.fracPrecision = n6;
    }

    public void setDay(int n) {
        this.convertAndSet(n, this.getHour(), this.getMinute(), this.getSecond(), this.getFraction(), this.getPrecision());
    }

    public void setHour(int n) {
        this.convertAndSet(this.getDay(), n, this.getMinute(), this.getSecond(), this.getFraction(), this.getPrecision());
    }

    public void setMinute(int n) {
        this.convertAndSet(this.getDay(), this.getHour(), n, this.getSecond(), this.getFraction(), this.getPrecision());
    }

    public void setSecond(int n) {
        this.convertAndSet(this.getDay(), this.getHour(), this.getMinute(), n, this.getFraction(), this.getPrecision());
    }

    public void setFraction(int n, int n2) {
        this.convertAndSet(this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), n, n2);
    }

    public void setIsNegative(boolean bl) {
        super.setIsNegative(bl);
    }

    public int hashCode() {
        int n = 1;
        for (int i = this.fracPrecision; i < 9; ++i) {
            n *= 10;
        }
        return this.isNegative() ? -1 : 1 * (this.getDay() * 24 * 60 * 60 * 1000000000 + this.getHour() * 60 * 60 * 1000000000 + this.getMinute() * 60 * 1000000000 + this.getSecond() * 1000000000 + this.getFraction() * n);
    }

    public boolean equals(Object object) {
        if (object instanceof VerticaDayTimeInterval) {
            VerticaDayTimeInterval verticaDayTimeInterval = (VerticaDayTimeInterval)object;
            VerticaDayTimeInterval verticaDayTimeInterval2 = new VerticaDayTimeInterval(110, this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), this.getFraction(), this.getPrecision(), verticaDayTimeInterval.isNegative());
            VerticaDayTimeInterval verticaDayTimeInterval3 = this.getIntervalType() == 110 ? this : new VerticaDayTimeInterval(110, this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), this.getFraction(), this.getPrecision(), this.isNegative());
            return verticaDayTimeInterval3.isNegative() == verticaDayTimeInterval2.isNegative() && verticaDayTimeInterval3.getDay() == verticaDayTimeInterval2.getDay() && verticaDayTimeInterval3.getHour() == verticaDayTimeInterval2.getHour() && verticaDayTimeInterval3.getMinute() == verticaDayTimeInterval2.getMinute() && verticaDayTimeInterval3.getSecond() == verticaDayTimeInterval2.getSecond() && verticaDayTimeInterval3.getFraction() == verticaDayTimeInterval2.getFraction() && verticaDayTimeInterval3.getPrecision() == verticaDayTimeInterval2.getPrecision();
        }
        return false;
    }

    public VerticaDayTimeInterval clone() throws CloneNotSupportedException {
        return new VerticaDayTimeInterval(this.getIntervalType(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), this.getFraction(), this.getPrecision(), this.isNegative());
    }

    public String toString() {
        int n = this.getIntervalType();
        int n2 = this.getDay();
        int n3 = this.getHour();
        int n4 = this.getMinute();
        int n5 = this.getSecond();
        int n6 = this.getFraction();
        String string = this.isNegative() ? "-" : "";
        String string2 = n6 == 0 || this.getPrecision() == 0 ? "" : ".%0" + this.getPrecision() + "d";
        switch (n) {
            case 103: {
                return String.format((n2 == 0 ? "" : string) + "%d", n2);
            }
            case 108: {
                if (n2 == 0) {
                    return String.format(string + "%02d", n3);
                }
                return String.format(string + "%d %02d", n2, n3);
            }
            case 109: {
                if (n2 == 0) {
                    return String.format(string + "%02d:%02d", n3, n4);
                }
                return String.format(string + "%d %02d:%02d", n2, n3, n4);
            }
            case 110: {
                if (n2 == 0) {
                    return String.format(string + "%02d:%02d:%02d" + string2, n3, n4, n5, n6);
                }
                return String.format(string + "%d %02d:%02d:%02d" + string2, n2, n3, n4, n5, n6);
            }
            case 104: {
                return String.format(string + "%02d", n3);
            }
            case 111: {
                return String.format(string + "%02d:%02d", n3, n4);
            }
            case 112: {
                return String.format(string + "%02d:%02d:%02d" + string2, n3, n4, n5, n6);
            }
            case 105: {
                return String.format(string + "%02d", n4);
            }
            case 113: {
                return String.format(string + "%02d:%02d" + string2, n4, n5, n6);
            }
            case 106: {
                return String.format(string + "%02d" + string2, n5, n6);
            }
        }
        assert (false);
        return String.format(string + "%d %02d:%02d:%02d" + string2, n2, n3, n4, n5, n6);
    }

    public int getIntervalType() {
        return super.getIntervalType();
    }

    public static boolean isDayTimeInterval(int n) {
        switch (n) {
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return true;
            }
        }
        return false;
    }
}

