/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.utilities.Searchable;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.dsi.dataengine.utilities.Updatable;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageBuilder;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.utilities.TypeNames;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SResultSetMetaData
implements ResultSetMetaData {
    private List<? extends IColumn> m_columnMetaData = new ArrayList<IColumn>();
    private boolean m_isOpen = false;
    private ILogger m_logger = null;
    private IWarningListener m_warningListener = null;

    protected SResultSetMetaData(List<? extends IColumn> list, ILogger iLogger, IWarningListener iWarningListener) {
        this.m_logger = iLogger;
        LogUtilities.logFunctionEntrance(this.m_logger, list, iLogger);
        this.m_warningListener = iWarningListener;
        this.m_isOpen = true;
        this.m_columnMetaData = list;
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            IColumn iColumn = this.getColumnMetadata(n);
            return iColumn.getCatalogName();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            TypeMetadata typeMetadata = this.getTypeMetadata(n);
            return TypeNames.getTypeClassName(typeMetadata.getType());
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_columnMetaData.size();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            IColumn iColumn = this.getColumnMetadata(n);
            long l = TypeUtilities.getDisplaySize(iColumn.getTypeMetadata(), iColumn.getColumnLength());
            if (Integer.MAX_VALUE < l || Integer.MIN_VALUE > l) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.COLUMN_DISPLAY_OVERFLOW, this.m_warningListener, String.valueOf(l));
            }
            return (int)l;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            IColumn iColumn = this.getColumnMetadata(n);
            return iColumn.getLabel();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            IColumn iColumn = this.getColumnMetadata(n);
            return iColumn.getName();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            TypeMetadata typeMetadata = this.getTypeMetadata(n);
            return TypeUtilities.mapDataTypes(typeMetadata.getType());
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            TypeMetadata typeMetadata = this.getTypeMetadata(n);
            return typeMetadata.getTypeName();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            IColumn iColumn = this.getColumnMetadata(n);
            TypeMetadata typeMetadata = iColumn.getTypeMetadata();
            if (typeMetadata.isCharacterOrBinaryType()) {
                return (int)iColumn.getColumnLength();
            }
            if (typeMetadata.isIntervalType()) {
                return typeMetadata.getIntervalPrecision();
            }
            return typeMetadata.getPrecision();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getScale(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            TypeMetadata typeMetadata = this.getTypeMetadata(n);
            return typeMetadata.getScale();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            IColumn iColumn = this.getColumnMetadata(n);
            return iColumn.getSchemaName();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getTableName(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            IColumn iColumn = this.getColumnMetadata(n);
            return iColumn.getTableName();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            IColumn iColumn = this.getColumnMetadata(n);
            return iColumn.isAutoUnique();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            IColumn iColumn = this.getColumnMetadata(n);
            return iColumn.isCaseSensitive();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            return false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            return this.getColumnMetadata(n).isDefinitelyWritable();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int isNullable(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            IColumn iColumn = this.getColumnMetadata(n);
            switch (iColumn.getNullable()) {
                case NO_NULLS: {
                    return 0;
                }
                case NULLABLE: {
                    return 1;
                }
            }
            return 2;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            IColumn iColumn = this.getColumnMetadata(n);
            return iColumn.getUpdatable() == Updatable.READ_ONLY || iColumn.getUpdatable() == Updatable.UNKNOWN;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            IColumn iColumn = this.getColumnMetadata(n);
            return iColumn.getSearchable() != Searchable.PREDICATE_NONE;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            TypeMetadata typeMetadata = this.getTypeMetadata(n);
            return typeMetadata.isSigned();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            IColumn iColumn = this.getColumnMetadata(n);
            return iColumn.getUpdatable() == Updatable.WRITE;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    protected synchronized void close() {
        this.m_isOpen = false;
    }

    private synchronized void checkIfOpen() throws SQLException {
        if (!this.m_isOpen) {
            SQLException sQLException = JDBCMessageBuilder.createSQLException(JDBCMessageKey.RESULTMETA_CLOSED, this.m_warningListener, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
    }

    private IColumn getColumnMetadata(int n) throws SQLException {
        if (!this.isValidIndex(n)) {
            SQLException sQLException = JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_COLUMN_INDEX, this.m_warningListener, String.valueOf(n));
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        return this.m_columnMetaData.get(n - 1);
    }

    private TypeMetadata getTypeMetadata(int n) throws SQLException {
        this.checkIfOpen();
        IColumn iColumn = this.getColumnMetadata(n);
        return iColumn.getTypeMetadata();
    }

    private boolean isValidIndex(int n) {
        return 0 < n && this.m_columnMetaData.size() >= n;
    }
}

