/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.interfaces.IDataEngine;
import com.vertica.dsi.dataengine.interfaces.IErrorResult;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.interfaces.IRowCountResult;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ExecutionContexts;
import com.vertica.dsi.dataengine.utilities.ExecutionResult;
import com.vertica.dsi.dataengine.utilities.ExecutionResultType;
import com.vertica.dsi.dataengine.utilities.ExecutionResults;
import com.vertica.dsi.dataengine.utilities.Nullable;
import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.dsi.dataengine.utilities.ParameterType;
import com.vertica.dsi.dataengine.utilities.TimeTz;
import com.vertica.dsi.dataengine.utilities.TimestampTz;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.exceptions.BadDefaultParamException;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.utilities.CalendarSetter;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageBuilder;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.SConnection;
import com.vertica.jdbc.SForwardResultSet;
import com.vertica.jdbc.SParameterMetaData;
import com.vertica.jdbc.SResultSetMetaData;
import com.vertica.jdbc.SStatement;
import com.vertica.streams.parameters.AbstractParameterStream;
import com.vertica.streams.parameters.AsciiParameterStream;
import com.vertica.streams.parameters.BinaryParameterStream;
import com.vertica.streams.parameters.CharacterParameterStream;
import com.vertica.streams.parameters.UnicodeParameterStream;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.utilities.FunctionID;
import com.vertica.utilities.conversion.TypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPreparedStatement
extends SStatement
implements PreparedStatement {
    protected ArrayList<ParameterMetadata> m_parameterMetadata = new ArrayList();
    protected int m_numParameters;
    protected List<ParameterType> m_parameterTypes;
    protected Map<Integer, ParameterInputValue> m_parameterInputValues = new TreeMap<Integer, ParameterInputValue>();
    protected Map<Integer, AbstractParameterStream> m_parameterInputStreams = new TreeMap<Integer, AbstractParameterStream>();
    protected boolean m_hasParameterBatch = false;
    protected List<Map<Integer, ParameterInputValue>> m_batchParameterInputValues = new ArrayList<Map<Integer, ParameterInputValue>>();
    protected List<Map<Integer, AbstractParameterStream>> m_batchParameterInputStreams = new ArrayList<Map<Integer, AbstractParameterStream>>();
    protected String m_preparedSql = "";
    private SResultSetMetaData m_metadata = null;
    private SParameterMetaData m_openParamMetaData = null;
    private List<DataWrapper> m_cachedDataWrappers = null;

    protected SPreparedStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(iStatement, sConnection, n);
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, iStatement, sConnection);
            this.m_preparedSql = string;
            this.checkIfNullSQL(string);
            IDataEngine iDataEngine = this.m_statement.createDataEngine();
            if (this.m_escapeProcessingEnabled && DSIDriverSingleton.getInstance().getProperty(10).getInt() == 1) {
                string = sConnection.nativeSQL(string);
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_PREPARE);
            this.m_queryExecutor = iDataEngine.prepare(string);
            iDataEngine.close();
            this.m_parameterMetadata = this.m_queryExecutor.getMetadataForParameters();
            if (null == this.m_parameterMetadata) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.NULL_PARAM_METADATA, this.m_warningListener, new Object[0]);
            }
            this.m_numParameters = this.m_parameterMetadata.size();
            this.m_cachedDataWrappers = new ArrayList<DataWrapper>(this.m_numParameters);
            this.m_parameterTypes = new ArrayList<ParameterType>(this.m_numParameters);
            boolean bl = true;
            for (int i = 0; i < this.m_numParameters; ++i) {
                ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(i);
                if (bl && parameterMetadata.getTypeMetadata().isCharacterOrBinaryType()) {
                    bl = false;
                    this.m_parentConnection.setMaxTypeValues();
                }
                this.m_parameterTypes.add(parameterMetadata.getParameterType());
                this.m_cachedDataWrappers.add(new DataWrapper());
            }
            this.checkParameters(this.m_parameterMetadata);
            this.clearParameters();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void addBatch() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (!this.allInputParameterValuesPopulated()) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_NUMBER_PARAMS, this.m_warningListener, new Object[0]);
            }
            this.m_batchParameterInputValues.add(this.m_parameterInputValues);
            this.m_batchParameterInputStreams.add(this.m_parameterInputStreams);
            this.m_parameterInputValues = new TreeMap<Integer, ParameterInputValue>(this.m_parameterInputValues);
            this.m_parameterInputStreams = new TreeMap<Integer, AbstractParameterStream>();
            this.m_cachedDataWrappers.clear();
            for (int i = 0; i < this.m_numParameters; ++i) {
                this.m_cachedDataWrappers.add(new DataWrapper());
            }
            this.m_hasParameterBatch = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void addBatch(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_STMT_ACTION, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            for (int i = 0; i < this.m_batchParameterInputValues.size(); ++i) {
                this.clearParameters(this.m_batchParameterInputValues.get(i), this.m_batchParameterInputStreams.get(i));
            }
            this.clearParameters(this.m_parameterInputValues, this.m_parameterInputStreams);
            if (null != this.m_queryExecutor) {
                this.m_queryExecutor.clearPushedParamData();
            }
            this.m_batchParameterInputStreams.clear();
            this.m_batchParameterInputValues.clear();
            this.m_hasParameterBatch = false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.clearParameters(this.m_parameterInputValues, this.m_parameterInputStreams);
            this.m_queryExecutor.clearPushedParamData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        try {
            this.clearBatch();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        super.close();
        if (null != this.m_queryExecutor) {
            this.m_queryExecutor.close();
            this.m_queryExecutor = null;
        }
        if (null != this.m_metadata) {
            this.m_metadata.close();
        }
        if (null != this.m_openParamMetaData) {
            this.m_openParamMetaData.close();
        }
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_queryExecutor.clearCancel();
            if (this.m_hasParameterBatch) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, this.m_warningListener, new Object[0]);
            }
            if (!this.allInputParameterValuesPopulated()) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_NUMBER_PARAMS, this.m_warningListener, new Object[0]);
            }
            this.m_parentConnection.beginTransaction();
            this.pushParameterStreams();
            this.clearResults();
            ExecutionResults executionResults = this.executeWithParams(this.m_parameterMetadata, this.getInputParameterValues(), SStatement.ThrowCondition.None);
            if (0 == executionResults.getResults().size()) {
                return false;
            }
            boolean bl = false;
            for (int i = 0; i < executionResults.getResults().size(); ++i) {
                ExecutionResult executionResult = executionResults.getResults().get(i);
                if (0 == i) {
                    bl = ExecutionResultType.RESULT_SET == executionResult.getType() || ExecutionResultType.ERROR_RESULT_SET == executionResult.getType();
                }
                this.addResultPair(this.createResultPair(executionResult));
            }
            SStatement.ResultContext resultContext = (SStatement.ResultContext)this.m_resultSets.get(0);
            if (2 == resultContext.m_resultType || 3 == resultContext.m_resultType) {
                throw ((IErrorResult)resultContext.m_result).getError();
            }
            return bl;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_STMT_ACTION, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String string, int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, n);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_STMT_ACTION, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String string, int[] nArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, nArray);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_STMT_ACTION, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, stringArray);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_STMT_ACTION, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_queryExecutor.clearCancel();
            this.m_parentConnection.beginTransaction();
            if (!this.m_hasParameterBatch && 0 < this.m_numParameters) {
                this.clearResults();
                this.addResultPair(new SStatement.ResultContext(new DSISimpleRowCountResult(0L)));
                int[] nArray = new int[]{};
                return nArray;
            }
            this.pushBatchParameterStreams();
            ExecutionContexts executionContexts = new ExecutionContexts(this.m_parameterMetadata, this.getBatchInputParameterValues());
            this.clearResults();
            this.m_warningListener.setCurrentFunction(FunctionID.STATEMENT_EXECUTE);
            this.m_queryExecutor.execute(executionContexts, this.m_warningListener);
            int[] nArray = this.processBatchResults(this.m_queryExecutor.getResults());
            return nArray;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
        finally {
            this.clearBatch();
        }
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_queryExecutor.clearCancel();
            if (this.m_hasParameterBatch) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, this.m_warningListener, new Object[0]);
            }
            if (!this.allInputParameterValuesPopulated()) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_NUMBER_PARAMS, this.m_warningListener, new Object[0]);
            }
            this.m_parentConnection.beginTransaction();
            this.pushParameterStreams();
            this.clearResults();
            ExecutionResults executionResults = this.executeWithParams(this.m_parameterMetadata, this.getInputParameterValues(), SStatement.ThrowCondition.SingleResult);
            ExecutionResult executionResult = executionResults.getResults().get(0);
            if (ExecutionResultType.ERROR_RESULT_SET == executionResult.getType()) {
                this.addResultPair(this.createResultPair(executionResult));
                throw ((IErrorResult)executionResult.getResult()).getError();
            }
            ResultSet resultSet = this.createResultSet(executionResult);
            ((SForwardResultSet)resultSet).initializeColumnNameMap();
            this.addResultSet(resultSet);
            return resultSet;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized ResultSet executeQuery(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_STMT_ACTION, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_queryExecutor.clearCancel();
            if (this.m_hasParameterBatch) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, this.m_warningListener, new Object[0]);
            }
            if (!this.allInputParameterValuesPopulated()) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_NUMBER_PARAMS, this.m_warningListener, new Object[0]);
            }
            this.m_parentConnection.beginTransaction();
            this.pushParameterStreams();
            this.clearResults();
            ExecutionResults executionResults = this.executeWithParams(this.m_parameterMetadata, this.getInputParameterValues(), SStatement.ThrowCondition.SingleRowCount);
            ExecutionResult executionResult = executionResults.getResults().get(0);
            if (ExecutionResultType.ERROR_ROW_COUNT == executionResult.getType()) {
                this.addResultPair(this.createResultPair(executionResult));
                throw ((IErrorResult)executionResult.getResult()).getError();
            }
            IRowCountResult iRowCountResult = (IRowCountResult)executionResult.getResult();
            this.addResultPair(this.createResultPair(executionResult));
            if (iRowCountResult.hasRowCount()) {
                return (int)iRowCountResult.getRowCount();
            }
            return 0;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_STMT_ACTION, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string, int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, n);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_STMT_ACTION, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, nArray);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_STMT_ACTION, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, stringArray);
            this.checkIfOpen();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_STMT_ACTION, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (null == this.m_metadata) {
                ExecutionResults executionResults = this.m_queryExecutor.getResults();
                ArrayList<ExecutionResult> arrayList = executionResults.getResults();
                if (arrayList.isEmpty()) {
                    return null;
                }
                if (1 != arrayList.size()) {
                    throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_NUMBER_METADATA, this.m_warningListener, new Object[0]);
                }
                ExecutionResult executionResult = arrayList.get(0);
                if (ExecutionResultType.RESULT_SET == executionResult.getType()) {
                    IResultSet iResultSet = (IResultSet)executionResult.getResult();
                    ArrayList<? extends IColumn> arrayList2 = iResultSet.getSelectColumns();
                    if (null == arrayList2) {
                        return null;
                    }
                    this.m_metadata = new SResultSetMetaData(arrayList2, this.m_logger, this.m_warningListener);
                }
            }
            return this.m_metadata;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (null == this.m_openParamMetaData) {
                this.m_openParamMetaData = new SParameterMetaData(this.m_parameterMetadata, this.m_logger, this.m_warningListener);
            }
            return this.m_openParamMetaData;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setArray(int n, Array array) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, array);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, inputStream, n2);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(n - 1);
            TypeMetadata typeMetadata = parameterMetadata.getTypeMetadata();
            if (!TypeConverter.canConvertStreamTo(-1, typeMetadata.getType())) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_SET_TYPE, this.m_warningListener, String.valueOf(parameterMetadata.getParameterNumber()));
            }
            if (null == inputStream) {
                this.setNull(n, typeMetadata.getType());
            } else {
                AsciiParameterStream asciiParameterStream = new AsciiParameterStream(inputStream, n2, parameterMetadata, typeMetadata.getType());
                this.setParameterInputStream(n, asciiParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, bigDecimal);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (null == bigDecimal) {
                this.setNull(n, 2);
            } else {
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                dataWrapper.setNumeric(bigDecimal);
                this.createAndSetParameterInputValue(n, dataWrapper);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, inputStream, n2);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(n - 1);
            TypeMetadata typeMetadata = parameterMetadata.getTypeMetadata();
            if (!TypeConverter.canConvertStreamTo(-4, typeMetadata.getType())) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_SET_TYPE, this.m_warningListener, String.valueOf(parameterMetadata.getParameterNumber()));
            }
            if (null == inputStream) {
                this.setNull(n, typeMetadata.getType());
            } else {
                BinaryParameterStream binaryParameterStream = new BinaryParameterStream(inputStream, n2, parameterMetadata, typeMetadata.getType());
                this.setParameterInputStream(n, binaryParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setBlob(int n, Blob blob) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, blob);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, bl);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setBoolean(bl);
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setByte(int n, byte by) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, by);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setTinyInt(by);
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, byArray);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            if (null == byArray) {
                dataWrapper.setNull(-3);
            } else if (byArray.length > this.m_parentConnection.m_maxVarbinarySize) {
                dataWrapper.setLongVarBinary(byArray);
            } else {
                dataWrapper.setVarBinary(byArray);
            }
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, reader, n2);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(n - 1);
            TypeMetadata typeMetadata = parameterMetadata.getTypeMetadata();
            if (!TypeConverter.canConvertStreamTo(-1, typeMetadata.getType())) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_SET_TYPE, this.m_warningListener, String.valueOf(parameterMetadata.getParameterNumber()));
            }
            if (null == reader) {
                this.setNull(n, typeMetadata.getType());
            } else {
                CharacterParameterStream characterParameterStream = new CharacterParameterStream(reader, n2, parameterMetadata, (int)typeMetadata.getType());
                this.setParameterInputStream(n, characterParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setClob(int n, Clob clob) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, clob);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setDate(int n, Date date) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, date);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (null == date) {
                this.setNull(n, 91);
            } else {
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                dataWrapper.setDate(date);
                this.createAndSetParameterInputValue(n, dataWrapper);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setDate(int n, Date date, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, date, calendar);
        try {
            this.setDate(n, CalendarSetter.getDate(date, calendar));
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setDouble(int n, double d) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, d);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setDouble(d);
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setFloat(int n, float f) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, Float.valueOf(f));
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setReal(f);
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setInt(int n, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, n2);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setInteger(n2);
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setLong(int n, long l) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, l);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setBigInt(BigInteger.valueOf(l));
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setNull(int n, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, n2);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(n - 1);
            if (Nullable.NULLABLE != parameterMetadata.getNullable()) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.PARAM_NOT_NULLABLE, this.m_warningListener, String.valueOf(n));
            }
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            if (0 == n2) {
                dataWrapper.setNull(parameterMetadata.getTypeMetadata().getType());
            } else {
                dataWrapper.setNull(n2);
            }
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setNull(int n, int n2, String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, n2, string);
        this.setNull(n, n2);
    }

    @Override
    public synchronized void setObject(int n, Object object) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, object);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(n - 1);
            short s = parameterMetadata.getTypeMetadata().getType();
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            if (null == object) {
                dataWrapper.setNull(s);
            } else {
                try {
                    DataWrapper dataWrapper2 = new DataWrapper();
                    dataWrapper2.setData(TypeConverter.getSqlType(object), object);
                    dataWrapper = TypeConverter.toType(dataWrapper2, parameterMetadata.getTypeMetadata(), (IWarningListener)this.m_warningListener);
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.PARAM_OBJECT_MISMATCH, this.m_warningListener, String.valueOf(object));
                }
            }
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setObject(int n, Object object, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, object, n2);
        this.setObject(n, object, n2, 0);
    }

    @Override
    public synchronized void setObject(int n, Object object, int n2, int n3) throws SQLException {
        block11: {
            try {
                LogUtilities.logFunctionEntrance(this.m_logger, n, object, n2, n3);
                this.checkIfOpen();
                this.checkValidParameterIndex(n);
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                if (null == object) {
                    this.setNull(n, n2);
                    break block11;
                }
                if (0 == n2) {
                    ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(n - 1);
                    this.setNull(n, parameterMetadata.getTypeMetadata().getType());
                    break block11;
                }
                try {
                    ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(n - 1);
                    int n4 = TypeConverter.getSqlType(object);
                    DataWrapper dataWrapper2 = new DataWrapper();
                    dataWrapper2.setData(n4, object);
                    if (n2 != n4) {
                        dataWrapper2 = TypeConverter.toType(dataWrapper2, n2, (IWarningListener)this.m_warningListener);
                    }
                    switch (n2) {
                        case 2: {
                            dataWrapper2.setNumeric(dataWrapper2.getNumeric().setScale(n3, 4));
                            break;
                        }
                        case 3: {
                            dataWrapper2.setDecimal(dataWrapper2.getDecimal().setScale(n3, 4));
                            break;
                        }
                    }
                    dataWrapper = TypeConverter.toType(dataWrapper2, parameterMetadata.getTypeMetadata(), (IWarningListener)this.m_warningListener);
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.PARAM_OBJECT_MISMATCH, this.m_warningListener, String.valueOf(object));
                }
                this.createAndSetParameterInputValue(n, dataWrapper);
            }
            catch (Exception exception) {
                throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
            }
        }
    }

    @Override
    public synchronized void setRef(int n, Ref ref) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, ref);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setShort(int n, short s) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, s);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setSmallInt(s);
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setString(int n, String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, string);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            if (null == string) {
                dataWrapper.setNull(12);
            } else if (string.length() > this.m_parentConnection.m_maxVarcharSize) {
                dataWrapper.setLongVarChar(string);
            } else {
                dataWrapper.setVarChar(string);
            }
            this.createAndSetParameterInputValue(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setTime(int n, Time time) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, time);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (null == time) {
                this.setNull(n, 92);
            } else {
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                dataWrapper.setTime(time);
                this.createAndSetParameterInputValue(n, dataWrapper);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setTime(int n, Time time, Calendar calendar) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, time);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (null == time) {
                this.setNull(n, 92);
            } else {
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                dataWrapper.setTime(new TimeTz(time, calendar));
                this.createAndSetParameterInputValue(n, dataWrapper);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, timestamp);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (null == timestamp) {
                this.setNull(n, 93);
            } else {
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                dataWrapper.setTimestamp(timestamp);
                this.createAndSetParameterInputValue(n, dataWrapper);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, timestamp, calendar);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (null == timestamp) {
                this.setNull(n, 93);
            } else {
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                dataWrapper.setTimestamp(new TimestampTz(timestamp, calendar));
                this.createAndSetParameterInputValue(n, dataWrapper);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, inputStream, n2);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(n - 1);
            TypeMetadata typeMetadata = parameterMetadata.getTypeMetadata();
            if (!TypeConverter.canConvertStreamTo(-1, typeMetadata.getType())) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_SET_TYPE, this.m_warningListener, String.valueOf(parameterMetadata.getParameterNumber()));
            }
            if (null == inputStream) {
                this.setNull(n, typeMetadata.getType());
            } else {
                UnicodeParameterStream unicodeParameterStream = new UnicodeParameterStream(inputStream, n2, parameterMetadata, typeMetadata.getType());
                this.setParameterInputStream(n, unicodeParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setURL(int n, URL uRL) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, uRL);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.m_warningListener, new Object[0]);
    }

    @Override
    void closeIfPrepared() throws SQLException {
        this.close();
    }

    protected boolean allInputParameterValuesPopulated() {
        return this.m_parameterInputStreams.size() + this.m_parameterInputValues.size() == this.m_numParameters;
    }

    protected void checkParameters(List<ParameterMetadata> list) throws SQLException {
        for (int i = 0; i < list.size(); ++i) {
            if (ParameterType.INPUT == this.m_parameterTypes.get(i)) continue;
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_INPUT_ONLY, this.m_warningListener, String.valueOf(list.get(i).getParameterNumber()));
        }
    }

    protected void checkValidParameterIndex(int n) throws SQLException {
        if (1 > n || this.m_numParameters < n) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_INDEX, this.m_warningListener, String.valueOf(n));
        }
    }

    protected void clearParameters(Map<Integer, ParameterInputValue> map, Map<Integer, AbstractParameterStream> map2) {
        map.clear();
        for (AbstractParameterStream abstractParameterStream : map2.values()) {
            if (null == abstractParameterStream) continue;
            abstractParameterStream.close();
        }
        map2.clear();
    }

    protected ExecutionResults executeWithParams(ArrayList<ParameterMetadata> arrayList, ArrayList<ArrayList<ParameterInputValue>> arrayList2, SStatement.ThrowCondition throwCondition) throws SQLException {
        try {
            this.checkCondition(this.m_preparedSql, throwCondition);
            ExecutionContexts executionContexts = new ExecutionContexts(arrayList, arrayList2);
            this.m_warningListener.setCurrentFunction(FunctionID.STATEMENT_EXECUTE);
            this.m_queryExecutor.execute(executionContexts, this.m_warningListener);
            this.m_metadata = null;
            return this.m_queryExecutor.getResults();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener);
        }
    }

    private void createAndSetParameterInputValue(int n, DataWrapper dataWrapper) throws SQLException {
        ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(--n);
        if (ParameterType.OUTPUT == this.m_parameterTypes.get(n)) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, this.m_warningListener, String.valueOf(parameterMetadata.getParameterNumber()));
        }
        ParameterInputValue parameterInputValue = this.createParameterInputValue(dataWrapper, parameterMetadata);
        Integer n2 = n + 1;
        AbstractParameterStream abstractParameterStream = this.m_parameterInputStreams.get(n2);
        if (null != abstractParameterStream) {
            abstractParameterStream.close();
            this.m_parameterInputStreams.remove(n2);
        }
        this.m_parameterInputValues.put(n2, parameterInputValue);
    }

    private ParameterInputValue createParameterInputValue(DataWrapper dataWrapper, ParameterMetadata parameterMetadata) throws SQLException {
        assert (null != dataWrapper);
        assert (null != parameterMetadata);
        try {
            TypeMetadata typeMetadata = parameterMetadata.getTypeMetadata();
            if (parameterMetadata.shouldConvertInputToString()) {
                dataWrapper.setVarChar(TypeConverter.toString(dataWrapper, typeMetadata));
            } else if (dataWrapper.getType() != typeMetadata.getType()) {
                dataWrapper = TypeConverter.toType(dataWrapper, typeMetadata, (IWarningListener)this.m_warningListener);
            }
            return new ParameterInputValue(parameterMetadata, dataWrapper);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.CONVERSION_ERROR_INPUT_PARAM, this.m_warningListener, String.valueOf(parameterMetadata.getParameterNumber()));
        }
    }

    private ArrayList<ArrayList<ParameterInputValue>> getBatchInputParameterValues() {
        int n = this.m_batchParameterInputValues.size();
        ArrayList<ArrayList<ParameterInputValue>> arrayList = new ArrayList<ArrayList<ParameterInputValue>>(n);
        for (int i = 0; i < n; ++i) {
            ArrayList<ParameterInputValue> arrayList2 = this.getInputParameterValues(this.m_batchParameterInputValues.get(i), this.m_batchParameterInputStreams.get(i));
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    private ArrayList<ArrayList<ParameterInputValue>> getInputParameterValues() {
        ArrayList<ParameterInputValue> arrayList = this.getInputParameterValues(this.m_parameterInputValues, this.m_parameterInputStreams);
        ArrayList<ArrayList<ParameterInputValue>> arrayList2 = new ArrayList<ArrayList<ParameterInputValue>>(1);
        arrayList2.add(arrayList);
        return arrayList2;
    }

    private ArrayList<ParameterInputValue> getInputParameterValues(Map<Integer, ParameterInputValue> map, Map<Integer, AbstractParameterStream> map2) {
        ArrayList<ParameterInputValue> arrayList = new ArrayList<ParameterInputValue>(this.m_numParameters);
        for (int i = 0; i < this.m_numParameters; ++i) {
            if (ParameterType.OUTPUT == this.m_parameterTypes.get(i)) continue;
            Integer n = i + 1;
            if (map.containsKey(n)) {
                arrayList.add(map.get(n));
                continue;
            }
            AbstractParameterStream abstractParameterStream = map2.get(n);
            arrayList.add(new ParameterInputValue(abstractParameterStream.getMetadata(), true, null));
        }
        return arrayList;
    }

    private void pushBatchParameterStreams() throws SQLException {
        try {
            int n = this.m_batchParameterInputStreams.size();
            for (int i = 0; i < n; ++i) {
                this.pushParameterStreams(i + 1, this.m_batchParameterInputStreams.get(i));
            }
            this.m_queryExecutor.finalizePushedParamData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener);
        }
    }

    private void pushParameterStreams() throws SQLException {
        try {
            this.pushParameterStreams(1, this.m_parameterInputStreams);
            this.m_queryExecutor.finalizePushedParamData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener);
        }
    }

    private void pushParameterStreams(int n, Map<Integer, AbstractParameterStream> map) throws ErrorException, IOException, BadDefaultParamException {
        for (AbstractParameterStream abstractParameterStream : map.values()) {
            while (abstractParameterStream.hasMoreData()) {
                this.m_queryExecutor.pushParamData(n, abstractParameterStream.getNextValue());
            }
        }
    }

    private void setParameterInputStream(int n, AbstractParameterStream abstractParameterStream) throws SQLException {
        ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(n - 1);
        if (ParameterType.OUTPUT == parameterMetadata.getParameterType()) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_SET_TYPE, this.m_warningListener, String.valueOf(n));
        }
        this.m_parameterInputValues.remove(n);
        AbstractParameterStream abstractParameterStream2 = this.m_parameterInputStreams.get(n);
        if (null != abstractParameterStream2) {
            abstractParameterStream2.close();
        }
        this.m_parameterInputStreams.put(n, abstractParameterStream);
    }
}

