/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IDriver;
import com.vertica.dsi.core.interfaces.IEnvironment;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.core.utilities.PropertyUtilities;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.dataengine.interfaces.IDataEngine;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.MetadataSourceID;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageBuilder;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.SConnection;
import com.vertica.jdbc.SMetaDataProxy;
import com.vertica.jdbc.SWarningListener;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ErrorException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDatabaseMetaData
implements DatabaseMetaData {
    private static final String FUNCTION_LIST_SEPARATOR = ",";
    static final Map<Long, String> m_timeFunctionNameMap = new LinkedHashMap<Long, String>(){
        private static final long serialVersionUID = 8008545354937157107L;
        {
            this.put(0L, null);
            this.put(2L, "CURDATE");
            this.put(131072L, "CURRENT_DATE");
            this.put(262144L, "CURRENT_TIME");
            this.put(524288L, "CURRENT_TIMESTAMP");
            this.put(512L, "CURTIME");
            this.put(32768L, "DAYNAME");
            this.put(4L, "DAYOFMONTH");
            this.put(8L, "DAYOFWEEK");
            this.put(16L, "DAYOFYEAR");
            this.put(0x100000L, "EXTRACT");
            this.put(1024L, "HOUR");
            this.put(2048L, "MINUTE");
            this.put(32L, "MONTH");
            this.put(65536L, "MONTHNAME");
            this.put(1L, "NOW");
            this.put(64L, "QUARTER");
            this.put(4096L, "SECOND");
            this.put(8192L, "TIMESTAMPADD");
            this.put(16384L, "TIMESTAMPDIFF");
            this.put(128L, "WEEK");
            this.put(256L, "YEAR");
        }
    };
    static final Map<Long, String> m_systemFunctionNameMap = new LinkedHashMap<Long, String>(){
        private static final long serialVersionUID = -1124807681731600000L;
        {
            this.put(0L, null);
            this.put(2L, "DATABASE");
            this.put(4L, "IFNULL");
            this.put(1L, "USER");
        }
    };
    static final Map<Long, String> m_numericFunctionNameMap = new LinkedHashMap<Long, String>(){
        private static final long serialVersionUID = -3392302998382835758L;
        {
            this.put(0L, null);
            this.put(1L, "ABS");
            this.put(2L, "ACOS");
            this.put(4L, "ASIN");
            this.put(8L, "ATAN");
            this.put(16L, "ATAN2");
            this.put(32L, "CEILING");
            this.put(64L, "COS");
            this.put(128L, "COT");
            this.put(262144L, "DEGREES");
            this.put(256L, "EXP");
            this.put(512L, "FLOOR");
            this.put(1024L, "LOG");
            this.put(524288L, "LOG10");
            this.put(2048L, "MOD");
            this.put(65536L, "PI");
            this.put(0x100000L, "POWER");
            this.put(0x200000L, "RADIANS");
            this.put(131072L, "RAND");
            this.put(0x400000L, "ROUND");
            this.put(4096L, "SIGN");
            this.put(8192L, "SIN");
            this.put(16384L, "SQRT");
            this.put(32768L, "TAN");
            this.put(0x800000L, "TRUNCATE");
        }
    };
    static final Map<Long, String> m_stringFunctionNameMap = new LinkedHashMap<Long, String>(){
        private static final long serialVersionUID = -962673552006335376L;
        {
            this.put(0L, null);
            this.put(8192L, "ASCII");
            this.put(524288L, "BIT_LENGTH");
            this.put(0x100000L, "CHAR");
            this.put(0x100000L, "CHAR_LENGTH");
            this.put(1L, "CONCAT");
            this.put(32768L, "DIFFERENCE");
            this.put(2L, "INSERT");
            this.put(64L, "LCASE");
            this.put(4L, "LEFT");
            this.put(16L, "LENGTH");
            this.put(32L, "LOCATE");
            this.put(65536L, "LOCATE2");
            this.put(8L, "LTRIM");
            this.put(0x400000L, "OCTET_LENGTH");
            this.put(0x800000L, "POSITION");
            this.put(128L, "REPEAT");
            this.put(256L, "REPLACE");
            this.put(512L, "RIGHT");
            this.put(1024L, "RTRIM");
            this.put(131072L, "SOUNDEX");
            this.put(262144L, "SPACE");
            this.put(2048L, "SUBSTRING");
            this.put(4096L, "UCASE");
        }
    };
    private static final int SQL_ALL_TYPES = 0;
    private static final int SQL_NO_NULLS = 0;
    private static final int SQL_NULLABLE = 1;
    private static final int SQL_BEST_ROWID = 1;
    private static final int SQL_ROWVER = 2;
    private static final int SQL_INDEX_UNIQUE = 0;
    private static final int SQL_INDEX_ALL = 1;
    private static final int SQL_QUICK = 0;
    private static final int SQL_ENSURE = 1;
    protected static final String RETURN_YES = "Y";
    protected static final String RETURN_NO = "N";
    private static final String VERSION_SEPARATOR = ".";
    private static final int JDBC_MAJOR_VERSION = 3;
    private static final int JDBC_MINOR_VERSION = 0;
    private ArrayList<ResultSet> m_resultSets = new ArrayList();
    private IDataEngine m_dataEngine = null;
    private IStatement m_parentStatement = null;
    private SConnection m_parentConnection = null;
    private SWarningListener m_warningListener = null;
    private ILogger m_logger = null;

    protected SDatabaseMetaData(SConnection sConnection, ILogger iLogger) throws SQLException {
        try {
            this.m_logger = iLogger;
            LogUtilities.logFunctionEntrance(this.m_logger, sConnection, iLogger);
            this.m_parentConnection = sConnection;
            this.m_parentStatement = sConnection.getConnection().createStatement();
            this.m_warningListener = new SWarningListener(sConnection.getDSIConnection().getMessageSource(), null);
            this.m_parentStatement.registerWarningListener(this.m_warningListener);
            this.m_dataEngine = this.m_parentStatement.createDataEngine();
        }
        catch (Exception exception) {
            if (null == this.m_warningListener) {
                throw ExceptionConverter.toSQLException(exception, this.m_parentConnection.getWarningListener(), this.m_logger);
            }
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(1);
            return variant.getString().equals(RETURN_YES);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(2);
            return variant.getString().equals(RETURN_YES);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(136);
            return 3 == n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(136);
            return 4 == n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean deletesAreDetected(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(1002);
            switch (n) {
                case 1003: {
                    return 0L != (1L & l);
                }
                case 1004: {
                    return 0L != (8L & l);
                }
                case 1005: {
                    return 0L != (0x40L & l);
                }
            }
            return false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(80);
            return variant.getString().equals(RETURN_YES);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3, string4);
            this.checkParentConnection();
            return this.createNullMetaDataResult(MetadataSourceID.ATTRIBUTES);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3, n, bl);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(1));
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    arrayList.add(String.valueOf(n));
                    break;
                }
                default: {
                    throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.UNKNOWN_SCOPE, this.m_parentConnection.getWarningListener(), String.valueOf(n));
                }
            }
            if (bl) {
                arrayList.add(String.valueOf(1));
            } else {
                arrayList.add(String.valueOf(0));
            }
            return this.createMetaDataResult(MetadataSourceID.SPECIAL_COLUMNS, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(null);
            arrayList.add(null);
            arrayList.add(null);
            arrayList.add(null);
            return this.createMetaDataResult(MetadataSourceID.CATALOG_ONLY, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(10);
            return variant.getString();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(11);
            return variant.getString();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3, string4);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(string4);
            return this.createMetaDataResult(MetadataSourceID.COLUMN_PRIVILEGES, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3, string4);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(string4);
            return this.createMetaDataResult(MetadataSourceID.COLUMNS, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.m_parentConnection;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3, string4, string5, string6);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(string4);
            arrayList.add(string5);
            arrayList.add(string6);
            return this.createMetaDataResult(MetadataSourceID.FOREIGN_KEYS, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(42);
            if (null == variant.getString()) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_VERSION, this.m_parentConnection.getWarningListener(), variant.getString());
            }
            StringTokenizer stringTokenizer = new StringTokenizer(variant.getString(), VERSION_SEPARATOR);
            String string = stringTokenizer.nextToken();
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(42);
            if (null == variant.getString()) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_VERSION, this.m_parentConnection.getWarningListener(), variant.getString());
            }
            StringTokenizer stringTokenizer = new StringTokenizer(variant.getString(), VERSION_SEPARATOR);
            stringTokenizer.nextToken();
            String string = stringTokenizer.nextToken();
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(41);
            return variant.getString();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(42);
            return variant.getString();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(45);
            if (0L == l) {
                return 0;
            }
            if (2L == l) {
                return 2;
            }
            if (1L == l) {
                return 1;
            }
            if (4L == l) {
                return 4;
            }
            if (8L == l) {
                return 8;
            }
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.UNKNOWN_ISOLATION, this.m_parentConnection.getWarningListener(), String.valueOf(l));
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getDriverMajorVersion() {
        int n = 1;
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getDriverPropertyVariant(5);
            if (null == variant.getString()) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_VERSION, this.m_parentConnection.getWarningListener(), variant.getString());
            }
            StringTokenizer stringTokenizer = new StringTokenizer(variant.getString(), VERSION_SEPARATOR);
            String string = stringTokenizer.nextToken();
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
        return n;
    }

    @Override
    public int getDriverMinorVersion() {
        int n = 0;
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getDriverPropertyVariant(5);
            if (null == variant.getString()) {
                throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.INVALID_VERSION, this.m_parentConnection.getWarningListener(), variant.getString());
            }
            StringTokenizer stringTokenizer = new StringTokenizer(variant.getString(), VERSION_SEPARATOR);
            stringTokenizer.nextToken();
            String string = stringTokenizer.nextToken();
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
        return n;
    }

    @Override
    public String getDriverName() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getDriverPropertyVariant(3);
            return variant.getString();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getDriverVersion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getDriverPropertyVariant(5);
            return variant.getString();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(null);
            arrayList.add(null);
            arrayList.add(null);
            return this.createMetaDataResult(MetadataSourceID.FOREIGN_KEYS, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(102);
            return variant.getString();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(58);
            return variant.getString();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(null);
            arrayList.add(null);
            arrayList.add(null);
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            return this.createMetaDataResult(MetadataSourceID.FOREIGN_KEYS, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3, bl, bl2);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            if (bl) {
                arrayList.add(String.valueOf(0));
            } else {
                arrayList.add(String.valueOf(1));
            }
            if (bl2) {
                arrayList.add(String.valueOf(0));
            } else {
                arrayList.add(String.valueOf(1));
            }
            return this.createMetaDataResult(MetadataSourceID.STATISTICS, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return 3;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return 0;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(65);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(66);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(67);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(68);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(69);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(70);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(71);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(72);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(73);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxConnections() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getEnvironmentPropertyVariant(2);
            return variant.getInt();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(75);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(77);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(78);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(79);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(81);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(82);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxStatements() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(74);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(83);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(84);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(85);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(90);
            return this.createListFromMap(m_numericFunctionNameMap, l);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            return this.createMetaDataResult(MetadataSourceID.PRIMARY_KEYS, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3, string4);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(string4);
            return this.createMetaDataResult(MetadataSourceID.PROCEDURE_COLUMNS, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            return this.createMetaDataResult(MetadataSourceID.PROCEDURES, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(96);
            return variant.getString();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(37);
            if (1L == l || 0L == l) {
                return 2;
            }
            if (2L == l) {
                return 1;
            }
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.UNKNOWN_HOLDABILITY, this.m_parentConnection.getWarningListener(), String.valueOf(l));
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(null);
            arrayList.add(null);
            arrayList.add(null);
            arrayList.add(null);
            try {
                return this.createMetaDataResult(MetadataSourceID.CATALOG_SCHEMA_ONLY, arrayList);
            }
            catch (Exception exception) {
                return this.createMetaDataResult(MetadataSourceID.SCHEMA_ONLY, arrayList);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(null);
            arrayList.add(null);
            try {
                return this.createMetaDataResult(MetadataSourceID.CATALOG_SCHEMA_ONLY, arrayList);
            }
            catch (Exception exception) {
                return this.createMetaDataResult(MetadataSourceID.SCHEMA_ONLY, arrayList);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(99);
            return variant.getString();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(151);
            return variant.getString();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(62);
            return variant.getString();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getSQLStateType() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getDriverPropertyVariant(13);
            long l = variant.getLong();
            if (2L == l) {
                return 2;
            }
            if (1L == l) {
                return 1;
            }
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.UNKNOWN_SQLSTATE_TYPE, this.m_parentConnection.getWarningListener(), String.valueOf(l));
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getStringFunctions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(104);
            return this.createListFromMap(m_stringFunctionNameMap, l);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3);
            this.checkParentConnection();
            return this.createNullMetaDataResult(MetadataSourceID.SUPERTABLES);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3);
            this.checkParentConnection();
            return this.createNullMetaDataResult(MetadataSourceID.SUPERTYPES);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(131);
            return this.createListFromMap(m_systemFunctionNameMap, l);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            return this.createMetaDataResult(MetadataSourceID.TABLE_PRIVILEGES, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3, stringArray);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            if (null != stringArray) {
                if (stringArray.length > 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringBuffer.append(FUNCTION_LIST_SEPARATOR);
                        stringBuffer.append(stringArray[i]);
                    }
                    arrayList.add(stringBuffer.substring(1));
                } else {
                    arrayList.add("");
                }
            } else {
                arrayList.add(null);
            }
            return this.createMetaDataResult(MetadataSourceID.TABLES, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(null);
            arrayList.add(null);
            arrayList.add(null);
            arrayList.add(null);
            return this.createMetaDataResult(MetadataSourceID.TABLETYPE_ONLY, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(135);
            return this.createListFromMap(m_timeFunctionNameMap, l);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(0));
            return this.createMetaDataResult(MetadataSourceID.TYPE_INFO, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3, nArray);
            this.checkParentConnection();
            return this.createNullMetaDataResult(MetadataSourceID.UDT);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getURL() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.m_parentConnection.getURL();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getUserName() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(139);
            return variant.getString();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, string2, string3);
            this.checkParentConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(2));
            arrayList.add(string);
            arrayList.add(string2);
            arrayList.add(string3);
            arrayList.add(String.valueOf(0));
            arrayList.add(String.valueOf(1));
            return this.createMetaDataResult(MetadataSourceID.SPECIAL_COLUMNS, arrayList);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean insertsAreDetected(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(1002);
            switch (n) {
                case 1003: {
                    return 0L != (2L & l);
                }
                case 1004: {
                    return 0L != (0x10L & l);
                }
                case 1005: {
                    return 0L != (0x80L & l);
                }
            }
            return false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(8);
            return 1L == (long)n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(40);
            return variant.getString().equals(RETURN_YES);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(15);
            return 0L == (long)n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(89);
            return 4L == (long)n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(89);
            return 2L == (long)n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(89);
            return 0L == (long)n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(89);
            return 1L == (long)n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean othersDeletesAreVisible(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkParentConnection();
            return false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean othersInsertsAreVisible(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkParentConnection();
            return false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkParentConnection();
            return false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean ownDeletesAreVisible(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkParentConnection();
            return false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean ownInsertsAreVisible(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkParentConnection();
            return false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkParentConnection();
            return false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(57);
            return 2 == n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(98);
            return 2 == n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(57);
            return 4 == n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(98);
            return 4 == n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(57);
            return 1 == n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(98);
            return 1 == n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(6);
            return (0x40L & l) != 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(6);
            return (0x200L & l) != 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(103);
            return 1L <= (long)n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(103);
            return 8L <= (long)n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(103);
            return 4L <= (long)n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getDriverPropertyVariant(1002);
            return 1 == variant.getInt();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(12);
            return (1L & l) != 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(12);
            return (8L & l) != 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(12);
            return (0x10L & l) != 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(12);
            return (2L & l) != 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(12);
            return (4L & l) != 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(14);
            return variant.getString().equals(RETURN_YES);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(27);
            return (1L & l) != 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsConvert(int n, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, n2);
            this.checkParentConnection();
            int n3 = 0;
            long l = 0L;
            switch (n) {
                case -5: {
                    n3 = 106;
                    break;
                }
                case -2: {
                    n3 = 107;
                    break;
                }
                case -7: 
                case 16: {
                    n3 = 108;
                    break;
                }
                case 1: {
                    n3 = 109;
                    break;
                }
                case 91: {
                    n3 = 111;
                    break;
                }
                case 3: {
                    n3 = 112;
                    break;
                }
                case 8: {
                    n3 = 113;
                    break;
                }
                case 6: {
                    n3 = 114;
                    break;
                }
                case 4: {
                    n3 = 115;
                    break;
                }
                case -4: {
                    n3 = 118;
                    break;
                }
                case -1: {
                    n3 = 119;
                    break;
                }
                case 2: {
                    n3 = 120;
                    break;
                }
                case 7: {
                    n3 = 121;
                    break;
                }
                case 5: {
                    n3 = 122;
                    break;
                }
                case 92: {
                    n3 = 123;
                    break;
                }
                case 93: {
                    n3 = 124;
                    break;
                }
                case -6: {
                    n3 = 125;
                    break;
                }
                case -3: {
                    n3 = 126;
                    break;
                }
                case 12: {
                    n3 = 127;
                    break;
                }
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: {
                    n3 = 117;
                    break;
                }
                case 101: 
                case 102: 
                case 107: {
                    n3 = 116;
                    break;
                }
                case -8: {
                    n3 = 128;
                    break;
                }
                case -10: {
                    n3 = 129;
                    break;
                }
                case -9: {
                    n3 = 130;
                    break;
                }
                default: {
                    return false;
                }
            }
            switch (n2) {
                case -5: {
                    l = 16384L;
                    break;
                }
                case -2: {
                    l = 1024L;
                    break;
                }
                case -7: {
                    l = 4096L;
                    break;
                }
                case 1: {
                    l = 1L;
                    break;
                }
                case 91: {
                    l = 32768L;
                    break;
                }
                case 3: {
                    l = 4L;
                    break;
                }
                case 8: {
                    l = 128L;
                    break;
                }
                case 6: {
                    l = 32L;
                    break;
                }
                case 4: {
                    l = 8L;
                    break;
                }
                case -4: {
                    l = 262144L;
                    break;
                }
                case -1: {
                    l = 512L;
                    break;
                }
                case 2: {
                    l = 2L;
                    break;
                }
                case 7: {
                    l = 64L;
                    break;
                }
                case 5: {
                    l = 16L;
                    break;
                }
                case 92: {
                    l = 65536L;
                    break;
                }
                case 93: {
                    l = 131072L;
                    break;
                }
                case -6: {
                    l = 8192L;
                    break;
                }
                case -3: {
                    l = 2048L;
                    break;
                }
                case 12: {
                    l = 256L;
                    break;
                }
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: {
                    l = 0x100000L;
                    break;
                }
                case 101: 
                case 102: 
                case 107: {
                    l = 524288L;
                    break;
                }
                case -8: {
                    l = 0x200000L;
                    break;
                }
                case -10: {
                    l = 0x400000L;
                    break;
                }
                case -9: {
                    l = 0x800000L;
                    break;
                }
                default: {
                    return false;
                }
            }
            long l2 = this.getConnectionPropertyLong(n3);
            return (l & l2) != 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(91);
            return 1 <= n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(105);
            return (0x10L & l) != 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(136);
            return 2 == n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(136);
            return 1 == n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(28);
            return 1L == (long)n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(55);
            return variant.getString().equals(RETURN_YES);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(91);
            return 2 <= n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(92);
            boolean bl = (4L & l) != 0L;
            boolean bl2 = (8L & l) != 0L;
            return bl && bl2;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(56);
            return 0L != (long)n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(56);
            return 2L == (long)n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(56);
            return 3L == (long)n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(61);
            return variant.getString().equals(RETURN_YES);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(63);
            return variant.getString().equals(RETURN_YES);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(94);
            return variant.getString().equals(RETURN_YES);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(91);
            return 0 <= n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(57);
            return 3 == n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(98);
            return 3 == n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(86);
            return variant.getString().equals(RETURN_YES);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(87);
            return variant.getString().equals(RETURN_YES);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getDriverPropertyVariant(1003);
            return 1 == variant.getInt();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(88);
            return 1L == (long)n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(37);
            return 2L == (long)n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(38);
            return 2L == (long)n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(37);
            return 0L != (long)n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(38);
            return 0L != (long)n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getConnectionPropertyVariant(93);
            return variant.getString().equals(RETURN_YES);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.supportsLimitedOuterJoins();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, n2);
            this.checkParentConnection();
            if (1003 != n) {
                return false;
            }
            if (1007 == n2) {
                return true;
            }
            long l = this.getConnectionPropertyLong(1001);
            return 0L != l;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsResultSetHoldability(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkParentConnection();
            int n2 = this.getConnectionPropertyInt(37);
            boolean bl = false;
            switch (n) {
                case 1: {
                    bl = 2L == (long)n2;
                    break;
                }
                case 2: {
                    bl = 1L == (long)n2 || 0L == (long)n2;
                }
            }
            return bl;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsResultSetType(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkParentConnection();
            return 1003 == n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return PropertyUtilities.hasSavepointSupport(this.m_parentConnection.getConnection());
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(100);
            return (1L & l) != 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(100);
            return (8L & l) != 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(100);
            return (0x10L & l) != 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(100);
            return (2L & l) != 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(100);
            return (4L & l) != 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getDriverPropertyVariant(1004);
            return 1 == variant.getInt();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return PropertyUtilities.hasStoredProcedureSupport(this.m_parentConnection.getConnection());
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(105);
            return (1L & l) != 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(105);
            return (2L & l) != 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(105);
            return (4L & l) != 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(105);
            return (8L & l) != 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(28);
            return 0L != (long)n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(137);
            switch (n) {
                case 0: {
                    return 0L == l;
                }
                case 2: {
                    return (2L & l) != 0L;
                }
                case 1: {
                    return (1L & l) != 0L;
                }
                case 4: {
                    return (4L & l) != 0L;
                }
                case 8: {
                    return (8L & l) != 0L;
                }
            }
            return false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int n = this.getConnectionPropertyInt(136);
            return 0 != n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(138);
            return (1L & l) != 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(138);
            return (2L & l) != 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean updatesAreDetected(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkParentConnection();
            long l = this.getConnectionPropertyLong(1002);
            switch (n) {
                case 1003: {
                    return 0L != (4L & l);
                }
                case 1004: {
                    return 0L != (0x20L & l);
                }
                case 1005: {
                    return 0L != (0x100L & l);
                }
            }
            return false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getDriverPropertyVariant(6);
            int n = variant.getInt();
            return 1 == n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant variant = this.getDriverPropertyVariant(6);
            int n = variant.getInt();
            return 0 != n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    synchronized void closeMetaData() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_dataEngine) {
            this.m_dataEngine.close();
            try {
                this.m_parentStatement.close();
            }
            catch (ErrorException errorException) {
                LogUtilities.logError(errorException, this.m_logger);
            }
            this.m_dataEngine = null;
            this.m_parentStatement = null;
        }
        if (null != this.m_parentConnection) {
            this.m_parentConnection.removeDatabaseMetaData(this);
            this.m_parentConnection = null;
        }
        if (null != this.m_resultSets) {
            for (int i = this.m_resultSets.size() - 1; i >= 0; --i) {
                try {
                    this.m_resultSets.get(i).close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_resultSets.clear();
        }
    }

    protected void finalize() throws Throwable {
        this.closeMetaData();
    }

    protected IConnection getDSIConnection() {
        return this.m_parentConnection.getConnection();
    }

    protected IStatement getDSIStatement() {
        return this.m_parentStatement;
    }

    protected synchronized void removeResultSet(ResultSet resultSet) {
        this.m_resultSets.remove(resultSet);
    }

    private synchronized void checkParentConnection() throws SQLException {
        if (null == this.m_parentConnection) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.DBMETA_CLOSED, this.m_warningListener, new Object[0]);
        }
        if (this.m_parentConnection.isClosed()) {
            this.closeMetaData();
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.PARENT_CLOSED, this.m_warningListener, new Object[0]);
        }
    }

    private String createListFromMap(Map<Long, String> map, long l) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        for (long l2 : map.keySet()) {
            String string = map.get(l2 & l);
            if (null == string) continue;
            stringBuffer.append(FUNCTION_LIST_SEPARATOR).append(string);
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString().substring(1);
        }
        return "";
    }

    private synchronized ResultSet createMetaDataResult(MetadataSourceID metadataSourceID, ArrayList<String> arrayList) throws SQLException {
        try {
            IResultSet iResultSet = this.m_dataEngine.makeNewMetadataResult(metadataSourceID, arrayList, this.getSearchStringEscape(), this.getIdentifierQuoteString(), false);
            SMetaDataProxy sMetaDataProxy = new SMetaDataProxy(this, iResultSet, metadataSourceID, this.m_logger, this.m_parentStatement.getWarningListener());
            this.m_resultSets.add(sMetaDataProxy);
            return sMetaDataProxy;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_parentStatement.getWarningListener());
        }
    }

    private synchronized ResultSet createNullMetaDataResult(MetadataSourceID metadataSourceID) throws SQLException {
        try {
            SMetaDataProxy sMetaDataProxy = new SMetaDataProxy(this, null, metadataSourceID, this.m_logger, this.m_parentStatement.getWarningListener());
            this.m_resultSets.add(sMetaDataProxy);
            return sMetaDataProxy;
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_parentStatement.getWarningListener());
        }
    }

    private int getConnectionPropertyInt(int n) throws SQLException {
        Variant variant = this.getConnectionPropertyVariant(n);
        try {
            return variant.getInt();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_parentStatement.getWarningListener());
        }
    }

    private long getConnectionPropertyLong(int n) throws SQLException {
        Variant variant = this.getConnectionPropertyVariant(n);
        try {
            return variant.getLong();
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_parentStatement.getWarningListener());
        }
    }

    private Variant getConnectionPropertyVariant(int n) throws SQLException {
        try {
            IConnection iConnection = this.m_parentConnection.getConnection();
            return iConnection.getProperty(n);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_parentStatement.getWarningListener());
        }
    }

    private Variant getDriverPropertyVariant(int n) throws SQLException {
        try {
            IDriver iDriver = DSIDriverSingleton.getInstance();
            return iDriver.getProperty(n);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_parentStatement.getWarningListener());
        }
    }

    private Variant getEnvironmentPropertyVariant(int n) throws SQLException {
        try {
            IEnvironment iEnvironment = this.m_parentConnection.getConnection().getParentEnvironment();
            return iEnvironment.getProperty(n);
        }
        catch (Exception exception) {
            throw ExceptionConverter.toSQLException(exception, this.m_parentStatement.getWarningListener());
        }
    }
}

