/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.utilities;

import com.vertica.dsi.utilities.CalendarSetter;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class TimestampTz
extends Timestamp {
    private static final long serialVersionUID = -5521593264075626189L;
    private Calendar m_timezoneCal;

    public TimestampTz(Timestamp timestamp, Calendar calendar) {
        super(timestamp.getTime());
        this.setNanos(timestamp.getNanos());
        this.m_timezoneCal = null == calendar ? Calendar.getInstance() : calendar;
    }

    public TimestampTz(long l, Calendar calendar) {
        super(l);
        this.m_timezoneCal = null == calendar ? Calendar.getInstance() : calendar;
    }

    public TimestampTz(long l, int n, Calendar calendar) {
        super(l);
        this.setNanos(n);
        this.m_timezoneCal = null == calendar ? Calendar.getInstance() : calendar;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof TimestampTz) {
            return this.m_timezoneCal.equals(((TimestampTz)object).getTimezoneCalendar());
        }
        return false;
    }

    public synchronized Timestamp getAdjustedTimestamp() {
        return CalendarSetter.getTimestamp(this, GregorianCalendar.getInstance());
    }

    public Calendar getTimezoneCalendar() {
        return this.m_timezoneCal;
    }
}

