/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.impl;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.dataengine.filters.IFilter;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.interfaces.IMetadataSource;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.CursorType;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.MetadataColumn;
import com.vertica.dsi.dataengine.utilities.MetadataColumnFactory;
import com.vertica.dsi.dataengine.utilities.MetadataSourceID;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSIMetadataResultSet
implements IResultSet {
    private ILogger m_logger;
    private IMetadataSource m_metadataSource;
    private List<IFilter> m_filters;
    private ArrayList<MetadataColumn> m_columns;
    private IWarningListener m_warningListener = null;
    private boolean m_performFiltering = true;

    public DSIMetadataResultSet(IStatement iStatement, MetadataSourceID metadataSourceID, IMetadataSource iMetadataSource, List<IFilter> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(iStatement.getLog(), new Object[]{iStatement, metadataSourceID, iMetadataSource, list});
        this.m_logger = iStatement.getLog();
        this.m_filters = list;
        this.m_metadataSource = iMetadataSource;
        this.m_columns = MetadataColumnFactory.createMetadataColumns(iStatement, metadataSourceID);
        try {
            Variant variant = DSIDriverSingleton.getInstance().getProperty(22);
            this.m_performFiltering = 1L == variant.getLong();
        }
        catch (Exception exception) {
            LogUtilities.logError(exception, this.m_logger);
        }
    }

    @Override
    public void appendRow() throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_metadataSource) {
            this.m_metadataSource.close();
            this.m_metadataSource = null;
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_metadataSource) {
            this.m_metadataSource.closeCursor();
        }
    }

    @Override
    public void deleteRow() throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, l, l2, dataWrapper);
        if (n >= this.m_columns.size()) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), String.valueOf(n));
        }
        if (this.m_columns.get(n).isNullColumn()) {
            dataWrapper.setNull(this.m_columns.get(n).getTypeMetadata().getType());
            return false;
        }
        return this.m_metadataSource.getMetadata(this.m_columns.get(n).getColumnTag(), l, l2, dataWrapper);
    }

    @Override
    public int getFetchSize() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return 0;
    }

    @Override
    public long getRowCount() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return -1L;
    }

    @Override
    public ArrayList<? extends IColumn> getSelectColumns() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_columns;
    }

    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_metadataSource.hasMoreRows();
    }

    @Override
    public boolean hasRowCount() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return false;
    }

    @Override
    public boolean moveToNextRow() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_performFiltering) {
            return this.m_metadataSource.moveToNextRow();
        }
        while (this.m_metadataSource.moveToNextRow()) {
            if (!this.checkRow()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onFinishRowUpdate() {
    }

    @Override
    public void onStartRowUpdate() {
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }

    @Override
    public boolean rowDeleted() {
        return false;
    }

    @Override
    public boolean rowInserted() {
        return false;
    }

    @Override
    public boolean rowUpdated() {
        return false;
    }

    @Override
    public void setCursorType(CursorType cursorType) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{cursorType});
        if (CursorType.FORWARD_ONLY != cursorType) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.CURSOR_NOT_SUPPORTED.name(), String.valueOf((Object)cursorType));
        }
    }

    @Override
    public void setFetchSize(int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
    }

    @Override
    public boolean writeData(int n, DataWrapper dataWrapper, long l, boolean bl) throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    private boolean checkRow() throws ErrorException {
        DataWrapper dataWrapper = new DataWrapper();
        for (IFilter iFilter : this.m_filters) {
            this.m_metadataSource.getMetadata(iFilter.getColumnTag(), 0L, -1L, dataWrapper);
            if (iFilter.filter(dataWrapper)) continue;
            return false;
        }
        return true;
    }
}

