/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.filters;

import com.vertica.dsi.dataengine.filters.IFilter;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringPatternFilter
implements IFilter {
    private static final Pattern REGEX_SPECIAL_CHARS = Pattern.compile("([\\\\*+\\[\\](){}\\$.?\\^|])");
    private MetadataSourceColumnTag m_columnTag;
    private Pattern m_regEx = null;
    private String m_valueAsRegexStr = null;
    boolean m_hasPatternFilter = false;

    public StringPatternFilter(MetadataSourceColumnTag metadataSourceColumnTag, String string, String string2) {
        this.m_columnTag = metadataSourceColumnTag;
        if (null != string) {
            this.m_valueAsRegexStr = this.convertToRegexString(string, string2);
        }
    }

    public boolean filter(DataWrapper dataWrapper) {
        if (null == this.m_valueAsRegexStr) {
            return true;
        }
        if (dataWrapper.isNull()) {
            return false;
        }
        if (null == this.m_regEx) {
            this.m_regEx = Pattern.compile(this.m_valueAsRegexStr);
        }
        try {
            switch (dataWrapper.getType()) {
                case 1: {
                    return this.m_regEx.matcher(dataWrapper.getChar()).matches();
                }
                case 12: {
                    return this.m_regEx.matcher(dataWrapper.getVarChar()).matches();
                }
                case -1: {
                    return this.m_regEx.matcher(dataWrapper.getLongVarChar()).matches();
                }
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            // empty catch block
        }
        assert (false);
        return false;
    }

    public MetadataSourceColumnTag getColumnTag() {
        return this.m_columnTag;
    }

    public boolean hasPatternFilter() {
        return this.m_hasPatternFilter;
    }

    private String convertToRegexString(String string, String string2) {
        String string3 = this.escapeRegexSpecialChars(string);
        string3 = string.replace('_', '.');
        this.m_hasPatternFilter = !(string3 = string3.replace("%", "(.)*")).equals(string);
        string3 = string3.replace(string2 + ".", "_");
        string3 = string3.replace(string2 + "(.)*", "%");
        string3 = "\\A" + string3 + "\\z";
        return string3;
    }

    private String escapeRegexSpecialChars(String string) {
        Matcher matcher = REGEX_SPECIAL_CHARS.matcher(string);
        return matcher.replaceAll("\\\\$1");
    }
}

