/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.core.utilities;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.exceptions.BadAttrValException;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.Warning;
import com.vertica.support.exceptions.ErrorException;

public class PropertyUtilities {
    public static boolean hasCatalogSupport(IConnection iConnection) {
        assert (null != iConnection);
        try {
            if (0 == iConnection.getProperty(9).getString().length()) {
                return false;
            }
            if (0 == iConnection.getProperty(11).getString().length()) {
                return false;
            }
            return 0L != iConnection.getProperty(12).getLong();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean hasSavepointSupport(IConnection iConnection) {
        assert (null != iConnection);
        try {
            Variant variant = iConnection.getProperty(1000);
            return 1 == variant.getShort();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean hasSchemaSupport(IConnection iConnection) {
        assert (null != iConnection);
        try {
            if (0 == iConnection.getProperty(99).getString().length()) {
                return false;
            }
            return 0L != iConnection.getProperty(100).getLong();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean hasStoredProcedureSupport(IConnection iConnection) {
        assert (null != iConnection);
        try {
            if (0 == iConnection.getProperty(96).getString().length()) {
                return false;
            }
            return "Y".equals(iConnection.getProperty(97).getString());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isReadOnly(IConnection iConnection) {
        assert (null != iConnection);
        try {
            long l = iConnection.getProperty(16).getLong();
            if (1L != l) {
                return false;
            }
            return "Y".equals(iConnection.getProperty(40).getString());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void setCatalogSupport(IConnection iConnection, boolean bl) throws ErrorException {
        assert (null != iConnection);
        IWarningListener iWarningListener = iConnection.getWarningListener();
        if (null == iWarningListener) {
            iWarningListener = iConnection.getParentEnvironment().getWarningListener();
        }
        try {
            if (bl) {
                iConnection.setProperty(9, new Variant(0, "Y"));
                iConnection.setProperty(11, new Variant(0, "catalog"));
                iConnection.setProperty(12, new Variant(3, 31L));
            } else {
                iConnection.setProperty(9, new Variant(0, "N"));
                iConnection.setProperty(11, new Variant(0, ""));
                iConnection.setProperty(12, new Variant(3, 0L));
            }
        }
        catch (BadAttrValException badAttrValException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.BAD_ATTR_VAL.name(), badAttrValException);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), numericOverflowException);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), incorrectTypeException);
        }
        finally {
            PropertyUtilities.logWarnings(iConnection, iWarningListener);
        }
    }

    public static void setReadOnly(IConnection iConnection, boolean bl) throws ErrorException {
        assert (null != iConnection);
        IWarningListener iWarningListener = iConnection.getWarningListener();
        if (null == iWarningListener) {
            iWarningListener = iConnection.getParentEnvironment().getWarningListener();
        }
        try {
            if (bl) {
                iConnection.setProperty(16, new Variant(3, 1L));
                iConnection.setProperty(40, new Variant(0, "Y"));
            } else {
                iConnection.setProperty(16, new Variant(3, 0L));
                iConnection.setProperty(40, new Variant(0, "N"));
            }
        }
        catch (BadAttrValException badAttrValException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.BAD_ATTR_VAL.name(), badAttrValException);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), numericOverflowException);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), incorrectTypeException);
        }
        finally {
            PropertyUtilities.logWarnings(iConnection, iWarningListener);
        }
    }

    public static void setSavepointSupport(IConnection iConnection, boolean bl) throws ErrorException {
        assert (null != iConnection);
        IWarningListener iWarningListener = iConnection.getWarningListener();
        if (null == iWarningListener) {
            iWarningListener = iConnection.getParentEnvironment().getWarningListener();
        }
        try {
            if (bl) {
                iConnection.setProperty(1000, new Variant(5, (short)1));
            } else {
                iConnection.setProperty(1000, new Variant(5, (short)0));
            }
        }
        catch (BadAttrValException badAttrValException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.BAD_ATTR_VAL.name(), badAttrValException);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), numericOverflowException);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), incorrectTypeException);
        }
        finally {
            PropertyUtilities.logWarnings(iConnection, iWarningListener);
        }
    }

    public static void setSchemaSupport(IConnection iConnection, boolean bl) throws ErrorException {
        assert (null != iConnection);
        IWarningListener iWarningListener = iConnection.getWarningListener();
        if (null == iWarningListener) {
            iWarningListener = iConnection.getParentEnvironment().getWarningListener();
        }
        try {
            if (bl) {
                iConnection.setProperty(99, new Variant(0, "schema"));
                iConnection.setProperty(100, new Variant(3, 31L));
            } else {
                iConnection.setProperty(99, new Variant(0, ""));
                iConnection.setProperty(100, new Variant(3, 0L));
            }
        }
        catch (BadAttrValException badAttrValException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.BAD_ATTR_VAL.name(), badAttrValException);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), numericOverflowException);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), incorrectTypeException);
        }
        finally {
            PropertyUtilities.logWarnings(iConnection, iWarningListener);
        }
    }

    public static void setStoredProcedureSupport(IConnection iConnection, boolean bl) throws ErrorException {
        assert (null != iConnection);
        IWarningListener iWarningListener = iConnection.getWarningListener();
        if (null == iWarningListener) {
            iWarningListener = iConnection.getParentEnvironment().getWarningListener();
        }
        try {
            if (bl) {
                iConnection.setProperty(96, new Variant(0, "procedure"));
                iConnection.setProperty(97, new Variant(0, "Y"));
            } else {
                iConnection.setProperty(96, new Variant(0, ""));
                iConnection.setProperty(97, new Variant(0, "N"));
            }
        }
        catch (BadAttrValException badAttrValException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.BAD_ATTR_VAL.name(), badAttrValException);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name(), numericOverflowException);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name(), incorrectTypeException);
        }
        finally {
            PropertyUtilities.logWarnings(iConnection, iWarningListener);
        }
    }

    private static void logWarnings(IConnection iConnection, IWarningListener iWarningListener) {
        for (Warning warning : iWarningListener.getWarnings()) {
            LogUtilities.logWarning(warning.getMessage(), iConnection.getConnectionLog());
        }
    }
}

