/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.IOException;
import org.apache.jute.BinaryInputArchive;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BufferSizeTest
extends ClientBase {
    public static final int TEST_MAXBUFFER = 100;
    private static final File TEST_DATA = new File(System.getProperty("test.data.dir", "build/test/data"), "buffersize");
    private ZooKeeper zk;

    @Before
    public void setMaxBuffer() throws IOException, InterruptedException {
        System.setProperty("jute.maxbuffer", "100");
        Assert.assertEquals((String)"Can't set jute.maxbuffer!", (long)100L, (long)BinaryInputArchive.maxBuffer);
        this.zk = this.createClient();
    }

    @Test
    public void testCreatesReqs() throws Exception {
        this.testRequests(new ClientOp(){

            public void execute(byte[] data) throws Exception {
                BufferSizeTest.this.zk.create("/create_test", data, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            }
        });
    }

    @Test
    public void testSetReqs() throws Exception {
        String path = "/set_test";
        this.zk.create("/set_test", new byte[1], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.testRequests(new ClientOp(){

            public void execute(byte[] data) throws Exception {
                BufferSizeTest.this.zk.setData("/set_test", data, -1);
            }
        });
    }

    private void testRequests(ClientOp clientOp) throws Exception {
        clientOp.execute(new byte[40]);
        try {
            clientOp.execute(new byte[100]);
            Assert.fail((String)"Request exceeding jute.maxbuffer succeeded!");
        }
        catch (KeeperException.ConnectionLossException connectionLossException) {
            // empty catch block
        }
        try {
            clientOp.execute(new byte[110]);
            Assert.fail((String)"Request exceeding jute.maxbuffer succeeded!");
        }
        catch (KeeperException.ConnectionLossException connectionLossException) {
            // empty catch block
        }
    }

    @Test
    public void testStartup() throws Exception {
        String path = "/test_node";
        this.zk.create("/test_node", new byte[40], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.setData("/test_node", new byte[50], -1);
        this.stopServer();
        this.startServer();
    }

    @Test
    public void testStartupFailureCreate() throws Exception {
        this.testStartupFailure(new File(TEST_DATA, "create"), "Server started despite create exceeding jute.maxbuffer!");
    }

    @Test
    public void testStartupFailureSet() throws Exception {
        this.testStartupFailure(new File(TEST_DATA, "set"), "Server started despite set exceeding jute.maxbuffer!");
    }

    @Test
    public void testStartupFailureSnapshot() throws Exception {
        this.testStartupFailure(new File(TEST_DATA, "snapshot"), "Server started despite znode exceeding jute.maxbuffer!");
    }

    private void testStartupFailure(File testDir, String failureMsg) throws Exception {
        this.stopServer();
        this.tmpDir = testDir;
        try {
            this.startServer();
            Assert.fail((String)failureMsg);
        }
        catch (IOException e) {
            LOG.info("Successfully caught IOException: " + e);
        }
    }

    private static interface ClientOp {
        public void execute(byte[] var1) throws Exception;
    }
}

