/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AtomicDoubleArray;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.DecayRpcSchedulerMXBean;
import org.apache.hadoop.ipc.IdentityProvider;
import org.apache.hadoop.ipc.RpcScheduler;
import org.apache.hadoop.ipc.Schedulable;
import org.apache.hadoop.ipc.UserIdentityProvider;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.metrics2.util.Metrics2Util;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecayRpcScheduler
implements RpcScheduler,
DecayRpcSchedulerMXBean,
MetricsSource {
    public static final String IPC_SCHEDULER_DECAYSCHEDULER_PERIOD_KEY = "decay-scheduler.period-ms";
    public static final long IPC_SCHEDULER_DECAYSCHEDULER_PERIOD_DEFAULT = 5000L;
    @Deprecated
    public static final String IPC_FCQ_DECAYSCHEDULER_PERIOD_KEY = "faircallqueue.decay-scheduler.period-ms";
    public static final String IPC_SCHEDULER_DECAYSCHEDULER_FACTOR_KEY = "decay-scheduler.decay-factor";
    public static final double IPC_SCHEDULER_DECAYSCHEDULER_FACTOR_DEFAULT = 0.5;
    @Deprecated
    public static final String IPC_FCQ_DECAYSCHEDULER_FACTOR_KEY = "faircallqueue.decay-scheduler.decay-factor";
    public static final String IPC_DECAYSCHEDULER_THRESHOLDS_KEY = "decay-scheduler.thresholds";
    @Deprecated
    public static final String IPC_FCQ_DECAYSCHEDULER_THRESHOLDS_KEY = "faircallqueue.decay-scheduler.thresholds";
    public static final String DECAYSCHEDULER_UNKNOWN_IDENTITY = "IdentityProvider.Unknown";
    public static final String IPC_DECAYSCHEDULER_BACKOFF_RESPONSETIME_ENABLE_KEY = "decay-scheduler.backoff.responsetime.enable";
    public static final Boolean IPC_DECAYSCHEDULER_BACKOFF_RESPONSETIME_ENABLE_DEFAULT = false;
    public static final String IPC_DECAYSCHEDULER_BACKOFF_RESPONSETIME_THRESHOLDS_KEY = "decay-scheduler.backoff.responsetime.thresholds";
    public static final String DECAYSCHEDULER_METRICS_TOP_USER_COUNT = "decay-scheduler.metrics.top.user.count";
    public static final int DECAYSCHEDULER_METRICS_TOP_USER_COUNT_DEFAULT = 10;
    public static final Logger LOG = LoggerFactory.getLogger(DecayRpcScheduler.class);
    private final ConcurrentHashMap<Object, List<AtomicLong>> callCounts = new ConcurrentHashMap();
    private final AtomicLong totalDecayedCallCount = new AtomicLong();
    private final AtomicLong totalRawCallCount = new AtomicLong();
    private final AtomicLongArray responseTimeCountInCurrWindow;
    private final AtomicLongArray responseTimeTotalInCurrWindow;
    private final AtomicDoubleArray responseTimeAvgInLastWindow;
    private final AtomicLongArray responseTimeCountInLastWindow;
    private final AtomicReference<Map<Object, Integer>> scheduleCacheRef = new AtomicReference();
    private final long decayPeriodMillis;
    private final double decayFactor;
    private final int numLevels;
    private final double[] thresholds;
    private final IdentityProvider identityProvider;
    private final boolean backOffByResponseTimeEnabled;
    private final long[] backOffResponseTimeThresholds;
    private final String namespace;
    private final int topUsersCount;
    private static final double PRECISION = 1.0E-4;

    public DecayRpcScheduler(int numLevels, String ns, Configuration conf) {
        if (numLevels < 1) {
            throw new IllegalArgumentException("Number of Priority Levels must be at least 1");
        }
        this.numLevels = numLevels;
        this.namespace = ns;
        this.decayFactor = DecayRpcScheduler.parseDecayFactor(ns, conf);
        this.decayPeriodMillis = DecayRpcScheduler.parseDecayPeriodMillis(ns, conf);
        this.identityProvider = this.parseIdentityProvider(ns, conf);
        this.thresholds = DecayRpcScheduler.parseThresholds(ns, conf, numLevels);
        this.backOffByResponseTimeEnabled = DecayRpcScheduler.parseBackOffByResponseTimeEnabled(ns, conf);
        this.backOffResponseTimeThresholds = DecayRpcScheduler.parseBackOffResponseTimeThreshold(ns, conf, numLevels);
        this.responseTimeTotalInCurrWindow = new AtomicLongArray(numLevels);
        this.responseTimeCountInCurrWindow = new AtomicLongArray(numLevels);
        this.responseTimeAvgInLastWindow = new AtomicDoubleArray(numLevels);
        this.responseTimeCountInLastWindow = new AtomicLongArray(numLevels);
        this.topUsersCount = conf.getInt(DECAYSCHEDULER_METRICS_TOP_USER_COUNT, 10);
        Preconditions.checkArgument(this.topUsersCount > 0, "the number of top users for scheduler metrics must be at least 1");
        Timer timer = new Timer();
        DecayTask task = new DecayTask(this, timer);
        timer.scheduleAtFixedRate((TimerTask)task, this.decayPeriodMillis, this.decayPeriodMillis);
        MetricsProxy prox = MetricsProxy.getInstance(ns, numLevels);
        prox.setDelegate(this);
        prox.registerMetrics2Source(ns);
    }

    private IdentityProvider parseIdentityProvider(String ns, Configuration conf) {
        List<IdentityProvider> providers = conf.getInstances(ns + "." + "identity-provider.impl", IdentityProvider.class);
        if (providers.size() < 1) {
            LOG.info("IdentityProvider not specified, defaulting to UserIdentityProvider");
            return new UserIdentityProvider();
        }
        return providers.get(0);
    }

    private static double parseDecayFactor(String ns, Configuration conf) {
        double factor = conf.getDouble(ns + "." + IPC_FCQ_DECAYSCHEDULER_FACTOR_KEY, 0.0);
        if (factor == 0.0) {
            factor = conf.getDouble(ns + "." + IPC_SCHEDULER_DECAYSCHEDULER_FACTOR_KEY, 0.5);
        } else if (factor > 0.0 && factor < 1.0) {
            LOG.warn("faircallqueue.decay-scheduler.decay-factor is deprecated. Please use decay-scheduler.decay-factor.");
        }
        if (factor <= 0.0 || factor >= 1.0) {
            throw new IllegalArgumentException("Decay Factor must be between 0 and 1");
        }
        return factor;
    }

    private static long parseDecayPeriodMillis(String ns, Configuration conf) {
        long period = conf.getLong(ns + "." + IPC_FCQ_DECAYSCHEDULER_PERIOD_KEY, 0L);
        if (period == 0L) {
            period = conf.getLong(ns + "." + IPC_SCHEDULER_DECAYSCHEDULER_PERIOD_KEY, 5000L);
        } else if (period > 0L) {
            LOG.warn("faircallqueue.decay-scheduler.period-ms is deprecated. Please use decay-scheduler.period-ms");
        }
        if (period <= 0L) {
            throw new IllegalArgumentException("Period millis must be >= 0");
        }
        return period;
    }

    private static double[] parseThresholds(String ns, Configuration conf, int numLevels) {
        int[] percentages = conf.getInts(ns + "." + IPC_FCQ_DECAYSCHEDULER_THRESHOLDS_KEY);
        if (percentages.length == 0) {
            percentages = conf.getInts(ns + "." + IPC_DECAYSCHEDULER_THRESHOLDS_KEY);
            if (percentages.length == 0) {
                return DecayRpcScheduler.getDefaultThresholds(numLevels);
            }
        } else {
            LOG.warn("faircallqueue.decay-scheduler.thresholds is deprecated. Please use decay-scheduler.thresholds");
        }
        if (percentages.length != numLevels - 1) {
            throw new IllegalArgumentException("Number of thresholds should be " + (numLevels - 1) + ". Was: " + percentages.length);
        }
        double[] decimals = new double[percentages.length];
        for (int i = 0; i < percentages.length; ++i) {
            decimals[i] = (double)percentages[i] / 100.0;
        }
        return decimals;
    }

    private static double[] getDefaultThresholds(int numLevels) {
        double[] ret = new double[numLevels - 1];
        double div = Math.pow(2.0, numLevels - 1);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Math.pow(2.0, i) / div;
        }
        return ret;
    }

    private static long[] parseBackOffResponseTimeThreshold(String ns, Configuration conf, int numLevels) {
        long[] responseTimeThresholds = conf.getTimeDurations(ns + "." + IPC_DECAYSCHEDULER_BACKOFF_RESPONSETIME_THRESHOLDS_KEY, TimeUnit.MILLISECONDS);
        if (responseTimeThresholds.length == 0) {
            return DecayRpcScheduler.getDefaultBackOffResponseTimeThresholds(numLevels);
        }
        if (responseTimeThresholds.length != numLevels) {
            throw new IllegalArgumentException("responseTimeThresholds must match with the number of priority levels");
        }
        for (long responseTimeThreshold : responseTimeThresholds) {
            if (responseTimeThreshold > 0L) continue;
            throw new IllegalArgumentException("responseTimeThreshold millis must be >= 0");
        }
        return responseTimeThresholds;
    }

    private static long[] getDefaultBackOffResponseTimeThresholds(int numLevels) {
        long[] ret = new long[numLevels];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = 10000 * (i + 1);
        }
        return ret;
    }

    private static Boolean parseBackOffByResponseTimeEnabled(String ns, Configuration conf) {
        return conf.getBoolean(ns + "." + IPC_DECAYSCHEDULER_BACKOFF_RESPONSETIME_ENABLE_KEY, IPC_DECAYSCHEDULER_BACKOFF_RESPONSETIME_ENABLE_DEFAULT);
    }

    private void decayCurrentCounts() {
        try {
            long totalDecayedCount = 0L;
            long totalRawCount = 0L;
            Iterator<Map.Entry<Object, List<AtomicLong>>> it = this.callCounts.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, List<AtomicLong>> entry = it.next();
                AtomicLong decayedCount = entry.getValue().get(0);
                AtomicLong rawCount = entry.getValue().get(1);
                totalRawCount += rawCount.get();
                long currentValue = decayedCount.get();
                long nextValue = (long)((double)currentValue * this.decayFactor);
                totalDecayedCount += nextValue;
                decayedCount.set(nextValue);
                if (nextValue != 0L) continue;
                it.remove();
            }
            this.totalDecayedCallCount.set(totalDecayedCount);
            this.totalRawCallCount.set(totalRawCount);
            this.recomputeScheduleCache();
            this.updateAverageResponseTime(true);
        }
        catch (Exception ex) {
            LOG.error("decayCurrentCounts exception: " + ExceptionUtils.getFullStackTrace(ex));
            throw ex;
        }
    }

    private void recomputeScheduleCache() {
        HashMap<Object, Integer> nextCache = new HashMap<Object, Integer>();
        for (Map.Entry<Object, List<AtomicLong>> entry : this.callCounts.entrySet()) {
            Object id = entry.getKey();
            AtomicLong value = entry.getValue().get(0);
            long snapshot = value.get();
            int computedLevel = this.computePriorityLevel(snapshot);
            nextCache.put(id, computedLevel);
        }
        this.scheduleCacheRef.set(Collections.unmodifiableMap(nextCache));
    }

    private long getAndIncrementCallCounts(Object identity) throws InterruptedException {
        List<AtomicLong> count = this.callCounts.get(identity);
        if (count == null) {
            count = new ArrayList<AtomicLong>(2);
            count.add(new AtomicLong(0L));
            count.add(new AtomicLong(0L));
            List<AtomicLong> otherCount = this.callCounts.putIfAbsent(identity, count);
            if (otherCount != null) {
                count = otherCount;
            }
        }
        this.totalDecayedCallCount.getAndIncrement();
        this.totalRawCallCount.getAndIncrement();
        count.get(1).getAndIncrement();
        return count.get(0).getAndIncrement();
    }

    private int computePriorityLevel(long occurrences) {
        long totalCallSnapshot = this.totalDecayedCallCount.get();
        double proportion = 0.0;
        if (totalCallSnapshot > 0L) {
            proportion = (double)occurrences / (double)totalCallSnapshot;
        }
        for (int i = this.numLevels - 1; i > 0; --i) {
            if (!(proportion >= this.thresholds[i - 1])) continue;
            return i;
        }
        return 0;
    }

    private int cachedOrComputedPriorityLevel(Object identity) {
        try {
            Integer priority;
            long occurrences = this.getAndIncrementCallCounts(identity);
            Map<Object, Integer> scheduleCache = this.scheduleCacheRef.get();
            if (scheduleCache != null && (priority = scheduleCache.get(identity)) != null) {
                LOG.debug("Cache priority for: {} with priority: {}", identity, (Object)priority);
                return priority;
            }
            int priority2 = this.computePriorityLevel(occurrences);
            LOG.debug("compute priority for " + identity + " priority " + priority2);
            return priority2;
        }
        catch (InterruptedException ie) {
            LOG.warn("Caught InterruptedException, returning low priority level");
            LOG.debug("Fallback priority for: {} with priority: {}", identity, (Object)(this.numLevels - 1));
            return this.numLevels - 1;
        }
    }

    @Override
    public int getPriorityLevel(Schedulable obj) {
        String identity = this.identityProvider.makeIdentity(obj);
        if (identity == null) {
            identity = DECAYSCHEDULER_UNKNOWN_IDENTITY;
        }
        return this.cachedOrComputedPriorityLevel(identity);
    }

    @Override
    public boolean shouldBackOff(Schedulable obj) {
        Boolean backOff = false;
        if (this.backOffByResponseTimeEnabled) {
            int priorityLevel = obj.getPriorityLevel();
            if (LOG.isDebugEnabled()) {
                double[] responseTimes = this.getAverageResponseTime();
                LOG.debug("Current Caller: {}  Priority: {} ", (Object)obj.getUserGroupInformation().getUserName(), (Object)obj.getPriorityLevel());
                for (int i = 0; i < this.numLevels; ++i) {
                    LOG.debug("Queue: {} responseTime: {} backoffThreshold: {}", i, responseTimes[i], this.backOffResponseTimeThresholds[i]);
                }
            }
            for (int i = 0; i < priorityLevel + 1; ++i) {
                if (!(this.responseTimeAvgInLastWindow.get(i) > (double)this.backOffResponseTimeThresholds[i])) continue;
                backOff = true;
                break;
            }
        }
        return backOff;
    }

    @Override
    public void addResponseTime(String name, int priorityLevel, int queueTime, int processingTime) {
        this.responseTimeCountInCurrWindow.getAndIncrement(priorityLevel);
        this.responseTimeTotalInCurrWindow.getAndAdd(priorityLevel, queueTime + processingTime);
        if (LOG.isDebugEnabled()) {
            LOG.debug("addResponseTime for call: {}  priority: {} queueTime: {} processingTime: {} ", name, priorityLevel, queueTime, processingTime);
        }
    }

    void updateAverageResponseTime(boolean enableDecay) {
        for (int i = 0; i < this.numLevels; ++i) {
            double lastAvg;
            double averageResponseTime = 0.0;
            long totalResponseTime = this.responseTimeTotalInCurrWindow.get(i);
            long responseTimeCount = this.responseTimeCountInCurrWindow.get(i);
            if (responseTimeCount > 0L) {
                averageResponseTime = (double)totalResponseTime / (double)responseTimeCount;
            }
            if ((lastAvg = this.responseTimeAvgInLastWindow.get(i)) > 1.0E-4 || averageResponseTime > 1.0E-4) {
                if (enableDecay) {
                    double decayed = this.decayFactor * lastAvg + averageResponseTime;
                    this.responseTimeAvgInLastWindow.set(i, decayed);
                } else {
                    this.responseTimeAvgInLastWindow.set(i, averageResponseTime);
                }
            }
            this.responseTimeCountInLastWindow.set(i, responseTimeCount);
            if (LOG.isDebugEnabled()) {
                LOG.debug("updateAverageResponseTime queue: {} Average: {} Count: {}", i, averageResponseTime, responseTimeCount);
            }
            this.responseTimeTotalInCurrWindow.set(i, 0L);
            this.responseTimeCountInCurrWindow.set(i, 0L);
        }
    }

    @VisibleForTesting
    public double getDecayFactor() {
        return this.decayFactor;
    }

    @VisibleForTesting
    public long getDecayPeriodMillis() {
        return this.decayPeriodMillis;
    }

    @VisibleForTesting
    public double[] getThresholds() {
        return this.thresholds;
    }

    @VisibleForTesting
    public void forceDecay() {
        this.decayCurrentCounts();
    }

    @VisibleForTesting
    public Map<Object, Long> getCallCountSnapshot() {
        HashMap<Object, Long> snapshot = new HashMap<Object, Long>();
        for (Map.Entry<Object, List<AtomicLong>> entry : this.callCounts.entrySet()) {
            snapshot.put(entry.getKey(), entry.getValue().get(0).get());
        }
        return Collections.unmodifiableMap(snapshot);
    }

    @VisibleForTesting
    public long getTotalCallSnapshot() {
        return this.totalDecayedCallCount.get();
    }

    @Override
    public int getUniqueIdentityCount() {
        return this.callCounts.size();
    }

    @Override
    public long getTotalCallVolume() {
        return this.totalDecayedCallCount.get();
    }

    public long getTotalRawCallVolume() {
        return this.totalRawCallCount.get();
    }

    @Override
    public long[] getResponseTimeCountInLastWindow() {
        long[] ret = new long[this.responseTimeCountInLastWindow.length()];
        for (int i = 0; i < this.responseTimeCountInLastWindow.length(); ++i) {
            ret[i] = this.responseTimeCountInLastWindow.get(i);
        }
        return ret;
    }

    @Override
    public double[] getAverageResponseTime() {
        double[] ret = new double[this.responseTimeAvgInLastWindow.length()];
        for (int i = 0; i < this.responseTimeAvgInLastWindow.length(); ++i) {
            ret[i] = this.responseTimeAvgInLastWindow.get(i);
        }
        return ret;
    }

    @Override
    public void getMetrics(MetricsCollector collector, boolean all) {
        try {
            MetricsRecordBuilder rb = collector.addRecord(this.getClass().getName()).setContext(this.namespace);
            this.addDecayedCallVolume(rb);
            this.addUniqueIdentityCount(rb);
            this.addTopNCallerSummary(rb);
            this.addAvgResponseTimePerPriority(rb);
            this.addCallVolumePerPriority(rb);
            this.addRawCallVolume(rb);
        }
        catch (Exception e) {
            LOG.warn("Exception thrown while metric collection. Exception : " + e.getMessage());
        }
    }

    private void addUniqueIdentityCount(MetricsRecordBuilder rb) {
        rb.addCounter(Interns.info("UniqueCallers", "Total unique callers"), this.getUniqueIdentityCount());
    }

    private void addDecayedCallVolume(MetricsRecordBuilder rb) {
        rb.addCounter(Interns.info("DecayedCallVolume", "Decayed Total incoming Call Volume"), this.getTotalCallVolume());
    }

    private void addRawCallVolume(MetricsRecordBuilder rb) {
        rb.addCounter(Interns.info("CallVolume", "Raw Total incoming Call Volume"), this.getTotalRawCallVolume());
    }

    private void addCallVolumePerPriority(MetricsRecordBuilder rb) {
        for (int i = 0; i < this.responseTimeCountInLastWindow.length(); ++i) {
            rb.addGauge(Interns.info("Priority." + i + ".CompletedCallVolume", "Completed Call volume of priority " + i), this.responseTimeCountInLastWindow.get(i));
        }
    }

    private void addAvgResponseTimePerPriority(MetricsRecordBuilder rb) {
        for (int i = 0; i < this.responseTimeAvgInLastWindow.length(); ++i) {
            rb.addGauge(Interns.info("Priority." + i + ".AvgResponseTime", "Average response time of priority " + i), this.responseTimeAvgInLastWindow.get(i));
        }
    }

    private void addTopNCallerSummary(MetricsRecordBuilder rb) {
        Metrics2Util.TopN topNCallers = this.getTopCallers(this.topUsersCount);
        Map<Object, Integer> decisions = this.scheduleCacheRef.get();
        int actualCallerCount = topNCallers.size();
        for (int i = 0; i < actualCallerCount; ++i) {
            Metrics2Util.NameValuePair entry = (Metrics2Util.NameValuePair)topNCallers.poll();
            String topCaller = "Caller(" + entry.getName() + ")";
            String topCallerVolume = topCaller + ".Volume";
            String topCallerPriority = topCaller + ".Priority";
            rb.addCounter(Interns.info(topCallerVolume, topCallerVolume), entry.getValue());
            Integer priority = decisions.get(entry.getName());
            if (priority == null) continue;
            rb.addCounter(Interns.info(topCallerPriority, topCallerPriority), priority);
        }
    }

    private Metrics2Util.TopN getTopCallers(int n) {
        Metrics2Util.TopN topNCallers = new Metrics2Util.TopN(n);
        for (Map.Entry<Object, List<AtomicLong>> entry : this.callCounts.entrySet()) {
            String caller = entry.getKey().toString();
            Long count = entry.getValue().get(1).get();
            if (count <= 0L) continue;
            topNCallers.offer(new Metrics2Util.NameValuePair(caller, count));
        }
        return topNCallers;
    }

    @Override
    public String getSchedulingDecisionSummary() {
        Map<Object, Integer> decisions = this.scheduleCacheRef.get();
        if (decisions == null) {
            return "{}";
        }
        try {
            ObjectMapper om = new ObjectMapper();
            return om.writeValueAsString(decisions);
        }
        catch (Exception e) {
            return "Error: " + e.getMessage();
        }
    }

    @Override
    public String getCallVolumeSummary() {
        try {
            ObjectMapper om = new ObjectMapper();
            return om.writeValueAsString(this.getDecayedCallCounts());
        }
        catch (Exception e) {
            return "Error: " + e.getMessage();
        }
    }

    private Map<Object, Long> getDecayedCallCounts() {
        HashMap<Object, Long> decayedCallCounts = new HashMap<Object, Long>(this.callCounts.size());
        for (Map.Entry<Object, List<AtomicLong>> entry : this.callCounts.entrySet()) {
            Object user = entry.getKey();
            Long decayedCount = entry.getValue().get(0).get();
            if (decayedCount <= 0L) continue;
            decayedCallCounts.put(user, decayedCount);
        }
        return decayedCallCounts;
    }

    public static final class MetricsProxy
    implements DecayRpcSchedulerMXBean,
    MetricsSource {
        private static final HashMap<String, MetricsProxy> INSTANCES = new HashMap();
        private WeakReference<DecayRpcScheduler> delegate;
        private double[] averageResponseTimeDefault;
        private long[] callCountInLastWindowDefault;

        private MetricsProxy(String namespace, int numLevels) {
            this.averageResponseTimeDefault = new double[numLevels];
            this.callCountInLastWindowDefault = new long[numLevels];
            MBeans.register(namespace, "DecayRpcScheduler", this);
        }

        public static synchronized MetricsProxy getInstance(String namespace, int numLevels) {
            MetricsProxy mp = INSTANCES.get(namespace);
            if (mp == null) {
                mp = new MetricsProxy(namespace, numLevels);
                INSTANCES.put(namespace, mp);
            }
            return mp;
        }

        public void setDelegate(DecayRpcScheduler obj) {
            this.delegate = new WeakReference<DecayRpcScheduler>(obj);
        }

        void registerMetrics2Source(String namespace) {
            String name = "DecayRpcSchedulerMetrics2." + namespace;
            DefaultMetricsSystem.instance().register(name, name, this);
        }

        @Override
        public String getSchedulingDecisionSummary() {
            DecayRpcScheduler scheduler = (DecayRpcScheduler)this.delegate.get();
            if (scheduler == null) {
                return "No Active Scheduler";
            }
            return scheduler.getSchedulingDecisionSummary();
        }

        @Override
        public String getCallVolumeSummary() {
            DecayRpcScheduler scheduler = (DecayRpcScheduler)this.delegate.get();
            if (scheduler == null) {
                return "No Active Scheduler";
            }
            return scheduler.getCallVolumeSummary();
        }

        @Override
        public int getUniqueIdentityCount() {
            DecayRpcScheduler scheduler = (DecayRpcScheduler)this.delegate.get();
            if (scheduler == null) {
                return -1;
            }
            return scheduler.getUniqueIdentityCount();
        }

        @Override
        public long getTotalCallVolume() {
            DecayRpcScheduler scheduler = (DecayRpcScheduler)this.delegate.get();
            if (scheduler == null) {
                return -1L;
            }
            return scheduler.getTotalCallVolume();
        }

        @Override
        public double[] getAverageResponseTime() {
            DecayRpcScheduler scheduler = (DecayRpcScheduler)this.delegate.get();
            if (scheduler == null) {
                return this.averageResponseTimeDefault;
            }
            return scheduler.getAverageResponseTime();
        }

        @Override
        public long[] getResponseTimeCountInLastWindow() {
            DecayRpcScheduler scheduler = (DecayRpcScheduler)this.delegate.get();
            if (scheduler == null) {
                return this.callCountInLastWindowDefault;
            }
            return scheduler.getResponseTimeCountInLastWindow();
        }

        @Override
        public void getMetrics(MetricsCollector collector, boolean all) {
            DecayRpcScheduler scheduler = (DecayRpcScheduler)this.delegate.get();
            if (scheduler != null) {
                scheduler.getMetrics(collector, all);
            }
        }
    }

    public static class DecayTask
    extends TimerTask {
        private WeakReference<DecayRpcScheduler> schedulerRef;
        private Timer timer;

        public DecayTask(DecayRpcScheduler scheduler, Timer timer) {
            this.schedulerRef = new WeakReference<DecayRpcScheduler>(scheduler);
            this.timer = timer;
        }

        @Override
        public void run() {
            DecayRpcScheduler sched = (DecayRpcScheduler)this.schedulerRef.get();
            if (sched != null) {
                sched.decayCurrentCounts();
            } else {
                this.timer.cancel();
                this.timer.purge();
            }
        }
    }
}

