/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.ui.resultset;

import com.dbeaver.ee.runtime.internal.ui.resultset.ResultsetMessages;
import com.dbeaver.ee.runtime.ui.resultset.DocumentFrame;
import com.dbeaver.ee.runtime.ui.resultset.IDocumentFrame;
import com.dbeaver.ee.runtime.ui.resultset.IDocumentRenderer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.AbstractPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetEditor;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.text.BaseTextEditor;

public abstract class AbstractDocumentPresentation
extends AbstractPresentation
implements IResultSetEditor {
    private Canvas canvas;
    private List<DocumentFrame> frames = new ArrayList<DocumentFrame>();
    private DocumentFrame topFrame = null;
    private DocumentFrame selectedFrame;
    private int verticalOffset = 0;
    private int horizontalOffset = 0;
    private GC sizingGC;
    private ScrollBar vScroll;
    private ScrollBar hScroll;
    private Color colorShadow;
    private Color colorForeground;
    private Color editBorderColor;
    private Font largeFont;
    private Font smallFont;
    private Color backgroundAdded;
    private Color backgroundDeleted;
    private Color backgroundModified;
    private Color backgroundNormal;

    public void createPresentation(@NotNull IResultSetController iResultSetController, @NotNull Composite composite) {
        super.createPresentation(iResultSetController, composite);
        UIUtils.createHorizontalLine((Composite)composite);
        this.canvas = new Canvas(composite, 0x20000300);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.sizingGC = new GC((Drawable)this.canvas);
        this.colorShadow = this.canvas.getDisplay().getSystemColor(18);
        this.colorForeground = iResultSetController.getDefaultForeground();
        this.editBorderColor = this.canvas.getDisplay().getSystemColor(3);
        this.canvas.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        Font font = composite.getFont();
        FontData[] fontDataArray = font.getFontData();
        fontDataArray[0].setStyle(fontDataArray[0].getStyle() | 1);
        fontDataArray[0].setHeight(fontDataArray[0].getHeight() + 4);
        this.largeFont = new Font(font.getDevice(), fontDataArray[0]);
        fontDataArray = font.getFontData();
        fontDataArray[0].setHeight(fontDataArray[0].getHeight() - 1);
        this.smallFont = new Font(font.getDevice(), fontDataArray[0]);
        this.vScroll = this.canvas.getVerticalBar();
        this.vScroll.setVisible(true);
        this.hScroll = this.canvas.getHorizontalBar();
        this.hScroll.setVisible(true);
        this.canvas.addPaintListener(this::onPaint);
        this.canvas.addMouseMoveListener(this::onMouseMove);
        this.canvas.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                AbstractDocumentPresentation.this.onMouseDoubleClick(mouseEvent);
            }

            public void mouseDown(MouseEvent mouseEvent) {
                AbstractDocumentPresentation.this.onMouseDown(mouseEvent);
            }

            public void mouseUp(MouseEvent mouseEvent) {
                AbstractDocumentPresentation.this.onMouseUp(mouseEvent);
            }
        });
        this.canvas.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                AbstractDocumentPresentation.this.onKeyPressed(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                AbstractDocumentPresentation.this.onKeyReleased(keyEvent);
            }
        });
        this.vScroll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AbstractDocumentPresentation.this.onVerticalScroll();
            }
        });
        this.hScroll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AbstractDocumentPresentation.this.onHorizontalScroll();
            }
        });
        this.canvas.addListener(11, event -> {
            this.updateMeasures(true);
            this.canvas.redraw();
        });
        this.canvas.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                AbstractDocumentPresentation.this.onFocusGain(focusEvent);
            }
        });
        this.registerContextMenu();
        this.trackPresentationControl();
        UIUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)iResultSetController.getSite(), (Control)this.canvas);
        this.canvas.addDisposeListener(disposeEvent -> {
            UIUtils.dispose((Resource)this.largeFont);
            UIUtils.dispose((Resource)this.smallFont);
        });
        this.applyThemeSettings();
    }

    protected void applyThemeSettings() {
        IThemeManager iThemeManager = this.controller.getSite().getWorkbenchWindow().getWorkbench().getThemeManager();
        ITheme iTheme = iThemeManager.getCurrentTheme();
        this.backgroundAdded = iTheme.getColorRegistry().get("org.jkiss.dbeaver.sql.resultset.color.cell.new.background");
        this.backgroundDeleted = iTheme.getColorRegistry().get("org.jkiss.dbeaver.sql.resultset.color.cell.deleted.background");
        this.backgroundModified = iTheme.getColorRegistry().get("org.jkiss.dbeaver.sql.resultset.color.cell.modified.background");
        this.backgroundNormal = this.controller.getDefaultBackground();
    }

    private void onKeyPressed(KeyEvent keyEvent) {
        switch (keyEvent.keyCode) {
            case 0x1000004: {
                break;
            }
            case 0x1000003: {
                break;
            }
            case 0x1000001: {
                this.vScroll.setSelection(Math.max(0, this.vScroll.getSelection() - this.vScroll.getIncrement()));
                this.onVerticalScroll();
                break;
            }
            case 0x1000002: {
                this.vScroll.setSelection(Math.min(this.vScroll.getMaximum(), this.vScroll.getSelection() + this.vScroll.getIncrement()));
                this.onVerticalScroll();
                break;
            }
            case 0x1000005: {
                this.vScroll.setSelection(Math.max(0, this.vScroll.getSelection() - this.vScroll.getPageIncrement()));
                this.onVerticalScroll();
                break;
            }
            case 0x1000006: {
                this.vScroll.setSelection(Math.min(this.vScroll.getMaximum(), this.vScroll.getSelection() + this.vScroll.getPageIncrement()));
                this.onVerticalScroll();
                break;
            }
            case 0x1000007: {
                this.vScroll.setSelection(0);
                this.onVerticalScroll();
                break;
            }
            case 0x1000008: {
                this.vScroll.setSelection(this.vScroll.getMaximum());
                this.onVerticalScroll();
                break;
            }
            case 97: {
                if (this.selectedFrame == null || (keyEvent.stateMask & 0x40000) == 0) break;
                this.selectedFrame.selectAll();
                this.canvas.redraw();
                break;
            }
            default: {
                return;
            }
        }
    }

    private void onKeyReleased(KeyEvent keyEvent) {
    }

    private void onVerticalScroll() {
        if (this.verticalOffset == this.vScroll.getSelection()) {
            return;
        }
        this.verticalOffset = this.vScroll.getSelection();
        if (this.selectedFrame != null) {
            this.selectedFrame.updateEditorBounds();
        }
        this.canvas.redraw();
    }

    private void onHorizontalScroll() {
        if (this.horizontalOffset == this.hScroll.getSelection()) {
            return;
        }
        this.horizontalOffset = this.hScroll.getSelection();
        if (this.selectedFrame != null) {
            this.selectedFrame.updateEditorBounds();
        }
        this.canvas.redraw();
    }

    private void onPaint(PaintEvent paintEvent) {
        Rectangle rectangle = this.canvas.getClientArea();
        int n = rectangle.height;
        paintEvent.gc.setFont(this.canvas.getFont());
        this.topFrame = null;
        for (DocumentFrame documentFrame : this.frames) {
            if (documentFrame.getTopOffset() + documentFrame.getSize().y < this.verticalOffset) continue;
            if (documentFrame.getTopOffset() - this.verticalOffset > n) break;
            if (this.topFrame == null) {
                this.topFrame = documentFrame;
            }
            Rectangle rectangle2 = documentFrame.getBounds(rectangle);
            documentFrame.paintFrame(paintEvent.gc, this.canvas, rectangle2);
        }
    }

    private void onMouseMove(MouseEvent mouseEvent) {
        if (this.selectedFrame != null) {
            this.selectedFrame.onMouseMove(mouseEvent);
        }
    }

    private void onMouseDown(MouseEvent mouseEvent) {
        DocumentFrame documentFrame;
        if ((this.canvas.getStyle() & 0x80000) != 524288) {
            this.canvas.forceFocus();
        }
        if ((documentFrame = this.getFrameAt(mouseEvent.x, mouseEvent.y)) != this.selectedFrame) {
            this.closeEditor();
        }
        this.selectedFrame = documentFrame;
        if (this.selectedFrame != null) {
            if (this.controller.getCurrentRow() != this.selectedFrame.getRow()) {
                this.controller.setCurrentRow(this.selectedFrame.getRow());
                this.controller.updateEditControls();
                this.canvas.redraw();
            }
            this.selectedFrame.onMouseDown(mouseEvent);
        }
    }

    private void onMouseUp(MouseEvent mouseEvent) {
        if (this.selectedFrame != null) {
            this.selectedFrame.onMouseUp(mouseEvent);
        }
    }

    private void onMouseDoubleClick(MouseEvent mouseEvent) {
        if (this.selectedFrame != null && this.selectedFrame.handleDoubleClick(mouseEvent)) {
            return;
        }
        this.showEditor();
    }

    private void onFocusGain(FocusEvent focusEvent) {
    }

    public Color getBackgroundNormal() {
        return this.backgroundNormal;
    }

    public Color getBackgroundModified() {
        return this.backgroundModified;
    }

    public Color getBackgroundDeleted() {
        return this.backgroundDeleted;
    }

    public Color getBackgroundAdded() {
        return this.backgroundAdded;
    }

    public void showFrame(@NotNull DocumentFrame documentFrame) {
        if (documentFrame.getTopOffset() < this.verticalOffset || documentFrame.getTopOffset() > this.verticalOffset + this.canvas.getClientArea().height) {
            this.vScroll.setSelection(documentFrame.getTopOffset());
            this.onVerticalScroll();
        }
    }

    @Nullable
    public DocumentFrame findSelectedFrame() {
        ResultSetRow resultSetRow = this.controller.getCurrentRow();
        if (resultSetRow == null) {
            return null;
        }
        for (DocumentFrame documentFrame : this.frames) {
            if (documentFrame.getRow() != resultSetRow) continue;
            return documentFrame;
        }
        return null;
    }

    @Nullable
    public DocumentFrame getFrameAt(int n, int n2) {
        if (this.topFrame == null) {
            return null;
        }
        int n3 = this.verticalOffset + n2;
        int n4 = this.topFrame.getFrameNumber();
        while (n4 < this.frames.size()) {
            DocumentFrame documentFrame = this.frames.get(n4);
            if (documentFrame.isInPosition(n, n3)) {
                return documentFrame;
            }
            ++n4;
        }
        return null;
    }

    public int getVerticalOffset() {
        return this.verticalOffset;
    }

    public int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    private void initFrames(boolean bl) {
        if (this.controller.isRecordMode()) {
            this.clearFrames();
            this.clearMetaData();
            DocumentFrame documentFrame = new DocumentFrame(this, 0);
            documentFrame.setRow(this.controller.getModel().getDocumentAttribute(), this.controller.getCurrentRow());
            this.frames.add(documentFrame);
        } else {
            int n = 0;
            if (!bl) {
                this.clearFrames();
            } else {
                n = this.frames.size();
            }
            ResultSetModel resultSetModel = this.controller.getModel();
            int n2 = resultSetModel.getRowCount();
            int n3 = n;
            while (n3 < n2) {
                DocumentFrame documentFrame = new DocumentFrame(this, n3);
                documentFrame.setRow(resultSetModel.getDocumentAttribute(), resultSetModel.getRow(n3));
                this.frames.add(documentFrame);
                ++n3;
            }
        }
        this.updateMeasures(true);
    }

    void updateMeasures(boolean bl) {
        Rectangle rectangle = this.canvas.getClientArea();
        int n = rectangle.height;
        int n2 = rectangle.width;
        int n3 = 0;
        int n4 = 0;
        for (DocumentFrame documentFrame : this.frames) {
            documentFrame.setTopOffset(n3);
            if (bl) {
                documentFrame.updateSizes(this.sizingGC, false);
            }
            Point point = documentFrame.getSize();
            n3 += point.y;
            n4 = Math.max(n4, point.x);
        }
        if (bl) {
            this.vScroll.setValues(0, 0, n3, n, 32, n);
            this.hScroll.setValues(0, 0, n4, n2, 32, n2);
            this.hScroll.setVisible(n4 > n2);
        }
    }

    private void clearFrames() {
        for (DocumentFrame documentFrame : this.frames) {
            documentFrame.dispose();
        }
        this.frames.clear();
        this.selectedFrame = null;
    }

    public Canvas getControl() {
        return this.canvas;
    }

    public void refreshData(boolean bl, boolean bl2, boolean bl3) {
        this.canvas.setRedraw(false);
        try {
            this.initFrames(bl2);
        }
        finally {
            this.canvas.setRedraw(true);
        }
    }

    public void formatData(boolean bl) {
    }

    public void clearMetaData() {
        this.topFrame = null;
        this.verticalOffset = 0;
        this.horizontalOffset = 0;
    }

    public void updateValueView() {
    }

    public void changeMode(boolean bl) {
    }

    public void scrollToRow(@NotNull IResultSetPresentation.RowPosition rowPosition) {
        this.closeEditor();
        super.scrollToRow(rowPosition);
        this.selectedFrame = this.findSelectedFrame();
        if (this.selectedFrame != null) {
            this.showFrame(this.selectedFrame);
        }
    }

    @Nullable
    public DBDAttributeBinding getCurrentAttribute() {
        return this.controller.getModel().getDocumentAttribute();
    }

    @Nullable
    public String copySelectionToString(ResultSetCopySettings resultSetCopySettings) {
        if (this.selectedFrame != null) {
            return this.selectedFrame.convertToString(resultSetCopySettings.isCopyHeader(), resultSetCopySettings.getFormat());
        }
        return null;
    }

    public Color getColorShadow() {
        return this.colorShadow;
    }

    public Color getColorForeground() {
        return this.colorForeground;
    }

    public Color getEditBorderColor() {
        return this.editBorderColor;
    }

    public Font getLargeFont() {
        return this.largeFont;
    }

    public Font getSmallFont() {
        return this.smallFont;
    }

    protected IEditorPart createEditor(Composite composite, DBDDocument dBDDocument) throws DBException {
        SubEditorSite subEditorSite = new SubEditorSite(this.controller.getSite());
        IEditorInput iEditorInput = this.createEditorInput(dBDDocument);
        IEditorPart iEditorPart = this.createEditorPart();
        try {
            iEditorPart.init((IEditorSite)subEditorSite, iEditorInput);
        }
        catch (PartInitException partInitException) {
            iEditorPart.dispose();
            throw new DBException(ResultsetMessages.AbstractDocumentPresentation_e_cannot_init_document, (Throwable)partInitException);
        }
        iEditorPart.createPartControl(composite);
        if (iEditorPart instanceof BaseTextEditor) {
            StyledText styledText = ((BaseTextEditor)iEditorPart).getTextViewer().getTextWidget();
            UIUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)this.controller.getSite(), (Control)styledText);
            styledText.setAlwaysShowScrollBars(false);
            styledText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    switch (keyEvent.keyCode) {
                        case 27: {
                            AbstractDocumentPresentation.this.closeEditor();
                        }
                    }
                }
            });
        }
        composite.layout();
        iEditorPart.setFocus();
        return iEditorPart;
    }

    void showEditor() {
        if (this.selectedFrame != null) {
            try {
                this.selectedFrame.updateSizes(this.sizingGC, true);
                Rectangle rectangle = this.getControl().getClientArea();
                if (this.selectedFrame.getTopOffset() < this.verticalOffset || this.selectedFrame.getTopOffset() + this.selectedFrame.getSize().y > this.verticalOffset + rectangle.height) {
                    this.verticalOffset = this.selectedFrame.getTopOffset();
                    this.vScroll.setSelection(this.verticalOffset);
                }
                this.selectedFrame.showEditor();
            }
            catch (DBException dBException) {
                DBUserInterface.getInstance().showError(ResultsetMessages.AbstractDocumentPresentation_e_editor_open_title, ResultsetMessages.AbstractDocumentPresentation_e_editor_open_message, (Throwable)dBException);
            }
        }
    }

    void closeEditor() {
        if (this.selectedFrame != null) {
            this.selectedFrame.closeEditor();
            this.selectedFrame.updateSizes(this.sizingGC, false);
            this.canvas.redraw();
        }
    }

    protected byte[] convertDocumentToData(DBDDocument dBDDocument) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            dBDDocument.serializeDocument((DBRProgressMonitor)new VoidProgressMonitor(), (OutputStream)byteArrayOutputStream, "UTF-8");
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter((Writer)stringWriter, true));
            return ("Error transforming document: " + stringWriter.toString()).getBytes();
        }
    }

    @Nullable
    public Control openValueEditor(boolean bl) {
        if (this.selectedFrame != null) {
            this.showEditor();
            return this.selectedFrame.getEditorFrame();
        }
        return null;
    }

    public void pasteFromClipboard(boolean bl) {
    }

    public ISelection getSelection() {
        if (this.selectedFrame == null) {
            return new StructuredSelection();
        }
        return new DocumentSelection();
    }

    public void setSelection(ISelection iSelection) {
        Object object;
        if (iSelection instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof DocumentFrame) {
            this.selectedFrame = (DocumentFrame)object;
        }
    }

    @NotNull
    protected abstract IDocumentRenderer createRenderer(@NotNull IDocumentFrame var1);

    @NotNull
    protected abstract IEditorInput createEditorInput(@NotNull DBDDocument var1);

    @NotNull
    protected abstract IEditorPart createEditorPart() throws DBException;

    @NotNull
    public abstract DBDDocument createDocumentFromContent(@NotNull DBDContent var1);

    @NotNull
    protected abstract DBDDocument createNewDocument() throws DBException;

    private class DocumentSelection
    extends StructuredSelection
    implements IResultSetSelection {
        public DocumentSelection() {
            super((Object)AbstractDocumentPresentation.this.selectedFrame);
        }

        @NotNull
        public IResultSetController getController() {
            return AbstractDocumentPresentation.this.controller;
        }

        @NotNull
        public Collection<DBDAttributeBinding> getSelectedAttributes() {
            DBDAttributeBinding dBDAttributeBinding = AbstractDocumentPresentation.this.getCurrentAttribute();
            return dBDAttributeBinding == null ? Collections.emptyList() : Collections.singleton(dBDAttributeBinding);
        }

        @NotNull
        public Collection<ResultSetRow> getSelectedRows() {
            return Collections.singleton(AbstractDocumentPresentation.this.selectedFrame.getRow());
        }

        public DBDAttributeBinding getElementAttribute(Object object) {
            return AbstractDocumentPresentation.this.getCurrentAttribute();
        }

        public ResultSetRow getElementRow(Object object) {
            return AbstractDocumentPresentation.this.selectedFrame.getRow();
        }
    }
}

