/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.GDSWarning;
import org.firebirdsql.gds.IscDbHandle;
import org.firebirdsql.gds.IscTrHandle;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.AbstractIscStmtHandle;
import org.firebirdsql.gds.impl.AbstractIscTrHandle;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jca.FBConnectionRequestInfo;
import org.firebirdsql.jca.FBIncorrectXidException;
import org.firebirdsql.jca.FBLocalTransaction;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jca.FBManagedConnectionMetaData;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jca.FBTpb;
import org.firebirdsql.jca.FBXAException;
import org.firebirdsql.jca.FBXid;
import org.firebirdsql.jca.FatalGDSErrorHelper;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public class FBManagedConnection
implements ManagedConnection,
XAResource,
GDSHelper.GDSHelperErrorListener {
    public static final String WARNING_NO_CHARSET = "WARNING: No connection characterset specified (property lc_ctype, encoding, charSet or localEncoding), defaulting to characterset NONE";
    private static final Logger log = LoggerFactory.getLogger(FBManagedConnection.class, false);
    private final FBManagedConnectionFactory mcf;
    private final ArrayList connectionEventListeners = new ArrayList();
    private final ArrayList connectionHandles = new ArrayList();
    private int timeout = 0;
    private final Map xidMap = Collections.synchronizedMap(new HashMap());
    private final GDS gds;
    private final IscDbHandle dbHandle;
    private GDSHelper gdsHelper;
    private final FBConnectionRequestInfo cri;
    private FBTpb tpb;
    private int transactionIsolation;
    private volatile boolean managedEnvironment = true;
    private volatile boolean connectionSharing = true;
    private final Set preparedXid = Collections.synchronizedSet(new HashSet());
    private volatile boolean inDistributedTransaction = false;
    private static final String FORGET_FIND_QUERY = "SELECT RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION FROM RDB$TRANSACTIONS WHERE RDB$TRANSACTION_STATE IN (2, 3)";
    private static final String FORGET_DELETE_QUERY = "DELETE FROM RDB$TRANSACTIONS WHERE RDB$TRANSACTION_ID = ";
    private static final String RECOVERY_QUERY = "SELECT RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION FROM RDB$TRANSACTIONS";
    static final CELNotifier connectionClosedNotifier = new CELNotifier(){

        @Override
        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.connectionClosed(ce);
        }
    };
    static final CELNotifier connectionErrorOccurredNotifier = new CELNotifier(){

        @Override
        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.connectionErrorOccurred(ce);
        }
    };
    static final CELNotifier localTransactionStartedNotifier = new CELNotifier(){

        @Override
        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.localTransactionStarted(ce);
        }
    };
    static final CELNotifier localTransactionCommittedNotifier = new CELNotifier(){

        @Override
        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.localTransactionCommitted(ce);
        }
    };
    static final CELNotifier localTransactionRolledbackNotifier = new CELNotifier(){

        @Override
        public void notify(ConnectionEventListener cel, ConnectionEvent ce) {
            cel.localTransactionRolledback(ce);
        }
    };

    FBManagedConnection(Subject subject, ConnectionRequestInfo cri, FBManagedConnectionFactory mcf) throws ResourceException {
        this.mcf = mcf;
        this.gds = mcf.getGDS();
        this.cri = this.getCombinedConnectionRequestInfo(subject, cri);
        this.tpb = mcf.getDefaultTpb();
        this.transactionIsolation = mcf.getDefaultTransactionIsolation();
        try {
            this.dbHandle = this.gds.createIscDbHandle();
            DatabaseParameterBuffer dpb = this.cri.getDpb();
            if (dpb.getArgumentAsString(48) == null) {
                if (log != null) {
                    log.warn(WARNING_NO_CHARSET);
                }
                this.dbHandle.addWarning(new GDSWarning(WARNING_NO_CHARSET));
            }
            if (!dpb.hasArgument(57) && DriverManager.getLoginTimeout() > 0) {
                dpb.addArgument(57, DriverManager.getLoginTimeout());
            }
            this.gds.iscAttachDatabase(mcf.getDatabase(), this.dbHandle, dpb);
            this.gdsHelper = new GDSHelper(this.gds, dpb, this.dbHandle, this);
        }
        catch (GDSException ex) {
            throw new FBResourceException(ex);
        }
    }

    @Override
    public void errorOccured(GDSException ex) {
        if (log != null) {
            log.trace(ex.getMessage());
        }
        if (!FatalGDSErrorHelper.isFatal(ex)) {
            return;
        }
        ConnectionEvent event = new ConnectionEvent(this, 5, ex);
        this.notify(connectionErrorOccurredNotifier, event);
    }

    private FBConnectionRequestInfo getCombinedConnectionRequestInfo(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (cri == null) {
            cri = this.mcf.getDefaultConnectionRequestInfo();
        }
        try {
            FBConnectionRequestInfo fbcri = (FBConnectionRequestInfo)cri;
            if (subject != null) {
                for (Object cred : subject.getPrivateCredentials()) {
                    if (!(cred instanceof PasswordCredential) || !this.mcf.equals(((PasswordCredential)cred).getManagedConnectionFactory())) continue;
                    PasswordCredential pcred = (PasswordCredential)cred;
                    String user = pcred.getUserName();
                    String password = new String(pcred.getPassword());
                    fbcri.setPassword(password);
                    fbcri.setUserName(user);
                    break;
                }
            }
            return fbcri;
        }
        catch (ClassCastException cce) {
            throw new FBResourceException("Incorrect ConnectionRequestInfo class supplied");
        }
    }

    public GDSHelper getGDSHelper() throws GDSException {
        if (this.gdsHelper == null) {
            throw new GDSException(1, 335544363);
        }
        return this.gdsHelper;
    }

    public String getDatabase() {
        return this.mcf.getDatabase();
    }

    public boolean isManagedEnvironment() {
        return this.managedEnvironment;
    }

    public boolean inTransaction() {
        return this.gdsHelper.inTransaction();
    }

    public void setManagedEnvironment(boolean managedEnvironment) throws ResourceException {
        this.managedEnvironment = managedEnvironment;
        if (!this.connectionSharing) {
            if (this.connectionHandles.size() > 1) {
                throw new IllegalStateException("Multiple connections associated with this managed connection in non-sharing mode.");
            }
            for (AbstractConnection connection : this.connectionHandles) {
                try {
                    connection.setManagedEnvironment(managedEnvironment);
                }
                catch (SQLException ex) {
                    throw new FBResourceException(ex);
                }
            }
        }
    }

    public boolean isConnectionSharing() {
        return this.connectionSharing;
    }

    public void setConnectionSharing(boolean connectionSharing) throws ResourceException {
        if (!this.connectionHandles.isEmpty()) {
            throw new IllegalStateException("Cannot change connection sharing with active connection handles.");
        }
        this.connectionSharing = connectionSharing;
    }

    @Override
    public LocalTransaction getLocalTransaction() {
        return new FBLocalTransaction(this, null);
    }

    @Override
    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new FBManagedConnectionMetaData(this);
    }

    @Override
    public void setLogWriter(PrintWriter out) {
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connectionEventListeners.remove(listener);
    }

    @Override
    public void associateConnection(Object connection) throws ResourceException {
        if (!this.connectionSharing) {
            this.disassociateConnections();
        }
        try {
            ((AbstractConnection)connection).setManagedConnection(this);
            this.connectionHandles.add(connection);
        }
        catch (ClassCastException cce) {
            throw new FBResourceException("invalid connection supplied to associateConnection.", cce);
        }
    }

    @Override
    public void cleanup() throws ResourceException {
        this.disassociateConnections();
        this.gdsHelper.setCurrentTrHandle(null);
        this.tpb = this.mcf.getDefaultTpb();
        this.transactionIsolation = this.mcf.getDefaultTransactionIsolation();
    }

    private void disassociateConnections() throws ResourceException {
        SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
        ArrayList connectionHandleCopy = new ArrayList(this.connectionHandles);
        for (AbstractConnection connection : connectionHandleCopy) {
            try {
                connection.close();
            }
            catch (SQLException sqlex) {
                chain.append(sqlex);
            }
        }
        this.connectionHandles.clear();
        if (chain.hasException()) {
            throw new FBResourceException((Exception)chain.getException());
        }
    }

    @Override
    public Object getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (!this.matches(subject, cri)) {
            throw new FBResourceException("Incompatible subject or ConnectionRequestInfo in getConnection!");
        }
        if (!this.connectionSharing) {
            this.disassociateConnections();
        }
        AbstractConnection c = this.mcf.newConnection(this);
        try {
            c.setManagedEnvironment(this.isManagedEnvironment());
            this.connectionHandles.add(c);
            return c;
        }
        catch (SQLException ex) {
            throw new FBResourceException(ex);
        }
    }

    @Override
    public void destroy() throws ResourceException {
        if (this.gdsHelper == null) {
            return;
        }
        if (this.gdsHelper.inTransaction()) {
            throw new IllegalStateException("Can't destroy managed connection  with active transaction");
        }
        try {
            this.gdsHelper.detachDatabase();
        }
        catch (GDSException ge) {
            throw new FBResourceException("Can't detach from db.", ge);
        }
        finally {
            this.gdsHelper = null;
        }
    }

    @Override
    public XAResource getXAResource() {
        if (log != null) {
            log.debug("XAResource requested from FBManagedConnection");
        }
        return this;
    }

    boolean isXidActive(Xid xid) {
        IscTrHandle trHandle = (IscTrHandle)this.xidMap.get(xid);
        if (trHandle == null) {
            return false;
        }
        IscDbHandle dbHandle = trHandle.getDbHandle();
        if (dbHandle == null) {
            return false;
        }
        return dbHandle.isValid();
    }

    @Override
    public void commit(Xid id, boolean onePhase) throws XAException {
        try {
            this.mcf.notifyCommit(this, id, onePhase);
        }
        catch (GDSException ge) {
            throw new XAException(ge.getXAErrorCode());
        }
    }

    void internalCommit(Xid xid, boolean onePhase) throws XAException, GDSException {
        if (log != null) {
            log.trace("Commit called: " + xid);
        }
        AbstractIscTrHandle committingTr = (AbstractIscTrHandle)this.xidMap.get(xid);
        if (onePhase && this.isPrepared(xid)) {
            throw new FBXAException("Cannot commit one-phase when transaction has been prepared", -6);
        }
        if (!onePhase && !this.isPrepared(xid)) {
            throw new FBXAException("Cannot commit two-phase when transaction has not been prepared", -6);
        }
        if (committingTr == null) {
            throw new FBXAException("Commit called with unknown transaction", -4);
        }
        if (committingTr == this.gdsHelper.getCurrentTrHandle()) {
            throw new FBXAException("Commit called with non-ended xid", -6);
        }
        try {
            committingTr.forgetResultSets();
            try {
                this.gdsHelper.commitTransaction(committingTr);
            }
            catch (GDSException ge) {
                block15: {
                    try {
                        this.gdsHelper.rollbackTransaction(committingTr);
                    }
                    catch (GDSException ge2) {
                        if (log == null) break block15;
                        log.debug("Exception rolling back failed tx: ", ge2);
                    }
                }
                throw ge;
            }
            finally {
                this.xidMap.remove(xid);
                this.preparedXid.remove(xid);
            }
        }
        catch (GDSException ge) {
            ge.setXAErrorCode(-3);
            throw ge;
        }
    }

    private boolean isPrepared(Xid xid) {
        return this.preparedXid.contains(xid);
    }

    @Override
    public void end(Xid id, int flags) throws XAException {
        if (flags != 0x4000000 && flags != 0x20000000 && flags != 0x2000000) {
            throw new FBXAException("flag not allowed in this context: " + flags + ", valid flags are TMSUCCESS, TMFAIL, TMSUSPEND", -6);
        }
        this.internalEnd(id, flags);
        this.mcf.notifyEnd(this, id);
        this.inDistributedTransaction = false;
        try {
            this.setManagedEnvironment(this.isManagedEnvironment());
        }
        catch (ResourceException ex) {
            throw new FBXAException("Reset of managed state failed", -3);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void internalEnd(Xid xid, int flags) throws XAException {
        IscTrHandle endingTr;
        if (log != null) {
            log.debug("End called: " + xid);
        }
        if ((endingTr = (IscTrHandle)this.xidMap.get(xid)) == null) {
            throw new FBXAException("Unrecognized transaction", -4);
        }
        if (flags == 0x20000000) {
            try {
                this.gds.iscRollbackTransaction(endingTr);
                this.gdsHelper.setCurrentTrHandle(null);
                return;
            }
            catch (GDSException ex) {
                throw new FBXAException("can't rollback transaction", -7, ex);
            }
        } else if (flags == 0x4000000) {
            if (endingTr != this.gdsHelper.getCurrentTrHandle()) throw new FBXAException("You are trying to end a transaction that is not the current transaction", -5);
            this.gdsHelper.setCurrentTrHandle(null);
            return;
        } else {
            if (flags != 0x2000000) return;
            if (endingTr != this.gdsHelper.getCurrentTrHandle()) throw new FBXAException("You are trying to suspend a transaction that is not the current transaction", -5);
            this.gdsHelper.setCurrentTrHandle(null);
        }
    }

    @Override
    public void forget(Xid id) throws XAException {
        GDSHelper gdsHelper2;
        AbstractIscStmtHandle stmtHandle2;
        AbstractIscTrHandle trHandle2;
        long inLimboId = -1L;
        try {
            trHandle2 = (AbstractIscTrHandle)this.gds.createIscTrHandle();
            this.gds.iscStartTransaction(trHandle2, this.gdsHelper.getCurrentDbHandle(), this.tpb.getTransactionParameterBuffer());
            stmtHandle2 = (AbstractIscStmtHandle)this.gds.createIscStmtHandle();
            this.gds.iscDsqlAllocateStatement(this.gdsHelper.getCurrentDbHandle(), stmtHandle2);
            gdsHelper2 = new GDSHelper(this.gds, this.gdsHelper.getDatabaseParameterBuffer(), this.gdsHelper.getCurrentDbHandle(), null);
            gdsHelper2.setCurrentTrHandle(trHandle2);
            gdsHelper2.prepareStatement(stmtHandle2, FORGET_FIND_QUERY, false);
            gdsHelper2.executeStatement(stmtHandle2, false);
            gdsHelper2.fetch(stmtHandle2, 10);
            DataProvider dataProvider0 = new DataProvider(stmtHandle2, 0);
            DataProvider dataProvider1 = new DataProvider(stmtHandle2, 1);
            FBField field0 = FBField.createField(stmtHandle2.getOutSqlda().sqlvar[0], dataProvider0, gdsHelper2, false);
            FBField field1 = FBField.createField(stmtHandle2.getOutSqlda().sqlvar[1], dataProvider1, gdsHelper2, false);
            field0.setConnection(gdsHelper2);
            field1.setConnection(gdsHelper2);
            int row = 0;
            while (row < stmtHandle2.getRows().length) {
                block16: {
                    if (stmtHandle2.getRows()[row] == null) {
                        ++row;
                        continue;
                    }
                    dataProvider0.setRow(row);
                    dataProvider1.setRow(row);
                    long inLimboTxId = field0.getLong();
                    byte[] inLimboMessage = field1.getBytes();
                    try {
                        FBXid xid = new FBXid(new ByteArrayInputStream(inLimboMessage), inLimboTxId);
                        boolean gtridEquals = Arrays.equals(xid.getGlobalTransactionId(), id.getGlobalTransactionId());
                        boolean bqualEquals = Arrays.equals(xid.getBranchQualifier(), id.getBranchQualifier());
                        if (gtridEquals && bqualEquals) {
                            inLimboId = inLimboTxId;
                            break;
                        }
                    }
                    catch (FBIncorrectXidException ex) {
                        if (log == null) break block16;
                        log.warn("incorrect XID format in RDB$TRANSACTIONS where RDB$TRANSACTION_ID=" + inLimboTxId, ex);
                    }
                }
                ++row;
            }
            gdsHelper2.closeStatement(stmtHandle2, true);
            this.gds.iscCommitTransaction(trHandle2);
        }
        catch (GDSException ex) {
            if (log != null) {
                log.debug("can't perform query to fetch xids", ex);
            }
            throw new FBXAException(-7, ex);
        }
        catch (SQLException ex) {
            if (log != null) {
                log.debug("can't perform query to fetch xids", ex);
            }
            throw new FBXAException(-7, ex);
        }
        catch (ResourceException ex) {
            if (log != null) {
                log.debug("can't perform query to fetch xids", ex);
            }
            throw new FBXAException(-7, ex);
        }
        if (inLimboId == -1L) {
            throw new FBXAException("XID not found", -4);
        }
        try {
            trHandle2 = (AbstractIscTrHandle)this.gds.createIscTrHandle();
            this.gds.iscStartTransaction(trHandle2, this.gdsHelper.getCurrentDbHandle(), this.tpb.getTransactionParameterBuffer());
            stmtHandle2 = (AbstractIscStmtHandle)this.gds.createIscStmtHandle();
            this.gds.iscDsqlAllocateStatement(this.gdsHelper.getCurrentDbHandle(), stmtHandle2);
            stmtHandle2 = (AbstractIscStmtHandle)this.gds.createIscStmtHandle();
            this.gds.iscDsqlAllocateStatement(this.gdsHelper.getCurrentDbHandle(), stmtHandle2);
            gdsHelper2 = new GDSHelper(this.gds, this.gdsHelper.getDatabaseParameterBuffer(), this.gdsHelper.getCurrentDbHandle(), null);
            gdsHelper2.setCurrentTrHandle(trHandle2);
            gdsHelper2.prepareStatement(stmtHandle2, FORGET_DELETE_QUERY + inLimboId, false);
            gdsHelper2.executeStatement(stmtHandle2, false);
            gdsHelper2.closeStatement(stmtHandle2, true);
            this.gds.iscCommitTransaction(trHandle2);
        }
        catch (GDSException ex) {
            throw new FBXAException("can't perform query to fetch xids", -7, ex);
        }
        catch (SQLException ex) {
            throw new FBXAException("can't perform query to fetch xids", -7, ex);
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    @Override
    public boolean isSameRM(XAResource res) throws XAException {
        return res instanceof FBManagedConnection && this.dbHandle.equals(((FBManagedConnection)res).dbHandle);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        try {
            return this.mcf.notifyPrepare(this, xid);
        }
        catch (GDSException ge) {
            throw new FBXAException(-3, ge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int internalPrepare(Xid xid) throws FBXAException, GDSException {
        AbstractIscTrHandle committingTr;
        if (log != null) {
            log.trace("prepare called: " + xid);
        }
        if ((committingTr = (AbstractIscTrHandle)this.xidMap.get(xid)) == null) {
            throw new FBXAException("Prepare called with unknown transaction", -4);
        }
        if (committingTr == this.gdsHelper.getCurrentTrHandle()) {
            throw new FBXAException("Prepare called with non-ended xid", -6);
        }
        try {
            FBXid fbxid = xid instanceof FBXid ? (FBXid)xid : new FBXid(xid);
            byte[] message = fbxid.toBytes();
            this.gdsHelper.prepareTransaction(committingTr, message);
        }
        catch (GDSException ge) {
            try {
                this.gdsHelper.rollbackTransaction(committingTr);
            }
            catch (GDSException ge2) {
                if (log != null) {
                    log.debug("Exception rolling back failed tx: ", ge2);
                }
            }
            finally {
                this.xidMap.remove(xid);
            }
            if (log != null) {
                log.warn("error in prepare", ge);
            }
            throw ge;
        }
        this.preparedXid.add(xid);
        return 0;
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        if (flags != 0x1000000 && flags != 0x800000 && flags != 0 && flags != 0x1800000) {
            throw new FBXAException("flag not allowed in this context: " + flags + ", valid flags are TMSTARTRSCAN, TMENDRSCAN, TMNOFLAGS, TMSTARTRSCAN|TMENDRSCAN", -6);
        }
        try {
            ArrayList<FBXid> xids = new ArrayList<FBXid>();
            AbstractIscTrHandle trHandle2 = (AbstractIscTrHandle)this.gds.createIscTrHandle();
            this.gds.iscStartTransaction(trHandle2, this.gdsHelper.getCurrentDbHandle(), this.tpb.getTransactionParameterBuffer());
            AbstractIscStmtHandle stmtHandle2 = (AbstractIscStmtHandle)this.gds.createIscStmtHandle();
            this.gds.iscDsqlAllocateStatement(this.gdsHelper.getCurrentDbHandle(), stmtHandle2);
            GDSHelper gdsHelper2 = new GDSHelper(this.gds, this.gdsHelper.getDatabaseParameterBuffer(), this.gdsHelper.getCurrentDbHandle(), null);
            gdsHelper2.setCurrentTrHandle(trHandle2);
            gdsHelper2.prepareStatement(stmtHandle2, RECOVERY_QUERY, false);
            gdsHelper2.executeStatement(stmtHandle2, false);
            gdsHelper2.fetch(stmtHandle2, 10);
            DataProvider dataProvider0 = new DataProvider(stmtHandle2, 0);
            DataProvider dataProvider1 = new DataProvider(stmtHandle2, 1);
            FBField field0 = FBField.createField(stmtHandle2.getOutSqlda().sqlvar[0], dataProvider0, gdsHelper2, false);
            FBField field1 = FBField.createField(stmtHandle2.getOutSqlda().sqlvar[1], dataProvider1, gdsHelper2, false);
            field0.setConnection(gdsHelper2);
            field1.setConnection(gdsHelper2);
            int row = 0;
            while (row < stmtHandle2.getRows().length) {
                block9: {
                    if (stmtHandle2.getRows()[row] == null) {
                        ++row;
                        continue;
                    }
                    dataProvider0.setRow(row);
                    dataProvider1.setRow(row);
                    long inLimboTxId = field0.getLong();
                    byte[] inLimboMessage = field1.getBytes();
                    try {
                        FBXid xid = new FBXid(new ByteArrayInputStream(inLimboMessage), inLimboTxId);
                        xids.add(xid);
                    }
                    catch (FBIncorrectXidException ex) {
                        if (log == null) break block9;
                        log.warn("ignoring XID stored with invalid format in RDB$TRANSACTIONS for RDB$TRANSACTION_ID=" + inLimboTxId);
                    }
                }
                ++row;
            }
            gdsHelper2.closeStatement(stmtHandle2, true);
            this.gds.iscCommitTransaction(trHandle2);
            return xids.toArray(new FBXid[xids.size()]);
        }
        catch (GDSException ex) {
            throw new FBXAException("can't perform query to fetch xids", -7, ex);
        }
        catch (SQLException sqle) {
            throw new FBXAException("can't perform query to fetch xids", -7, sqle);
        }
        catch (ResourceException re) {
            throw new FBXAException("can't perform query to fetch xids", -7, re);
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            this.mcf.notifyRollback(this, xid);
        }
        catch (GDSException ge) {
            throw new FBXAException(ge.getXAErrorCode(), ge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalRollback(Xid xid) throws XAException, GDSException {
        AbstractIscTrHandle committingTr;
        if (log != null) {
            log.trace("rollback called: " + xid);
        }
        if ((committingTr = (AbstractIscTrHandle)this.xidMap.get(xid)) == null) {
            throw new FBXAException("Rollback called with unknown transaction: " + xid);
        }
        if (committingTr == this.gdsHelper.getCurrentTrHandle()) {
            throw new FBXAException("Rollback called with non-ended xid", -6);
        }
        try {
            committingTr.forgetResultSets();
            try {
                this.gdsHelper.rollbackTransaction(committingTr);
            }
            finally {
                this.xidMap.remove(xid);
                this.preparedXid.remove(xid);
            }
        }
        catch (GDSException ge) {
            if (log != null) {
                log.debug("Exception in rollback", ge);
            }
            ge.setXAErrorCode(-3);
            throw ge;
        }
    }

    @Override
    public boolean setTransactionTimeout(int timeout) throws XAException {
        this.timeout = timeout;
        return true;
    }

    public boolean inDistributedTransaction() {
        return this.inDistributedTransaction;
    }

    @Override
    public void start(Xid id, int flags) throws XAException {
        if (flags != 0 && flags != 0x200000 && flags != 0x8000000) {
            throw new FBXAException("flag not allowed in this context: " + flags + ", valid flags are TMNOFLAGS, TMJOIN, TMRESUME", -6);
        }
        if (flags == 0x200000) {
            throw new FBXAException("Joining two transactions is not supported", -7);
        }
        try {
            this.setTransactionIsolation(this.mcf.getDefaultTransactionIsolation());
            this.internalStart(id, flags);
            this.mcf.notifyStart(this, id);
            this.inDistributedTransaction = true;
            this.setManagedEnvironment(this.isManagedEnvironment());
        }
        catch (GDSException ge) {
            throw new FBXAException(ge.getXAErrorCode());
        }
        catch (ResourceException ex) {
            throw new FBXAException(-3, ex);
        }
    }

    public void internalStart(Xid id, int flags) throws XAException, GDSException {
        if (log != null) {
            log.trace("start called: " + id);
        }
        if (this.gdsHelper.getCurrentTrHandle() != null) {
            throw new FBXAException("Transaction already started", -6);
        }
        this.findIscTrHandle(id, flags);
    }

    public void close(AbstractConnection c) {
        c.setManagedConnection(null);
        this.connectionHandles.remove(c);
        ConnectionEvent ce = new ConnectionEvent(this, 1, null);
        ce.setConnectionHandle(c);
        this.notify(connectionClosedNotifier, ce);
    }

    public FBConnectionRequestInfo getConnectionRequestInfo() {
        return this.cri;
    }

    public TransactionParameterBuffer getTransactionParameters() {
        return this.tpb.getTransactionParameterBuffer();
    }

    public void setTransactionParameters(TransactionParameterBuffer transactionParameters) {
        this.tpb.setTransactionParameterBuffer(transactionParameters);
    }

    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        return this.mcf.getTransactionParameters(isolation);
    }

    public void setTransactionParameters(int isolation, TransactionParameterBuffer transactionParams) {
        this.mcf.setTransactionParameters(isolation, transactionParams);
    }

    private void findIscTrHandle(Xid xid, int flags) throws GDSException, XAException {
        this.gdsHelper.setCurrentTrHandle(null);
        if (flags == 0x8000000) {
            AbstractIscTrHandle trHandle = (AbstractIscTrHandle)this.xidMap.get(xid);
            if (trHandle == null) {
                throw new FBXAException("You are trying to resume a transaction that is not attached to this XAResource", -5);
            }
            this.gdsHelper.setCurrentTrHandle(trHandle);
            return;
        }
        for (Xid knownXid : this.xidMap.keySet()) {
            boolean sameFormatId = knownXid.getFormatId() == xid.getFormatId();
            boolean sameGtrid = Arrays.equals(knownXid.getGlobalTransactionId(), xid.getGlobalTransactionId());
            boolean sameBqual = Arrays.equals(knownXid.getBranchQualifier(), xid.getBranchQualifier());
            if (!sameFormatId || !sameGtrid || !sameBqual) continue;
            throw new FBXAException("A transaction with the same XID has already been started", -8);
        }
        AbstractIscTrHandle trHandle = this.gdsHelper.startTransaction(this.tpb.getTransactionParameterBuffer());
        this.xidMap.put(xid, trHandle);
    }

    void notify(CELNotifier notifier, ConnectionEvent ce) {
        if (this.connectionEventListeners.size() == 0) {
            return;
        }
        if (this.connectionEventListeners.size() == 1) {
            ConnectionEventListener cel = (ConnectionEventListener)this.connectionEventListeners.get(0);
            notifier.notify(cel, ce);
            return;
        }
        ArrayList cels = (ArrayList)this.connectionEventListeners.clone();
        Iterator i = cels.iterator();
        while (i.hasNext()) {
            notifier.notify((ConnectionEventListener)i.next(), ce);
        }
    }

    boolean matches(Subject subj, ConnectionRequestInfo cri) {
        if (cri == null) {
            return true;
        }
        if (!(cri instanceof FBConnectionRequestInfo)) {
            return false;
        }
        try {
            return this.cri.equals(this.getCombinedConnectionRequestInfo(subj, (FBConnectionRequestInfo)cri));
        }
        catch (ResourceException re) {
            return false;
        }
    }

    public int getTransactionIsolation() throws ResourceException {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(int isolation) throws ResourceException {
        this.transactionIsolation = isolation;
        this.tpb = this.mcf.getTpb(isolation);
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    public void setReadOnly(boolean readOnly) {
        this.tpb.setReadOnly(readOnly);
    }

    public boolean isReadOnly() {
        return this.tpb.isReadOnly();
    }

    static interface CELNotifier {
        public void notify(ConnectionEventListener var1, ConnectionEvent var2);
    }

    private static class DataProvider
    implements FieldDataProvider {
        private AbstractIscStmtHandle stmtHandle;
        private int fieldPos;
        private int row;

        private DataProvider(AbstractIscStmtHandle stmtHandle, int fieldPos) {
            this.stmtHandle = stmtHandle;
            this.fieldPos = fieldPos;
        }

        public void setRow(int row) {
            this.row = row;
        }

        @Override
        public byte[] getFieldData() {
            return this.stmtHandle.getRows()[this.row][this.fieldPos];
        }

        @Override
        public void setFieldData(byte[] data) {
            throw new UnsupportedOperationException();
        }
    }
}

