/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPClientHome;
import org.jkiss.dbeaver.model.connection.DBPClientManager;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class SQLServerDataSourceProvider
extends JDBCDataSourceProvider
implements DBPClientManager {
    private static Map<String, String> connectionsProps = new HashMap<String, String>();

    public static Map<String, String> getConnectionsProps() {
        return connectionsProps;
    }

    public long getFeatures() {
        return 3L;
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        StringBuilder url = new StringBuilder();
        boolean isJtds = SQLServerUtils.isDriverJtds(driver);
        boolean isSqlServer = SQLServerUtils.isDriverSqlServer(driver);
        if (isSqlServer) {
            if (isJtds) {
                url.append("jdbc:jtds:sqlserver://");
            } else {
                url.append("jdbc:sqlserver://");
            }
            url.append(connectionInfo.getHostName());
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                url.append(":").append(connectionInfo.getHostPort());
            }
            if (isJtds) {
                if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
                    url.append("/").append(connectionInfo.getDatabaseName());
                }
            } else {
                url.append(";");
                if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
                    url.append("databaseName=").append(connectionInfo.getDatabaseName());
                }
            }
        } else if (isJtds) {
            url.append("jdbc:jtds:sybase://");
            url.append(connectionInfo.getHostName());
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                url.append(":").append(connectionInfo.getHostPort());
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
                url.append("/").append(connectionInfo.getDatabaseName());
            }
        } else {
            url.append("jdbc:sybase:Tds:");
            url.append(connectionInfo.getHostName());
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                url.append(":").append(connectionInfo.getHostPort());
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
                url.append("?ServiceName=").append(connectionInfo.getDatabaseName());
            }
        }
        return url.toString();
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new SQLServerDataSource(monitor, container);
    }

    public Collection<String> findClientHomeIds() {
        return Collections.emptyList();
    }

    public String getDefaultClientHomeId() {
        return null;
    }

    public DBPClientHome getClientHome(String homeId) {
        return null;
    }
}

