/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.ide.core;

import java.nio.file.Path;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.runtime.ide.core.DBeaverIDECore;
import org.jkiss.dbeaver.runtime.internal.ide.core.CreateLinkedFilesRunnable;
import org.jkiss.dbeaver.runtime.internal.ide.core.CreateLinkedFoldersRunnable;

public class WorkspaceResources {
    public static IStatus createLinkedFiles(IContainer container, IProgressMonitor monitor, Path ... paths) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        CreateLinkedFilesRunnable action = new CreateLinkedFilesRunnable(container, paths);
        try {
            workspace.run((ICoreRunnable)action, monitor);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (Throwable e) {
            String message = action.composeErrorMessage((IResource)container, paths);
            return DBeaverIDECore.createError(message, e);
        }
        return Status.OK_STATUS;
    }

    public static IStatus createLinkedFolders(IContainer container, IProgressMonitor monitor, Path ... paths) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        CreateLinkedFoldersRunnable action = new CreateLinkedFoldersRunnable(container, paths);
        try {
            workspace.run((ICoreRunnable)action, monitor);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (Throwable e) {
            String message = action.composeErrorMessage((IResource)container, paths);
            return DBeaverIDECore.createError(message, e);
        }
        return Status.OK_STATUS;
    }
}

