/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.part;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.part.AttributePart;
import org.jkiss.dbeaver.ext.erd.part.EntityPart;
import org.jkiss.dbeaver.ext.erd.part.PropertyAwareConnectionPart;
import org.jkiss.dbeaver.ext.erd.policy.AssociationBendEditPolicy;
import org.jkiss.dbeaver.ext.erd.policy.AssociationEditPolicy;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.utils.CommonUtils;

public class AssociationPart
extends PropertyAwareConnectionPart {
    public ERDAssociation getAssociation() {
        return (ERDAssociation)this.getModel();
    }

    @Override
    public void activate() {
        super.activate();
    }

    @Override
    public void deactivate() {
        super.deactivate();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new AssociationBendEditPolicy());
        if (this.isEditEnabled()) {
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new AssociationEditPolicy());
        }
    }

    protected IFigure createFigure() {
        ERDAssociation association = (ERDAssociation)this.getModel();
        PolylineConnection conn = (PolylineConnection)super.createFigure();
        if (((DBSEntityAssociation)association.getObject()).getConstraintType() == DBSEntityConstraintType.INHERITANCE) {
            PolygonDecoration srcDec = new PolygonDecoration();
            srcDec.setTemplate(PolygonDecoration.TRIANGLE_TIP);
            srcDec.setFill(true);
            srcDec.setBackgroundColor(this.getParent().getViewer().getControl().getBackground());
            srcDec.setScale(10.0, 6.0);
            conn.setSourceDecoration((RotatableDecoration)srcDec);
        }
        if (((DBSEntityAssociation)association.getObject()).getConstraintType() == DBSEntityConstraintType.FOREIGN_KEY) {
            CircleDecoration targetDecor = new CircleDecoration();
            targetDecor.setRadius(3);
            targetDecor.setFill(true);
            targetDecor.setBackgroundColor(this.getParent().getViewer().getControl().getForeground());
            conn.setTargetDecoration((RotatableDecoration)targetDecor);
            if (!association.isIdentifying()) {
                RhombusDecoration sourceDecor = new RhombusDecoration();
                sourceDecor.setBackgroundColor(this.getParent().getViewer().getControl().getBackground());
                conn.setSourceDecoration((RotatableDecoration)sourceDecor);
            }
        }
        if (!association.isIdentifying() || association.isLogical()) {
            conn.setLineStyle(6);
            conn.setLineDash(new float[]{5.0f});
        }
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        conn.setConnectionRouter(cLayer.getConnectionRouter());
        if (!CommonUtils.isEmpty(association.getInitBends())) {
            ArrayList<AbsoluteBendpoint> connBends = new ArrayList<AbsoluteBendpoint>();
            for (Point bend : association.getInitBends()) {
                connBends.add(new AbsoluteBendpoint(bend.x, bend.y));
            }
            conn.setRoutingConstraint(connBends);
        } else if (association.getPrimaryKeyEntity() == association.getForeignKeyEntity()) {
            IFigure entityFigure = ((GraphicalEditPart)this.getSource()).getFigure();
            Dimension figureSize = entityFigure.getMinimumSize();
            int entityWidth = figureSize.width;
            int entityHeight = figureSize.height;
            ArrayList<RelativeBendpoint> bends = new ArrayList<RelativeBendpoint>();
            RelativeBendpoint bp1 = new RelativeBendpoint((Connection)conn);
            bp1.setRelativeDimensions(new Dimension(entityWidth, entityHeight / 2), new Dimension(entityWidth / 2, entityHeight / 2));
            bends.add(bp1);
            RelativeBendpoint bp2 = new RelativeBendpoint((Connection)conn);
            bp2.setRelativeDimensions(new Dimension(-entityWidth, entityHeight / 2), new Dimension(entityWidth, entityHeight));
            bends.add(bp2);
            conn.setRoutingConstraint(bends);
        }
        Label toolTip = new Label(String.valueOf(((DBSEntityAssociation)this.getAssociation().getObject()).getName()) + " [" + ((DBSEntityAssociation)this.getAssociation().getObject()).getConstraintType().getName() + "]");
        toolTip.setIcon(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOREIGN_KEY));
        conn.setToolTip((IFigure)toolTip);
        return conn;
    }

    public void setSelected(int value) {
        super.setSelected(value);
        if (value != 0) {
            ((PolylineConnection)this.getFigure()).setLineWidth(2);
        } else {
            ((PolylineConnection)this.getFigure()).setLineWidth(1);
        }
        if (this.getSource() == null || this.getTarget() == null) {
            return;
        }
        DBSEntityAssociation association = (DBSEntityAssociation)this.getAssociation().getObject();
        if (association instanceof DBSEntityReferrer && association.getReferencedConstraint() instanceof DBSEntityReferrer) {
            List<AttributePart> sourceAttributes = this.getEntityAttributes((EntityPart)this.getSource(), DBUtils.getEntityAttributes((DBRProgressMonitor)new VoidProgressMonitor(), (DBSEntityReferrer)((DBSEntityReferrer)association.getReferencedConstraint())));
            List<AttributePart> targetAttributes = this.getEntityAttributes((EntityPart)this.getTarget(), DBUtils.getEntityAttributes((DBRProgressMonitor)new VoidProgressMonitor(), (DBSEntityReferrer)((DBSEntityReferrer)association)));
            Color columnColor = value != 0 ? Display.getDefault().getSystemColor(3) : this.getViewer().getControl().getForeground();
            for (AttributePart attr : sourceAttributes) {
                attr.getFigure().setForegroundColor(columnColor);
            }
            for (AttributePart attr : targetAttributes) {
                attr.getFigure().setForegroundColor(columnColor);
            }
        }
    }

    private List<AttributePart> getEntityAttributes(EntityPart source, Collection<? extends DBSEntityAttribute> columns) {
        ArrayList<AttributePart> erdColumns = new ArrayList<AttributePart>(source.getChildren());
        Iterator iter = erdColumns.iterator();
        while (iter.hasNext()) {
            if (columns.contains(((AttributePart)iter.next()).getAttribute().getObject())) continue;
            iter.remove();
        }
        return erdColumns;
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            this.getAssociation().openEditor();
        }
    }

    public void addBendpoint(int bendpointIndex, Point location) {
        AbsoluteBendpoint bendpoint = new AbsoluteBendpoint(location);
        List<Bendpoint> bendpoints = this.getBendpointsCopy();
        bendpoints.add(bendpointIndex, (Bendpoint)bendpoint);
        this.updateBendpoints(bendpoints);
    }

    public void removeBendpoint(int bendpointIndex) {
        List<Bendpoint> bendpoints = this.getBendpointsCopy();
        if (bendpointIndex < bendpoints.size()) {
            bendpoints.remove(bendpointIndex);
            this.updateBendpoints(bendpoints);
        }
    }

    public void moveBendpoint(int bendpointIndex, Point location) {
        AbsoluteBendpoint bendpoint = new AbsoluteBendpoint(location);
        List<Bendpoint> bendpoints = this.getBendpointsCopy();
        if (bendpointIndex < bendpoints.size()) {
            bendpoints.set(bendpointIndex, (Bendpoint)bendpoint);
            this.updateBendpoints(bendpoints);
        }
    }

    public List<Bendpoint> getBendpoints() {
        Object constraint = this.getConnectionFigure().getRoutingConstraint();
        if (constraint instanceof List) {
            return (List)constraint;
        }
        return Collections.emptyList();
    }

    private List<Bendpoint> getBendpointsCopy() {
        Object constraint = this.getConnectionFigure().getRoutingConstraint();
        if (constraint instanceof List) {
            List curList = (List)constraint;
            return new ArrayList<Bendpoint>(curList);
        }
        return new ArrayList<Bendpoint>();
    }

    private void updateBendpoints(List<Bendpoint> bendpoints) {
        this.getConnectionFigure().setRoutingConstraint(bendpoints);
    }

    public String toString() {
        return String.valueOf(((DBSEntityAssociation)this.getAssociation().getObject()).getConstraintType().getName()) + " " + ((DBSEntityAssociation)this.getAssociation().getObject()).getName();
    }

    public static class CircleDecoration
    extends Ellipse
    implements RotatableDecoration {
        private int radius = 5;
        private Point location = new Point();

        public void setRadius(int radius) {
            this.radius = radius;
        }

        public void setLocation(Point p) {
            this.location = p;
            Rectangle bounds = new Rectangle(this.location.x - this.radius, this.location.y - this.radius, this.radius * 2, this.radius * 2);
            this.setBounds(bounds);
        }

        public void setReferencePoint(Point p) {
            double d = Math.sqrt(Math.pow(this.location.x - p.x, 2.0) + Math.pow(this.location.y - p.y, 2.0));
            if (d < (double)this.radius) {
                return;
            }
            double k = (d - (double)this.radius) / d;
            double longx = Math.abs(p.x - this.location.x);
            double longy = Math.abs(p.y - this.location.y);
            double shortx = k * longx;
            double shorty = k * longy;
            int rx = this.location.x < p.x ? p.x - (int)shortx : p.x + (int)shortx;
            int ry = this.location.y > p.y ? p.y + (int)shorty : p.y - (int)shorty;
            this.setBounds(new Rectangle(rx - this.radius, ry - this.radius, (int)((double)this.radius * 2.5), (int)((double)this.radius * 2.5)));
        }
    }

    public static class RhombusDecoration
    extends PolygonDecoration {
        private static PointList GEOMETRY = new PointList();

        static {
            GEOMETRY.addPoint(0, 0);
            GEOMETRY.addPoint(-1, 1);
            GEOMETRY.addPoint(-2, 0);
            GEOMETRY.addPoint(-1, -1);
        }

        public RhombusDecoration() {
            this.setTemplate(GEOMETRY);
            this.setFill(true);
            this.setScale(5.0, 5.0);
        }
    }
}

