/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.model;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.erd.editor.ERDAttributeStyle;
import org.jkiss.dbeaver.ext.erd.model.ERDObject;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.utils.CommonUtils;

public class ERDEntityAttribute
extends ERDObject<DBSEntityAttribute> {
    private final EntityDiagram diagram;
    private boolean inPrimaryKey;
    private boolean inForeignKey;

    public ERDEntityAttribute(EntityDiagram diagram, DBSEntityAttribute attribute, boolean inPrimaryKey) {
        super(attribute);
        this.diagram = diagram;
        this.inPrimaryKey = inPrimaryKey;
    }

    public String getLabelText() {
        String comment;
        String text = this.diagram.hasAttributeStyle(ERDAttributeStyle.TYPES) ? String.valueOf(((DBSEntityAttribute)this.object).getName()) + ": " + ((DBSEntityAttribute)this.object).getFullTypeName() : ((DBSEntityAttribute)this.object).getName();
        if (this.diagram.hasAttributeStyle(ERDAttributeStyle.COMMENTS) && !CommonUtils.isEmpty((String)(comment = ((DBSEntityAttribute)this.object).getDescription()))) {
            text = String.valueOf(text) + " - " + comment;
        }
        return text;
    }

    public DBPImage getLabelImage() {
        if (!this.diagram.hasAttributeStyle(ERDAttributeStyle.ICONS)) {
            return null;
        }
        return DBValueFormatting.getObjectImage((DBPObject)((DBPObject)this.object));
    }

    public boolean isInPrimaryKey() {
        return this.inPrimaryKey;
    }

    public boolean isInForeignKey() {
        return this.inForeignKey;
    }

    public void setInForeignKey(boolean inForeignKey) {
        this.inForeignKey = inForeignKey;
    }

    @NotNull
    public String getName() {
        return ((DBSEntityAttribute)this.getObject()).getName();
    }
}

