/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.ext.erd.directedit.ValidationMessageHandler;
import org.jkiss.dbeaver.ext.erd.editor.ERDEditorAdapter;
import org.jkiss.dbeaver.ext.erd.editor.ERDEditorPart;
import org.jkiss.dbeaver.ext.erd.part.DiagramPart;
import org.jkiss.dbeaver.ext.erd.part.EntityPart;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceUser;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPEventListener;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;

public class ERDGraphicalViewer
extends ScrollingGraphicalViewer
implements IPropertyChangeListener,
DBPEventListener {
    private static final Log log = Log.getLog(ERDGraphicalViewer.class);
    private ERDEditorPart editor;
    private ValidationMessageHandler messageHandler;
    private IThemeManager themeManager;
    private boolean loadContents = false;
    private final Map<DBPDataSourceContainer, DataSourceInfo> usedDataSources = new IdentityHashMap<DBPDataSourceContainer, DataSourceInfo>();

    public ERDGraphicalViewer(ERDEditorPart editor, ValidationMessageHandler messageHandler) {
        this.editor = editor;
        this.messageHandler = messageHandler;
        this.themeManager = editor.getSite().getWorkbenchWindow().getWorkbench().getThemeManager();
        this.themeManager.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public ERDEditorPart getEditor() {
        return this.editor;
    }

    public void setControl(Control control) {
        super.setControl(control);
        if (control != null) {
            ERDEditorAdapter.mapControl(control, this.editor);
            UIUtils.addFocusTracker((IServiceLocator)this.editor.getSite(), (String)"org.jkiss.dbeaver.erd.ERDEditor", (Control)control);
            this.applyThemeSettings();
        }
    }

    protected void handleDispose(DisposeEvent e) {
        if (this.themeManager != null) {
            this.themeManager.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        if (this.getControl() != null) {
            ERDEditorAdapter.unmapControl(this.getControl());
            UIUtils.removeFocusTracker((IServiceLocator)this.editor.getSite(), (Control)this.getControl());
        }
        super.handleDispose(e);
    }

    public ValidationMessageHandler getValidationHandler() {
        return this.messageHandler;
    }

    protected void handleFocusLost(FocusEvent fe) {
        super.handleFocusLost(fe);
        this.messageHandler.reset();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("CHANGE_CURRENT_THEME") || event.getProperty().equals("org.jkiss.dbeaver.erd.diagram.font")) {
            this.applyThemeSettings();
        }
    }

    private void applyThemeSettings() {
        ITheme currentTheme = this.themeManager.getCurrentTheme();
        Font erdFont = currentTheme.getFontRegistry().get("org.jkiss.dbeaver.erd.diagram.font");
        if (erdFont != null) {
            this.getControl().setFont(erdFont);
        }
        this.editor.refreshDiagram(true, false);
    }

    public void setContents(EditPart editpart) {
        this.loadContents = true;
        try {
            super.setContents(editpart);
            if (editpart instanceof DiagramPart) {
                ArrayList<DBSEntity> tables = new ArrayList<DBSEntity>();
                for (Object child : editpart.getChildren()) {
                    if (!(child instanceof EntityPart)) continue;
                    tables.add((DBSEntity)((EntityPart)child).getTable().getObject());
                }
                Collections.sort(tables, DBUtils.nameComparator());
                LinkedHashMap<PaletteDrawer, ArrayList<ToolEntryTable>> toolMap = new LinkedHashMap<PaletteDrawer, ArrayList<ToolEntryTable>>();
                for (DBSEntity dBSEntity : tables) {
                    DBPDataSourceContainer container = dBSEntity.getDataSource().getContainer();
                    PaletteDrawer drawer = this.getContainerPaletteDrawer(container);
                    if (drawer == null) continue;
                    ArrayList<ToolEntryTable> tools = (ArrayList<ToolEntryTable>)toolMap.get(drawer);
                    if (tools == null) {
                        tools = new ArrayList<ToolEntryTable>(tables.size());
                        toolMap.put(drawer, tools);
                    }
                    tools.add(new ToolEntryTable(dBSEntity));
                }
                for (Map.Entry entry : toolMap.entrySet()) {
                    ((PaletteDrawer)entry.getKey()).setChildren((List)entry.getValue());
                }
            }
        }
        finally {
            this.loadContents = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTableActivate(DBSEntity table) {
        PaletteDrawer drawer;
        DBPDataSourceContainer container;
        if (table.getDataSource() != null && (container = table.getDataSource().getContainer()) != null) {
            Map<DBPDataSourceContainer, DataSourceInfo> map = this.usedDataSources;
            synchronized (map) {
                DataSourceInfo dataSourceInfo = this.usedDataSources.get(container);
                if (dataSourceInfo == null) {
                    dataSourceInfo = new DataSourceInfo();
                    this.usedDataSources.put(container, dataSourceInfo);
                    this.acquireContainer(container);
                }
                ++dataSourceInfo.tableCount;
            }
        }
        if (!this.loadContents && (drawer = this.getContainerPaletteDrawer(table.getDataSource().getContainer())) != null) {
            List children = drawer.getChildren();
            int index = 0;
            int i = 0;
            int childrenSize = children.size();
            while (i < childrenSize) {
                Object child = children.get(i);
                if (child instanceof ToolEntryTable && ((ToolEntryTable)((Object)child)).table.getName().compareTo(table.getName()) > 0) {
                    index = i;
                    break;
                }
                ++i;
            }
            drawer.add(index, (PaletteEntry)new ToolEntryTable(table));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTableDeactivate(DBSEntity table) {
        DBPDataSourceContainer container;
        PaletteDrawer drawer = this.getContainerPaletteDrawer(table.getDataSource().getContainer());
        if (drawer != null) {
            for (Object entry : drawer.getChildren()) {
                if (!(entry instanceof ToolEntryTable) || ((ToolEntryTable)((Object)entry)).table != table) continue;
                drawer.remove((PaletteEntry)((ToolEntryTable)((Object)entry)));
                break;
            }
        }
        if (table.getDataSource() != null && (container = table.getDataSource().getContainer()) != null) {
            Map<DBPDataSourceContainer, DataSourceInfo> map = this.usedDataSources;
            synchronized (map) {
                DataSourceInfo dataSourceInfo = this.usedDataSources.get(container);
                if (dataSourceInfo == null) {
                    log.warn((Object)("Datasource '" + container + "' not registered in ERD viewer"));
                } else {
                    --dataSourceInfo.tableCount;
                    if (dataSourceInfo.tableCount <= 0) {
                        this.usedDataSources.remove(container);
                        this.releaseContainer(container);
                    }
                }
            }
        }
    }

    private void acquireContainer(DBPDataSourceContainer container) {
        container.acquire((DBPDataSourceUser)this.editor);
        container.getRegistry().addDataSourceListener((DBPEventListener)this);
        PaletteRoot paletteRoot = this.editor.getPaletteRoot();
        PaletteDrawer dsDrawer = new PaletteDrawer(container.getName(), DBeaverIcons.getImageDescriptor((DBPImage)container.getDriver().getIcon()));
        dsDrawer.setDescription(container.getDescription());
        dsDrawer.setId(container.getId());
        paletteRoot.add((PaletteEntry)dsDrawer);
    }

    private void releaseContainer(DBPDataSourceContainer container) {
        PaletteDrawer drawer = this.getContainerPaletteDrawer(container);
        if (drawer != null) {
            this.editor.getPaletteRoot().remove((PaletteEntry)drawer);
        }
        container.getRegistry().removeDataSourceListener((DBPEventListener)this);
        container.release((DBPDataSourceUser)this.editor);
    }

    PaletteDrawer getContainerPaletteDrawer(DBPDataSourceContainer container) {
        for (Object child : this.editor.getPaletteRoot().getChildren()) {
            if (!(child instanceof PaletteDrawer) || !container.getId().equals(((PaletteDrawer)child).getId())) continue;
            return (PaletteDrawer)child;
        }
        return null;
    }

    public void handleDataSourceEvent(DBPEvent event) {
        if (!(event.getObject() instanceof DBPDataSourceContainer)) {
            return;
        }
        DBPDataSourceContainer container = (DBPDataSourceContainer)event.getObject();
        if (this.usedDataSources.containsKey(container) && event.getAction() == DBPEvent.Action.OBJECT_UPDATE && Boolean.FALSE.equals(event.getEnabled()) && !DBeaverCore.isClosing()) {
            DBeaverUI.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    ERDGraphicalViewer.this.editor.getSite().getWorkbenchWindow().getActivePage().closeEditor((IEditorPart)ERDGraphicalViewer.this.editor, false);
                }
            });
        }
    }

    private static class DataSourceInfo {
        int tableCount = 0;

        private DataSourceInfo() {
        }
    }

    private class ToolEntryTable
    extends ToolEntry {
        private final DBSEntity table;

        public ToolEntryTable(DBSEntity table) {
            super(table.getName(), table.getDescription(), DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_TABLE), null);
            this.setUserModificationPermission(1);
            this.setDescription(DBUtils.getObjectFullName((DBPNamedObject)table, (DBPEvaluationContext)DBPEvaluationContext.UI));
            this.table = table;
        }

        public Tool createTool() {
            return new ToolSelectTable(this.table);
        }
    }

    public static class ToolSelectTable
    extends SelectionTool {
        private final DBSEntity table;

        public ToolSelectTable(DBSEntity table) {
            this.table = table;
        }

        public void activate() {
            DefaultEditDomain editDomain = (DefaultEditDomain)this.getDomain();
            ERDEditorPart editorPart = (ERDEditorPart)editDomain.getEditorPart();
            GraphicalViewer viewer = editorPart.getViewer();
            for (Object child : editorPart.getDiagramPart().getChildren()) {
                if (!(child instanceof EntityPart) || ((EntityPart)child).getTable().getObject() != this.table) continue;
                viewer.reveal((EditPart)child);
                viewer.select((EditPart)child);
                break;
            }
            super.activate();
        }
    }
}

