/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.editor;

import org.eclipse.jface.preference.IPreferenceStore;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.erd.editor.ERDAttributeVisibility;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.utils.CommonUtils;

public enum ERDAttributeStyle {
    ICONS(1, "Icons"),
    TYPES(2, "Data Types"),
    NULLABILITY(4, "Nullability"),
    COMMENTS(8, "Comments");

    private final int value;
    private final String title;
    private static final Log log;

    static {
        log = Log.getLog(ERDAttributeVisibility.class);
    }

    private ERDAttributeStyle(int value, String title) {
        this.value = value;
        this.title = title;
    }

    public int getValue() {
        return this.value;
    }

    public String getTitle() {
        return this.title;
    }

    public static ERDAttributeStyle[] getDefaultStyles(IPreferenceStore store) {
        String attrString = store.getString("erd.attr.styles");
        if (!CommonUtils.isEmpty((String)attrString)) {
            String[] psList = attrString.split(",");
            ERDAttributeStyle[] pList = new ERDAttributeStyle[psList.length];
            int i = 0;
            while (i < psList.length) {
                try {
                    pList[i] = ERDAttributeStyle.valueOf(psList[i]);
                }
                catch (IllegalArgumentException e) {
                    log.warn((Object)e);
                }
                ++i;
            }
            return pList;
        }
        return new ERDAttributeStyle[]{ICONS};
    }

    public static void setDefaultStyles(DBPPreferenceStore store, ERDAttributeStyle[] styles) {
        String stylesString = "";
        ERDAttributeStyle[] eRDAttributeStyleArray = styles;
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            ERDAttributeStyle style = eRDAttributeStyleArray[n2];
            if (!stylesString.isEmpty()) {
                stylesString = String.valueOf(stylesString) + ",";
            }
            stylesString = String.valueOf(stylesString) + style.name();
            ++n2;
        }
        store.setValue("erd.attr.styles", stylesString);
    }
}

