/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDObject;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.ext.erd.part.EntityPart;

public class EntityDeleteCommand
extends Command {
    private EntityPart entityPart;
    private ERDEntity entity;
    private EntityDiagram entityDiagram;
    private int index = -1;
    private List<ERDAssociation> foreignKeyRelationships = new ArrayList<ERDAssociation>();
    private List<ERDAssociation> primaryKeyRelationships = new ArrayList<ERDAssociation>();
    private Rectangle bounds;

    public EntityDeleteCommand(EntityDiagram entityDiagram, EntityPart entityPart, Rectangle originalBounds) {
        this.entityDiagram = entityDiagram;
        this.entityPart = entityPart;
        this.entity = entityPart.getTable();
        this.bounds = originalBounds;
    }

    private void deleteRelationships(ERDEntity t) {
        ERDAssociation r;
        this.foreignKeyRelationships.addAll(t.getForeignKeyRelationships());
        int i = 0;
        while (i < this.foreignKeyRelationships.size()) {
            r = this.foreignKeyRelationships.get(i);
            r.getPrimaryKeyEntity().removePrimaryKeyRelationship(r, true);
            t.removeForeignKeyRelationship(r, true);
            ++i;
        }
        this.primaryKeyRelationships.addAll(t.getPrimaryKeyRelationships());
        i = 0;
        while (i < this.primaryKeyRelationships.size()) {
            r = this.primaryKeyRelationships.get(i);
            r.getForeignKeyEntity().removeForeignKeyRelationship(r, true);
            t.removePrimaryKeyRelationship(r, true);
            ++i;
        }
    }

    public void execute() {
        this.primExecute();
    }

    protected void primExecute() {
        this.entityDiagram.getVisualInfo((ERDObject)this.entity, (boolean)true).initBounds = this.entityPart.getBounds();
        this.deleteRelationships(this.entity);
        this.index = this.entityDiagram.getEntities().indexOf(this.entity);
        this.entityDiagram.removeTable(this.entity, true);
    }

    public void redo() {
        this.primExecute();
    }

    private void restoreRelationships() {
        ERDAssociation r;
        int i = 0;
        while (i < this.foreignKeyRelationships.size()) {
            r = this.foreignKeyRelationships.get(i);
            r.getForeignKeyEntity().addForeignKeyRelationship(r, true);
            r.getPrimaryKeyEntity().addPrimaryKeyRelationship(r, true);
            ++i;
        }
        this.foreignKeyRelationships.clear();
        i = 0;
        while (i < this.primaryKeyRelationships.size()) {
            r = this.primaryKeyRelationships.get(i);
            r.getForeignKeyEntity().addForeignKeyRelationship(r, true);
            r.getPrimaryKeyEntity().addPrimaryKeyRelationship(r, true);
            ++i;
        }
        this.primaryKeyRelationships.clear();
    }

    public void undo() {
        this.entityDiagram.addTable(this.entity, this.index, true);
        this.restoreRelationships();
    }
}

