/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.command;

import java.util.List;
import org.eclipse.gef.commands.Command;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;

public class AssociationReconnectTargetCommand
extends Command {
    protected ERDEntity sourceForeignKey;
    protected ERDEntity targetPrimaryKey;
    protected ERDAssociation relationship;
    protected ERDEntity oldTargetPrimaryKey;

    public boolean canExecute() {
        boolean returnVal = true;
        ERDEntity foreignKeyEntity = this.relationship.getForeignKeyEntity();
        if (foreignKeyEntity.equals(this.targetPrimaryKey)) {
            returnVal = false;
        } else {
            List<ERDAssociation> relationships = this.targetPrimaryKey.getPrimaryKeyRelationships();
            int i = 0;
            while (i < relationships.size()) {
                ERDAssociation relationship = relationships.get(i);
                if (relationship.getForeignKeyEntity().equals(this.sourceForeignKey) && relationship.getPrimaryKeyEntity().equals(this.targetPrimaryKey)) {
                    returnVal = false;
                    break;
                }
                ++i;
            }
        }
        return returnVal;
    }

    public void execute() {
        if (this.targetPrimaryKey != null) {
            this.oldTargetPrimaryKey.removePrimaryKeyRelationship(this.relationship, true);
            this.relationship.setPrimaryKeyEntity(this.targetPrimaryKey);
            this.targetPrimaryKey.addPrimaryKeyRelationship(this.relationship, true);
        }
    }

    public ERDEntity getSourceForeignKey() {
        return this.sourceForeignKey;
    }

    public void setSourceForeignKey(ERDEntity sourceForeignKey) {
        this.sourceForeignKey = sourceForeignKey;
    }

    public ERDEntity getTargetPrimaryKey() {
        return this.targetPrimaryKey;
    }

    public void setTargetPrimaryKey(ERDEntity targetPrimaryKey) {
        this.targetPrimaryKey = targetPrimaryKey;
    }

    public ERDAssociation getRelationship() {
        return this.relationship;
    }

    public void setRelationship(ERDAssociation relationship) {
        this.relationship = relationship;
        this.oldTargetPrimaryKey = relationship.getPrimaryKeyEntity();
        this.sourceForeignKey = relationship.getForeignKeyEntity();
    }

    public void undo() {
        this.targetPrimaryKey.removePrimaryKeyRelationship(this.relationship, true);
        this.relationship.setPrimaryKeyEntity(this.oldTargetPrimaryKey);
        this.oldTargetPrimaryKey.addPrimaryKeyRelationship(this.relationship, true);
    }
}

