/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.command;

import java.util.List;
import org.eclipse.gef.commands.Command;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;

public class AssociationCreateCommand
extends Command {
    protected ERDAssociation association;
    protected ERDEntity foreignEntity;
    protected ERDEntity primaryEntity;

    public boolean canExecute() {
        boolean returnValue = true;
        if (this.foreignEntity.equals(this.primaryEntity)) {
            returnValue = false;
        } else {
            if (this.primaryEntity == null) {
                return false;
            }
            List<ERDAssociation> relationships = this.primaryEntity.getPrimaryKeyRelationships();
            int i = 0;
            while (i < relationships.size()) {
                ERDAssociation currentRelationship = relationships.get(i);
                if (currentRelationship.getForeignKeyEntity().equals(this.foreignEntity)) {
                    returnValue = false;
                    break;
                }
                ++i;
            }
        }
        return returnValue;
    }

    public void execute() {
        this.association = new ERDAssociation(this.foreignEntity, this.primaryEntity, true);
    }

    public ERDEntity getForeignEntity() {
        return this.foreignEntity;
    }

    public ERDEntity getPrimaryEntity() {
        return this.primaryEntity;
    }

    public ERDAssociation getAssociation() {
        return this.association;
    }

    public void redo() {
        this.foreignEntity.addForeignKeyRelationship(this.association, true);
        this.primaryEntity.addPrimaryKeyRelationship(this.association, true);
    }

    public void setForeignEntity(ERDEntity foreignEntity) {
        this.foreignEntity = foreignEntity;
    }

    public void setPrimaryEntity(ERDEntity primaryEntity) {
        this.primaryEntity = primaryEntity;
    }

    public void setAssociation(ERDAssociation association) {
        this.association = association;
    }

    public void undo() {
        this.foreignEntity.removeForeignKeyRelationship(this.association, true);
        this.primaryEntity.removePrimaryKeyRelationship(this.association, true);
    }
}

