/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.jkiss.utils.SecurityUtils;

public final class IOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 16384;

    public static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void fastCopy(InputStream src, OutputStream dest) throws IOException {
        IOUtils.fastCopy(src, dest, 16384);
    }

    public static void fastCopy(InputStream src, OutputStream dest, int bufferSize) throws IOException {
        ReadableByteChannel inputChannel = Channels.newChannel(src);
        WritableByteChannel outputChannel = Channels.newChannel(dest);
        IOUtils.fastCopy(inputChannel, outputChannel, bufferSize);
    }

    public static void fastCopy(ReadableByteChannel src, WritableByteChannel dest, int bufferSize) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(bufferSize);
        while (src.read(buffer) != -1) {
            buffer.flip();
            dest.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtils.copyStream(inputStream, outputStream, 16384);
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        try {
            byte[] writeBuffer = new byte[bufferSize];
            int br = inputStream.read(writeBuffer);
            while (br != -1) {
                outputStream.write(writeBuffer, 0, br);
                br = inputStream.read(writeBuffer);
            }
            outputStream.flush();
        }
        finally {
            inputStream.close();
        }
    }

    public static void copyStreamPortion(InputStream inputStream, OutputStream outputStream, int portionSize, int bufferSize) throws IOException {
        if (bufferSize > portionSize) {
            bufferSize = portionSize;
        }
        byte[] writeBuffer = new byte[bufferSize];
        int totalRead = 0;
        while (totalRead < portionSize) {
            int bytesToRead = bufferSize;
            if (bytesToRead > portionSize - totalRead) {
                bytesToRead = portionSize - totalRead;
            }
            int bytesRead = inputStream.read(writeBuffer, 0, bytesToRead);
            outputStream.write(writeBuffer, 0, bytesRead);
            totalRead += bytesRead;
        }
        outputStream.flush();
    }

    /*
     * Exception decompiling
     */
    public static String toString(File file, String encoding) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void copyText(Reader reader, Writer writer, int bufferSize) throws IOException {
        char[] writeBuffer = new char[bufferSize];
        int br = reader.read(writeBuffer);
        while (br != -1) {
            writer.write(writeBuffer, 0, br);
            br = reader.read(writeBuffer);
        }
        writer.flush();
    }

    public static void copyText(Reader reader, Writer writer) throws IOException {
        IOUtils.copyText(reader, writer, 16384);
    }

    public static byte[] readFileToBuffer(File file) throws IOException {
        byte[] buffer = new byte[(int)file.length()];
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream is = new FileInputStream(file);){
            IOUtils.readStreamToBuffer(is, buffer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return buffer;
    }

    public static int readStreamToBuffer(InputStream inputStream, byte[] buffer) throws IOException {
        int totalRead = 0;
        while (totalRead != buffer.length) {
            int br = inputStream.read(buffer, totalRead, buffer.length - totalRead);
            if (br == -1) break;
            totalRead += br;
        }
        return totalRead;
    }

    public static String readLine(InputStream input) throws IOException {
        StringBuilder linebuf = new StringBuilder();
        int b = input.read();
        while (b != 10) {
            if (b == -1) {
                if (linebuf.length() != 0) break;
                return null;
            }
            if (b != 13) {
                linebuf.append((char)b);
            }
            b = input.read();
        }
        return linebuf.toString();
    }

    public static String readFullLine(InputStream input) throws IOException {
        StringBuilder linebuf = new StringBuilder();
        int b = input.read();
        while (true) {
            if (b == -1) {
                if (linebuf.length() != 0) break;
                return null;
            }
            linebuf.append((char)b);
            if (b == 10) break;
            b = input.read();
        }
        return linebuf.toString();
    }

    public static int findFreePort(int minPort, int maxPort) {
        int portRange = Math.abs(maxPort - minPort);
        while (true) {
            int portNum = minPort + SecurityUtils.getRandom().nextInt(portRange);
            try {
                ServerSocket socket = new ServerSocket(portNum);
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return portNum;
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    public static String readToString(Reader is) throws IOException {
        int count;
        StringBuilder result = new StringBuilder(4000);
        char[] buffer = new char[4000];
        while ((count = is.read(buffer)) > 0) {
            result.append(buffer, 0, count);
        }
        return result.toString();
    }
}

