/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui.editors;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLSourceViewer;

public class PostgreSourceViewEditor
extends SQLSourceViewer<PostgreScriptObject> {
    private boolean omitHeader = false;
    private Button omitHeaderCheck;

    protected boolean isReadOnly() {
        return false;
    }

    protected void setSourceText(DBRProgressMonitor monitor, String sourceText) {
        this.getEditorInput().getPropertySource().setPropertyValue(monitor, (Object)"objectDefinitionText", (Object)sourceText);
    }

    protected void contributeEditorCommands(IContributionManager contributionManager) {
        super.contributeEditorCommands(contributionManager);
        if (this.getSourceObject() instanceof PostgreProcedure) {
            contributionManager.add((IContributionItem)new Separator());
            contributionManager.add((IContributionItem)new ControlContribution("ProcedureDebugSource"){

                protected Control createControl(Composite parent) {
                    PostgreSourceViewEditor.this.omitHeaderCheck = UIUtils.createCheckbox((Composite)parent, (String)"Omit procedure header", (String)"Show only procedure body without auto-generated header", (boolean)false, (int)0);
                    PostgreSourceViewEditor.this.omitHeaderCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            PostgreSourceViewEditor.this.omitHeader = PostgreSourceViewEditor.this.omitHeaderCheck.getSelection();
                            PostgreSourceViewEditor.this.refreshPart((Object)PostgreSourceViewEditor.this, true);
                        }
                    });
                    return PostgreSourceViewEditor.this.omitHeaderCheck;
                }
            });
        }
    }

    public void setOmitHeader(boolean omitHeader) {
        this.omitHeader = omitHeader;
        this.omitHeaderCheck.setSelection(omitHeader);
        this.refreshPart((Object)this, true);
    }

    protected Map<String, Object> getSourceOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("debugger.source", this.omitHeader);
        options.putAll(super.getSourceOptions());
        return options;
    }
}

