/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui;

import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.postgresql.PostgreActivator;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.ICompositeDialogPage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ClientHomesSelector;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class PostgreConnectionPage
extends ConnectionPageAbstract
implements ICompositeDialogPage {
    private Text hostText;
    private Text portText;
    private Text dbText;
    private Text usernameText;
    private Text passwordText;
    private ClientHomesSelector homesSelector;
    private Button showNonDefault;
    private Button switchDatabaseOnExpand;
    private boolean activated = false;
    private static ImageDescriptor LOGO_IMG = PostgreActivator.getImageDescriptor("icons/postgresql_logo.png");

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite composite) {
        ModifyListener textListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PostgreConnectionPage.this.activated) {
                    PostgreConnectionPage.this.site.updateButtons();
                }
            }
        };
        Composite addrGroup = UIUtils.createPlaceholder((Composite)composite, (int)4);
        GridLayout gl = new GridLayout(4, false);
        addrGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        addrGroup.setLayoutData((Object)gd);
        Label hostLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)PostgreMessages.dialog_setting_connection_host);
        hostLabel.setLayoutData((Object)new GridData(128));
        this.hostText = new Text(addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.hostText.setLayoutData((Object)gd);
        this.hostText.addModifyListener(textListener);
        Label portLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)PostgreMessages.dialog_setting_connection_port);
        gd = new GridData(128);
        portLabel.setLayoutData((Object)gd);
        this.portText = new Text(addrGroup, 2048);
        gd = new GridData(2);
        gd.widthHint = 40;
        this.portText.setLayoutData((Object)gd);
        this.portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.portText.addModifyListener(textListener);
        Label dbLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)PostgreMessages.dialog_setting_connection_database);
        dbLabel.setLayoutData((Object)new GridData(128));
        this.dbText = new Text(addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.dbText.setLayoutData((Object)gd);
        this.dbText.addModifyListener(textListener);
        Label usernameLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)PostgreMessages.dialog_setting_connection_user);
        usernameLabel.setLayoutData((Object)new GridData(128));
        this.usernameText = new Text(addrGroup, 2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.usernameText.setLayoutData((Object)gd);
        this.usernameText.addModifyListener(textListener);
        Label passwordLabel = UIUtils.createControlLabel((Composite)addrGroup, (String)PostgreMessages.dialog_setting_connection_password);
        passwordLabel.setLayoutData((Object)new GridData(128));
        this.passwordText = new Text(addrGroup, 0x400800);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.passwordText.setLayoutData((Object)gd);
        this.passwordText.addModifyListener(textListener);
        Composite buttonsGroup = new Composite(addrGroup, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        buttonsGroup.setLayoutData((Object)gd);
        buttonsGroup.setLayout((Layout)new GridLayout(2, false));
        this.homesSelector = new ClientHomesSelector(buttonsGroup, 0, PostgreMessages.dialog_setting_connection_localClient);
        gd = new GridData(800);
        this.homesSelector.getPanel().setLayoutData((Object)gd);
        Group secureGroup = new Group(addrGroup, 0);
        secureGroup.setText(PostgreMessages.dialog_setting_connection_settings);
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        secureGroup.setLayoutData((Object)gd);
        secureGroup.setLayout((Layout)new GridLayout(2, false));
        this.showNonDefault = UIUtils.createCheckbox((Composite)secureGroup, (String)PostgreMessages.dialog_setting_connection_nondefaultDatabase, (String)PostgreMessages.dialog_setting_connection_nondefaultDatabase_tip, (boolean)true, (int)2);
        this.showNonDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PostgreConnectionPage.this.switchDatabaseOnExpand.setEnabled(PostgreConnectionPage.this.showNonDefault.getSelection());
            }
        });
        this.switchDatabaseOnExpand = UIUtils.createCheckbox((Composite)secureGroup, (String)PostgreMessages.dialog_setting_connection_switchDatabaseOnExpand, (String)PostgreMessages.dialog_setting_connection_switchDatabaseOnExpand_tip, (boolean)true, (int)2);
        this.createDriverPanel(addrGroup);
        this.setControl((Control)addrGroup);
    }

    public boolean isComplete() {
        return this.hostText != null && this.portText != null && !CommonUtils.isEmpty((String)this.hostText.getText()) && !CommonUtils.isEmpty((String)this.portText.getText());
    }

    public void loadSettings() {
        super.loadSettings();
        if (!this.activated) {
            this.setImageDescriptor(LOGO_IMG);
        }
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.hostText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                this.hostText.setText(connectionInfo.getHostName());
            } else {
                this.hostText.setText("localhost");
            }
        }
        if (this.portText != null) {
            if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                this.portText.setText(String.valueOf(connectionInfo.getHostPort()));
            } else if (this.site.getDriver().getDefaultPort() != null) {
                this.portText.setText(this.site.getDriver().getDefaultPort());
            } else {
                this.portText.setText("");
            }
        }
        if (this.dbText != null) {
            String databaseName = connectionInfo.getDatabaseName();
            if (CommonUtils.isEmpty((String)databaseName)) {
                databaseName = this.getSite().isNew() ? "postgres" : "";
            }
            this.dbText.setText(databaseName);
        }
        if (this.usernameText != null) {
            this.usernameText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserName()));
        }
        if (this.passwordText != null) {
            this.passwordText.setText(CommonUtils.notEmpty((String)connectionInfo.getUserPassword()));
        }
        this.homesSelector.populateHomes(this.site.getDriver(), connectionInfo.getClientHomeId());
        this.showNonDefault.setSelection(CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("@dbeaver-show-non-default-db@")));
        this.switchDatabaseOnExpand.setSelection(CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("@dbeaver-switch-db-on-expand@")));
        this.switchDatabaseOnExpand.setEnabled(this.showNonDefault.getSelection());
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.hostText != null) {
            connectionInfo.setHostName(this.hostText.getText().trim());
        }
        if (this.portText != null) {
            connectionInfo.setHostPort(this.portText.getText().trim());
        }
        if (this.dbText != null) {
            connectionInfo.setDatabaseName(this.dbText.getText().trim());
        }
        if (this.usernameText != null) {
            connectionInfo.setUserName(this.usernameText.getText().trim());
        }
        if (this.passwordText != null) {
            connectionInfo.setUserPassword(this.passwordText.getText());
        }
        if (this.homesSelector != null) {
            connectionInfo.setClientHomeId(this.homesSelector.getSelectedHome());
        }
        connectionInfo.setProviderProperty("@dbeaver-show-non-default-db@", String.valueOf(this.showNonDefault.getSelection()));
        connectionInfo.setProviderProperty("@dbeaver-switch-db-on-expand@", String.valueOf(this.switchDatabaseOnExpand.getSelection()));
        super.saveSettings(dataSource);
    }

    public IDialogPage[] getSubPages() {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }
}

