/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools.maintenance;

import java.util.Collection;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.tools.maintenance.TableToolDialog;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tools.IExternalTool;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreToolVacuum
implements IExternalTool {
    public void execute(IWorkbenchWindow window, IWorkbenchPart activePart, Collection<DBSObject> objects) throws DBException {
        List tables = CommonUtils.filterCollection(objects, PostgreTableBase.class);
        if (!tables.isEmpty()) {
            SQLDialog dialog = new SQLDialog(activePart.getSite(), tables);
            dialog.open();
        } else {
            List databases = CommonUtils.filterCollection(objects, PostgreDatabase.class);
            if (!databases.isEmpty()) {
                SQLDialog dialog = new SQLDialog(activePart.getSite(), ((PostgreDatabase)databases.get(0)).getDataSource().getDefaultInstance());
                dialog.open();
            }
        }
    }

    static class SQLDialog
    extends TableToolDialog {
        private Button fullCheck;
        private Button freezeCheck;
        private Button analyzeCheck;
        private Button dpsCheck;

        public SQLDialog(IWorkbenchPartSite partSite, Collection<PostgreTableBase> selectedTables) {
            super(partSite, PostgreMessages.tool_vacuum_title_table, selectedTables);
        }

        public SQLDialog(IWorkbenchPartSite partSite, PostgreDatabase database) {
            super(partSite, PostgreMessages.tool_vacuum_title_database, database);
        }

        protected void generateObjectCommand(List<String> lines, PostgreObject object) {
            String sql = "VACUUM (VERBOSE";
            if (this.fullCheck.getSelection()) {
                sql = String.valueOf(sql) + ",FULL";
            }
            if (this.freezeCheck.getSelection()) {
                sql = String.valueOf(sql) + ",FREEZE";
            }
            if (this.analyzeCheck.getSelection()) {
                sql = String.valueOf(sql) + ",ANALYZE";
            }
            if (this.dpsCheck.getSelection()) {
                sql = String.valueOf(sql) + ",DISABLE_PAGE_SKIPPING";
            }
            sql = String.valueOf(sql) + ")";
            if (object instanceof PostgreTableBase) {
                sql = String.valueOf(sql) + " " + ((PostgreTableBase)object).getFullyQualifiedName(DBPEvaluationContext.DDL);
            }
            lines.add(sql);
        }

        protected void createControls(Composite parent) {
            Group optionsGroup = UIUtils.createControlGroup((Composite)parent, (String)PostgreMessages.tool_vacuum_group_option, (int)1, (int)0, (int)0);
            optionsGroup.setLayoutData((Object)new GridData(768));
            this.fullCheck = UIUtils.createCheckbox((Composite)optionsGroup, (String)"Full", (String)PostgreMessages.tool_vacuum_full_check_tooltip, (boolean)false, (int)0);
            this.fullCheck.addSelectionListener(this.SQL_CHANGE_LISTENER);
            this.freezeCheck = UIUtils.createCheckbox((Composite)optionsGroup, (String)"Freeze", (String)PostgreMessages.tool_vacuum_freeze_check_tooltip, (boolean)false, (int)0);
            this.freezeCheck.addSelectionListener(this.SQL_CHANGE_LISTENER);
            this.analyzeCheck = UIUtils.createCheckbox((Composite)optionsGroup, (String)"Analyze", (String)PostgreMessages.tool_vacuum_analyze_check_tooltip, (boolean)false, (int)0);
            this.analyzeCheck.addSelectionListener(this.SQL_CHANGE_LISTENER);
            this.dpsCheck = UIUtils.createCheckbox((Composite)optionsGroup, (String)"Disable page skipping", (String)PostgreMessages.tool_vacuum_dps_check_tooltip, (boolean)false, (int)0);
            this.dpsCheck.addSelectionListener(this.SQL_CHANGE_LISTENER);
            this.createObjectsSelector(parent);
        }
    }
}

