/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools;

import java.io.File;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreBackupRestoreWizard;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreBackupWizard;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreWizardPageSettings;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

class PostgreBackupWizardPageSettings
extends PostgreWizardPageSettings<PostgreBackupWizard> {
    private Text outputFolderText;
    private Text outputFileText;
    private Combo formatCombo;
    private Combo compressCombo;
    private Combo encodingCombo;
    private Button useInsertsCheck;

    PostgreBackupWizardPageSettings(PostgreBackupWizard wizard) {
        super(wizard, PostgreMessages.wizard_backup_page_setting_title_setting);
        this.setTitle(PostgreMessages.wizard_backup_page_setting_title);
        this.setDescription(PostgreMessages.wizard_backup_page_setting_description);
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && ((PostgreBackupWizard)this.wizard).getOutputFolder() != null;
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        SelectionAdapter changeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PostgreBackupWizardPageSettings.this.updateState();
            }
        };
        Group formatGroup = UIUtils.createControlGroup((Composite)composite, (String)PostgreMessages.wizard_backup_page_setting_group_setting, (int)2, (int)768, (int)0);
        this.formatCombo = UIUtils.createLabelCombo((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_label_format, (int)12);
        this.formatCombo.setLayoutData((Object)new GridData(32));
        PostgreBackupRestoreWizard.ExportFormat[] exportFormatArray = PostgreBackupRestoreWizard.ExportFormat.values();
        int n = exportFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            PostgreBackupRestoreWizard.ExportFormat format = exportFormatArray[n2];
            this.formatCombo.add(format.getTitle());
            ++n2;
        }
        this.formatCombo.select(((PostgreBackupWizard)this.wizard).format.ordinal());
        this.formatCombo.addSelectionListener((SelectionListener)changeListener);
        this.compressCombo = UIUtils.createLabelCombo((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_label_compression, (int)12);
        this.compressCombo.setLayoutData((Object)new GridData(32));
        this.compressCombo.add("");
        int i = 0;
        while (i <= 9) {
            this.compressCombo.add(String.valueOf(i));
            ++i;
        }
        this.compressCombo.select(0);
        this.compressCombo.addSelectionListener((SelectionListener)changeListener);
        UIUtils.createControlLabel((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_label_encoding);
        this.encodingCombo = UIUtils.createEncodingCombo((Composite)formatGroup, null);
        this.encodingCombo.addSelectionListener((SelectionListener)changeListener);
        this.useInsertsCheck = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_checkbox_use_insert, null, (boolean)false, (int)2);
        this.useInsertsCheck.addSelectionListener((SelectionListener)changeListener);
        Group outputGroup = UIUtils.createControlGroup((Composite)composite, (String)PostgreMessages.wizard_backup_page_setting_group_output, (int)2, (int)768, (int)0);
        this.outputFolderText = DialogUtils.createOutputFolderChooser((Composite)outputGroup, (String)PostgreMessages.wizard_backup_page_setting_label_output_folder, e -> this.updateState());
        this.outputFileText = UIUtils.createLabelText((Composite)outputGroup, (String)PostgreMessages.wizard_backup_page_setting_label_file_name_pattern, (String)((PostgreBackupWizard)this.wizard).getOutputFilePattern());
        UIUtils.setContentProposalToolTip((Control)this.outputFileText, (String)PostgreMessages.wizard_backup_page_setting_label_file_name_pattern_output, (String[])new String[]{"host", "database", "table", "date", "timestamp"});
        UIUtils.installContentProposal((Control)this.outputFileText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new SimpleContentProposalProvider(new String[]{GeneralUtils.variablePattern((String)"host"), GeneralUtils.variablePattern((String)"database"), GeneralUtils.variablePattern((String)"table"), GeneralUtils.variablePattern((String)"date"), GeneralUtils.variablePattern((String)"timestamp")}));
        this.outputFileText.addModifyListener(e -> ((PostgreBackupWizard)this.wizard).setOutputFilePattern(this.outputFileText.getText()));
        if (((PostgreBackupWizard)this.wizard).getOutputFolder() != null) {
            this.outputFolderText.setText(((PostgreBackupWizard)this.wizard).getOutputFolder().getAbsolutePath());
        }
        this.createExtraArgsInput((Composite)outputGroup);
        this.createSecurityGroup(composite);
        this.setControl((Control)composite);
    }

    private void updateState() {
        String fileName = this.outputFolderText.getText();
        ((PostgreBackupWizard)this.wizard).setOutputFolder(CommonUtils.isEmpty((String)fileName) ? null : new File(fileName));
        ((PostgreBackupWizard)this.wizard).setOutputFilePattern(this.outputFileText.getText());
        ((PostgreBackupWizard)this.wizard).format = PostgreBackupRestoreWizard.ExportFormat.values()[this.formatCombo.getSelectionIndex()];
        ((PostgreBackupWizard)this.wizard).compression = this.compressCombo.getText();
        ((PostgreBackupWizard)this.wizard).encoding = this.encodingCombo.getText();
        ((PostgreBackupWizard)this.wizard).useInserts = this.useInsertsCheck.getSelection();
        this.getContainer().updateButtons();
    }
}

