/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import org.jkiss.dbeaver.ext.postgresql.model.PostgreSequence;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableReal;

public enum PostgrePrivilegeType {
    ALL(Object.class, false),
    SELECT(PostgreTableBase.class, true),
    INSERT(PostgreTableReal.class, true),
    UPDATE(PostgreTableBase.class, true),
    DELETE(PostgreTableReal.class, true),
    TRUNCATE(PostgreTableReal.class, true),
    REFERENCES(PostgreTableReal.class, true),
    TRIGGER(PostgreTableReal.class, true),
    USAGE(PostgreSequence.class, true),
    UNKNOWN(Object.class, false);

    private final Class<?> targetType;
    private final boolean valid;

    private PostgrePrivilegeType(Class<?> targetType, boolean valid) {
        this.targetType = targetType;
        this.valid = valid;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public boolean isValid() {
        return this.valid;
    }

    public static PostgrePrivilegeType fromString(String type) {
        try {
            return PostgrePrivilegeType.valueOf(type);
        }
        catch (IllegalArgumentException e) {
            return UNKNOWN;
        }
    }
}

