/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeType;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;

public class PostgrePrivilege {
    private String grantor;
    private String grantee;
    private String tableCatalog;
    private String tableSchema;
    private String tableName;
    private PostgrePrivilegeType privilegeType;
    private boolean isGrantable;
    private boolean withHierarchy;

    public PostgrePrivilege(ResultSet dbResult) throws SQLException {
        this.grantor = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"grantor");
        this.grantee = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"grantee");
        this.tableCatalog = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"table_catalog");
        this.tableSchema = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"table_schema");
        this.tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"table_name");
        this.privilegeType = PostgrePrivilegeType.fromString(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"privilege_type"));
        this.isGrantable = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_grantable");
        this.withHierarchy = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"with_hierarchy");
    }

    public PostgrePrivilege(String grantor, String grantee, String tableCatalog, String tableSchema, String tableName, PostgrePrivilegeType privilegeType, boolean isGrantable, boolean withHierarchy) {
        this.grantor = grantor;
        this.grantee = grantee;
        this.tableCatalog = tableCatalog;
        this.tableSchema = tableSchema;
        this.tableName = tableName;
        this.privilegeType = privilegeType;
        this.isGrantable = isGrantable;
        this.withHierarchy = withHierarchy;
    }

    public String getGrantor() {
        return this.grantor;
    }

    public String getGrantee() {
        return this.grantee;
    }

    public String getTableCatalog() {
        return this.tableCatalog;
    }

    public String getTableSchema() {
        return this.tableSchema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public PostgrePrivilegeType getPrivilegeType() {
        return this.privilegeType;
    }

    public boolean isGrantable() {
        return this.isGrantable;
    }

    public boolean isWithHierarchy() {
        return this.withHierarchy;
    }

    public String toString() {
        return this.privilegeType.toString();
    }
}

