/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAccessMethod;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreInformation;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class PostgreOperatorFamily
extends PostgreInformation {
    private long oid;
    private PostgreAccessMethod accessMethod;
    private String name;
    private long namespaceId;
    private long ownerId;

    public PostgreOperatorFamily(PostgreAccessMethod accessMethod, ResultSet dbResult) throws SQLException {
        super(accessMethod.getDatabase());
        this.accessMethod = accessMethod;
        this.loadInfo(dbResult);
    }

    private void loadInfo(ResultSet dbResult) throws SQLException {
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"opfname");
        this.namespaceId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"opfnamespace");
        this.ownerId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"opfowner");
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Property(viewable=true, order=2)
    public long getObjectId() {
        return this.oid;
    }

    @Property(viewable=true, order=3)
    public PostgreSchema getNamespace(DBRProgressMonitor monitor) throws DBException {
        return this.accessMethod.getDatabase().getSchema(monitor, this.namespaceId);
    }

    @Property(viewable=true, order=4)
    public PostgreRole getOwner(DBRProgressMonitor monitor) throws DBException {
        return (PostgreRole)PostgreUtils.getObjectById(monitor, this.accessMethod.getDatabase().roleCache, this.accessMethod.getDatabase(), this.ownerId);
    }
}

