/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreForeignDataWrapper;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreInformation;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class PostgreForeignServer
extends PostgreInformation {
    private long oid;
    private String name;
    private String type;
    private String version;
    private String[] options;
    private long ownerId;
    private long dataWrapperId;

    public PostgreForeignServer(PostgreDatabase database, ResultSet dbResult) throws SQLException {
        super(database);
        this.loadInfo(dbResult);
    }

    private void loadInfo(ResultSet dbResult) throws SQLException {
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"srvname");
        this.ownerId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"srvowner");
        this.dataWrapperId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"srvfdw");
        this.type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"srvtype");
        this.version = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"srvversion");
        this.options = (String[])JDBCUtils.safeGetArray((ResultSet)dbResult, (String)"srvoptions");
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=3)
    public String getType() {
        return this.type;
    }

    @Property(viewable=true, order=4)
    public String getVersion() {
        return this.version;
    }

    @Property(viewable=true, order=5)
    public String[] getOptions() {
        return this.options;
    }

    @Override
    public long getObjectId() {
        return this.oid;
    }

    @Property(viewable=false, order=8)
    public PostgreRole getOwner(DBRProgressMonitor monitor) throws DBException {
        return (PostgreRole)PostgreUtils.getObjectById(monitor, this.getDatabase().roleCache, this.getDatabase(), this.ownerId);
    }

    @Property(viewable=true, order=10)
    public PostgreForeignDataWrapper getForeignDataWrapper(DBRProgressMonitor monitor) throws DBException {
        return (PostgreForeignDataWrapper)PostgreUtils.getObjectById(monitor, this.getDatabase().foreignDataWrapperCache, this.getDatabase(), this.dataWrapperId);
    }
}

