/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreConstants;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.LongKeyMap;

public class PostgreDataTypeCache
extends JDBCObjectCache<PostgreSchema, PostgreDataType> {
    private LongKeyMap<PostgreDataType> dataTypeMap = new LongKeyMap();

    PostgreDataTypeCache() {
        this.setListOrderComparator(DBUtils.nameComparator());
    }

    protected synchronized void loadObjects(DBRProgressMonitor monitor, PostgreSchema postgreSchema) throws DBException {
        super.loadObjects(monitor, (DBSObject)postgreSchema);
        if (postgreSchema.isCatalogSchema()) {
            this.mapDataTypeAliases(PostgreConstants.DATA_TYPE_ALIASES);
            this.mapDataTypeAliases(PostgreConstants.SERIAL_TYPES);
        }
    }

    private void mapDataTypeAliases(Map<String, String> aliases) {
        for (Map.Entry<String, String> aliasMapping : aliases.entrySet()) {
            PostgreDataType realType = (PostgreDataType)this.getCachedObject(aliasMapping.getValue());
            if (realType == null) continue;
            PostgreDataType serialType = new PostgreDataType(realType, aliasMapping.getKey());
            this.cacheObject(serialType);
        }
    }

    public void clearCache() {
        super.clearCache();
        this.dataTypeMap.clear();
    }

    public void removeObject(@NotNull PostgreDataType object, boolean resetFullCache) {
        super.removeObject((DBSObject)object, resetFullCache);
        this.dataTypeMap.remove(object.getObjectId());
    }

    public void cacheObject(@NotNull PostgreDataType object) {
        if (this.getCachedObject(object.getName()) == null) {
            super.cacheObject((DBSObject)object);
            if (!object.isAlias()) {
                this.dataTypeMap.put(object.getObjectId(), (Object)object);
            }
        }
    }

    public void setCache(List<PostgreDataType> postgreDataTypes) {
        super.setCache(postgreDataTypes);
        for (PostgreDataType dt : postgreDataTypes) {
            if (dt.isAlias()) continue;
            this.dataTypeMap.put(dt.getObjectId(), (Object)dt);
        }
    }

    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreSchema owner) throws SQLException {
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT t.oid,t.* \nFROM pg_catalog.pg_type t WHERE typnamespace=?\nORDER by t.oid");
        dbStat.setLong(1, owner.getObjectId());
        return dbStat;
    }

    protected PostgreDataType fetchObject(@NotNull JDBCSession session, @NotNull PostgreSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        return PostgreDataType.readDataType(session, owner, dbResult);
    }

    public PostgreDataType getDataType(long oid) {
        return (PostgreDataType)this.dataTypeMap.get(oid);
    }
}

