/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreViewBase;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.CommonUtils;

public class PostgreViewManager
extends SQLTableManager<PostgreTableBase, PostgreSchema> {
    private static final Class<?>[] CHILD_TYPES = new Class[]{PostgreTableColumn.class};

    public Class<?>[] getChildTypes() {
        return CHILD_TYPES;
    }

    @Nullable
    public DBSObjectCache<PostgreSchema, PostgreTableBase> getObjectsCache(PostgreTableBase object) {
        return ((PostgreSchema)object.getContainer()).tableCache;
    }

    protected void validateObjectProperties(SQLObjectEditor.ObjectChangeCommand command) throws DBException {
        PostgreTableBase object = (PostgreTableBase)command.getObject();
        if (CommonUtils.isEmpty((String)object.getName())) {
            throw new DBException("View name cannot be empty");
        }
        if (CommonUtils.isEmpty((String)((PostgreViewBase)object).getSource())) {
            throw new DBException("View definition cannot be empty");
        }
    }

    protected PostgreViewBase createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, PostgreSchema parent, Object copyFrom) {
        PostgreView newView = new PostgreView(parent);
        try {
            newView.setName(this.getNewChildName(monitor, (DBSObjectContainer)parent, "new_view"));
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        return newView;
    }

    protected void addStructObjectCreateActions(List<DBEPersistAction> actions, SQLStructEditor.StructCreateCommand command, Map<String, Object> options) {
        this.createOrReplaceViewQuery(actions, (PostgreViewBase)command.getObject());
    }

    protected void addObjectModifyActions(List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        this.createOrReplaceViewQuery(actionList, (PostgreViewBase)command.getObject());
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        PostgreViewBase view = (PostgreViewBase)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop view", "DROP " + view.getViewType() + " " + view.getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    protected void createOrReplaceViewQuery(List<DBEPersistAction> actions, PostgreViewBase view) {
        String sql = view.getSource().trim();
        if (!sql.toLowerCase(Locale.ENGLISH).startsWith("create")) {
            sql = "CREATE OR REPLACE VIEW " + DBUtils.getObjectFullName((DBPNamedObject)view, (DBPEvaluationContext)DBPEvaluationContext.DDL) + " AS\n" + sql;
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create view", sql));
    }
}

