/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndex;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeign;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKey;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableInheritance;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableRegular;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableManager;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.CommonUtils;

public class PostgreTableManager
extends SQLTableManager<PostgreTableBase, PostgreSchema>
implements DBEObjectRenamer<PostgreTableBase> {
    private static final Class<?>[] CHILD_TYPES = new Class[]{PostgreTableColumn.class, PostgreTableConstraint.class, PostgreTableForeignKey.class, PostgreIndex.class};

    @Nullable
    public DBSObjectCache<PostgreSchema, PostgreTableBase> getObjectsCache(PostgreTableBase object) {
        return ((PostgreSchema)object.getContainer()).tableCache;
    }

    protected PostgreTable createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, PostgreSchema parent, Object copyFrom) {
        PostgreTableRegular table = new PostgreTableRegular(parent);
        try {
            this.setTableName(monitor, (DBSObjectContainer)parent, table);
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        return table;
    }

    protected void addObjectModifyActions(List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        PostgreTableBase table = (PostgreTableBase)command.getObject();
        if (command.getProperties().size() > 1 || command.getProperty((Object)"description") == null) {
            StringBuilder query = new StringBuilder("ALTER TABLE ");
            query.append(table.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" ");
            this.appendTableModifiers(table, (SQLObjectEditor.NestedObjectCommand)command, query);
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction(query.toString()));
        }
    }

    protected void addObjectExtraActions(List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<PostgreTableBase, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) {
        if (!CommonUtils.isEmpty((String)((PostgreTableBase)command.getObject()).getDescription())) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment table", "COMMENT ON TABLE " + ((PostgreTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS " + SQLUtils.quoteString((DBSObject)((DBSObject)command.getObject()), (String)((PostgreTableBase)command.getObject()).getDescription())));
        }
        for (PostgreTableColumn column : ((PostgreTableBase)command.getObject()).getCachedAttributes()) {
            if (CommonUtils.isEmpty((String)column.getDescription())) continue;
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Set column comment", "COMMENT ON COLUMN " + DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)command.getObject()), (DBPEvaluationContext)DBPEvaluationContext.DDL) + "." + DBUtils.getQuotedIdentifier((DBSObject)column) + " IS " + SQLUtils.quoteString((DBSObject)column, (String)column.getDescription())));
        }
    }

    protected void appendTableModifiers(PostgreTableBase tableBase, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl) {
        if (tableBase instanceof PostgreTableRegular) {
            VoidProgressMonitor monitor = new VoidProgressMonitor();
            PostgreTableRegular table = (PostgreTableRegular)tableBase;
            try {
                List<PostgreTableInheritance> superTables = table.getSuperInheritance((DBRProgressMonitor)monitor);
                if (!CommonUtils.isEmpty(superTables)) {
                    ddl.append("\nINHERITS (");
                    int i = 0;
                    while (i < superTables.size()) {
                        if (i > 0) {
                            ddl.append(",");
                        }
                        ddl.append(superTables.get(i).getAssociatedEntity().getFullyQualifiedName(DBPEvaluationContext.DDL));
                        ++i;
                    }
                    ddl.append(")");
                }
                ddl.append("\nWITH (\n\tOIDS=").append(table.isHasOids() ? "TRUE" : "FALSE");
                ddl.append("\n)");
                boolean hasOtherSpecs = false;
                PostgreTablespace tablespace = table.getTablespace((DBRProgressMonitor)monitor);
                if (tablespace != null && table.isTablespaceSpecified()) {
                    ddl.append("\nTABLESPACE ").append(tablespace.getName());
                    hasOtherSpecs = true;
                }
                if (hasOtherSpecs) {
                    ddl.append("\n");
                }
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
    }

    protected void addObjectRenameActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename table", "ALTER TABLE " + ((PostgreTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)((PostgreTableBase)command.getObject()).getDataSource(), (String)command.getNewName())));
    }

    @NotNull
    public Class<?>[] getChildTypes() {
        return CHILD_TYPES;
    }

    public void renameObject(DBECommandContext commandContext, PostgreTableBase object, String newName) throws DBException {
        this.processObjectRename(commandContext, object, newName);
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_table, "DROP " + (command.getObject() instanceof PostgreTableForeign ? "FOREIGN TABLE" : "TABLE") + " " + ((PostgreTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL) + (CommonUtils.getOption(options, (String)"deleteCascade") ? " CASCADE" : "")));
    }
}

